/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote.xml;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.UUID;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.remote.Receiver;
import org.openrewrite.remote.ReceiverContext;
import org.openrewrite.remote.ReceiverFactory;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public final class XmlReceiver
implements Receiver<Xml> {
    @Override
    public Xml receive(@Nullable Xml before, ReceiverContext ctx) {
        ReceiverContext forked = this.fork(ctx);
        return (Xml)forked.getVisitor().visit((Tree)before, (Object)forked);
    }

    @Override
    public ReceiverContext fork(ReceiverContext ctx) {
        return ctx.fork((TreeVisitor<?, ReceiverContext>)new Visitor(), new Factory());
    }

    @Generated
    public XmlReceiver() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof XmlReceiver;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "XmlReceiver()";
    }

    private static class Visitor
    extends XmlVisitor<ReceiverContext> {
        private Visitor() {
        }

        public @Nullable Xml visit(@Nullable Tree tree, ReceiverContext ctx) {
            Cursor cursor = new Cursor(this.getCursor(), (Object)tree);
            this.setCursor(cursor);
            tree = (Tree)ctx.receiveNode((Xml)tree, ctx::receiveTree);
            this.setCursor(cursor.getParent());
            return (Xml)tree;
        }

        public Xml.Document visitDocument(Xml.Document document, ReceiverContext ctx) {
            document = document.withId(ctx.receiveNonNullValue(document.getId(), UUID.class));
            document = document.withSourcePath(ctx.receiveNonNullValue(document.getSourcePath(), Path.class));
            document = document.withPrefixUnsafe(ctx.receiveNonNullValue(document.getPrefixUnsafe(), String.class));
            String charsetName = ctx.receiveValue((document = document.withMarkers(ctx.receiveNonNullNode(document.getMarkers(), ctx::receiveMarkers))).getCharset().name(), String.class);
            if (charsetName != null) {
                document = document.withCharset(Charset.forName(charsetName));
            }
            document = document.withCharsetBomMarked(ctx.receiveNonNullValue(document.isCharsetBomMarked(), Boolean.TYPE).booleanValue());
            document = document.withChecksum(ctx.receiveValue(document.getChecksum(), Checksum.class));
            document = document.withFileAttributes(ctx.receiveValue(document.getFileAttributes(), FileAttributes.class));
            document = document.withProlog(ctx.receiveNonNullNode(document.getProlog(), ctx::receiveTree));
            document = document.withRoot(ctx.receiveNonNullNode(document.getRoot(), ctx::receiveTree));
            document = document.withEof(ctx.receiveNonNullValue(document.getEof(), String.class));
            return document;
        }

        public Xml.Prolog visitProlog(Xml.Prolog prolog, ReceiverContext ctx) {
            prolog = prolog.withId(ctx.receiveNonNullValue(prolog.getId(), UUID.class));
            prolog = prolog.withPrefixUnsafe(ctx.receiveNonNullValue(prolog.getPrefixUnsafe(), String.class));
            prolog = prolog.withMarkers(ctx.receiveNonNullNode(prolog.getMarkers(), ctx::receiveMarkers));
            prolog = prolog.withXmlDecl(ctx.receiveNode(prolog.getXmlDecl(), ctx::receiveTree));
            prolog = prolog.withMisc(ctx.receiveNonNullNodes(prolog.getMisc(), ctx::receiveTree));
            prolog = prolog.withJspDirectives(ctx.receiveNonNullNodes(prolog.getJspDirectives(), ctx::receiveTree));
            return prolog;
        }

        public Xml.XmlDecl visitXmlDecl(Xml.XmlDecl xmlDecl, ReceiverContext ctx) {
            xmlDecl = xmlDecl.withId(ctx.receiveNonNullValue(xmlDecl.getId(), UUID.class));
            xmlDecl = xmlDecl.withPrefixUnsafe(ctx.receiveNonNullValue(xmlDecl.getPrefixUnsafe(), String.class));
            xmlDecl = xmlDecl.withMarkers(ctx.receiveNonNullNode(xmlDecl.getMarkers(), ctx::receiveMarkers));
            xmlDecl = xmlDecl.withName(ctx.receiveNonNullValue(xmlDecl.getName(), String.class));
            xmlDecl = xmlDecl.withAttributes(ctx.receiveNonNullNodes(xmlDecl.getAttributes(), ctx::receiveTree));
            xmlDecl = xmlDecl.withBeforeTagDelimiterPrefix(ctx.receiveNonNullValue(xmlDecl.getBeforeTagDelimiterPrefix(), String.class));
            return xmlDecl;
        }

        public Xml.ProcessingInstruction visitProcessingInstruction(Xml.ProcessingInstruction processingInstruction, ReceiverContext ctx) {
            processingInstruction = processingInstruction.withId(ctx.receiveNonNullValue(processingInstruction.getId(), UUID.class));
            processingInstruction = processingInstruction.withPrefixUnsafe(ctx.receiveNonNullValue(processingInstruction.getPrefixUnsafe(), String.class));
            processingInstruction = processingInstruction.withMarkers(ctx.receiveNonNullNode(processingInstruction.getMarkers(), ctx::receiveMarkers));
            processingInstruction = processingInstruction.withName(ctx.receiveNonNullValue(processingInstruction.getName(), String.class));
            processingInstruction = processingInstruction.withProcessingInstructions(ctx.receiveNonNullNode(processingInstruction.getProcessingInstructions(), ctx::receiveTree));
            processingInstruction = processingInstruction.withBeforeTagDelimiterPrefix(ctx.receiveNonNullValue(processingInstruction.getBeforeTagDelimiterPrefix(), String.class));
            return processingInstruction;
        }

        public Xml.Tag visitTag(Xml.Tag tag, ReceiverContext ctx) {
            tag = tag.withId(ctx.receiveNonNullValue(tag.getId(), UUID.class));
            tag = tag.withPrefixUnsafe(ctx.receiveNonNullValue(tag.getPrefixUnsafe(), String.class));
            tag = tag.withMarkers(ctx.receiveNonNullNode(tag.getMarkers(), ctx::receiveMarkers));
            tag = tag.withName(ctx.receiveNonNullValue(tag.getName(), String.class));
            tag = tag.withAttributes(ctx.receiveNonNullNodes(tag.getAttributes(), ctx::receiveTree));
            tag = tag.withContent(ctx.receiveNodes(tag.getContent(), ctx::receiveTree));
            tag = tag.withClosing(ctx.receiveNode(tag.getClosing(), ctx::receiveTree));
            tag = tag.withBeforeTagDelimiterPrefix(ctx.receiveNonNullValue(tag.getBeforeTagDelimiterPrefix(), String.class));
            return tag;
        }

        public Xml.Tag.Closing visitTagClosing(Xml.Tag.Closing closing, ReceiverContext ctx) {
            closing = closing.withId(ctx.receiveNonNullValue(closing.getId(), UUID.class));
            closing = closing.withPrefixUnsafe(ctx.receiveNonNullValue(closing.getPrefixUnsafe(), String.class));
            closing = closing.withMarkers(ctx.receiveNonNullNode(closing.getMarkers(), ctx::receiveMarkers));
            closing = closing.withName(ctx.receiveNonNullValue(closing.getName(), String.class));
            closing = closing.withBeforeTagDelimiterPrefix(ctx.receiveNonNullValue(closing.getBeforeTagDelimiterPrefix(), String.class));
            return closing;
        }

        public Xml.Attribute visitAttribute(Xml.Attribute attribute, ReceiverContext ctx) {
            attribute = attribute.withId(ctx.receiveNonNullValue(attribute.getId(), UUID.class));
            attribute = attribute.withPrefixUnsafe(ctx.receiveNonNullValue(attribute.getPrefixUnsafe(), String.class));
            attribute = attribute.withMarkers(ctx.receiveNonNullNode(attribute.getMarkers(), ctx::receiveMarkers));
            attribute = attribute.withKey(ctx.receiveNonNullNode(attribute.getKey(), ctx::receiveTree));
            attribute = attribute.withBeforeEquals(ctx.receiveNonNullValue(attribute.getBeforeEquals(), String.class));
            attribute = attribute.withValue(ctx.receiveNonNullNode(attribute.getValue(), ctx::receiveTree));
            return attribute;
        }

        public Xml.Attribute.Value visitAttributeValue(Xml.Attribute.Value value, ReceiverContext ctx) {
            value = value.withId(ctx.receiveNonNullValue(value.getId(), UUID.class));
            value = value.withPrefixUnsafe(ctx.receiveNonNullValue(value.getPrefixUnsafe(), String.class));
            value = value.withMarkers(ctx.receiveNonNullNode(value.getMarkers(), ctx::receiveMarkers));
            value = value.withQuote(ctx.receiveNonNullValue(value.getQuote(), Xml.Attribute.Value.Quote.class));
            value = value.withValue(ctx.receiveNonNullValue(value.getValue(), String.class));
            return value;
        }

        public Xml.CharData visitCharData(Xml.CharData charData, ReceiverContext ctx) {
            charData = charData.withId(ctx.receiveNonNullValue(charData.getId(), UUID.class));
            charData = charData.withPrefixUnsafe(ctx.receiveNonNullValue(charData.getPrefixUnsafe(), String.class));
            charData = charData.withMarkers(ctx.receiveNonNullNode(charData.getMarkers(), ctx::receiveMarkers));
            charData = charData.withCdata(ctx.receiveNonNullValue(charData.isCdata(), Boolean.TYPE).booleanValue());
            charData = charData.withText(ctx.receiveNonNullValue(charData.getText(), String.class));
            charData = charData.withAfterText(ctx.receiveNonNullValue(charData.getAfterText(), String.class));
            return charData;
        }

        public Xml.Comment visitComment(Xml.Comment comment, ReceiverContext ctx) {
            comment = comment.withId(ctx.receiveNonNullValue(comment.getId(), UUID.class));
            comment = comment.withPrefixUnsafe(ctx.receiveNonNullValue(comment.getPrefixUnsafe(), String.class));
            comment = comment.withMarkers(ctx.receiveNonNullNode(comment.getMarkers(), ctx::receiveMarkers));
            comment = comment.withText(ctx.receiveNonNullValue(comment.getText(), String.class));
            return comment;
        }

        public Xml.DocTypeDecl visitDocTypeDecl(Xml.DocTypeDecl docTypeDecl, ReceiverContext ctx) {
            docTypeDecl = docTypeDecl.withId(ctx.receiveNonNullValue(docTypeDecl.getId(), UUID.class));
            docTypeDecl = docTypeDecl.withPrefixUnsafe(ctx.receiveNonNullValue(docTypeDecl.getPrefixUnsafe(), String.class));
            docTypeDecl = docTypeDecl.withMarkers(ctx.receiveNonNullNode(docTypeDecl.getMarkers(), ctx::receiveMarkers));
            docTypeDecl = docTypeDecl.withName(ctx.receiveNonNullNode(docTypeDecl.getName(), ctx::receiveTree));
            docTypeDecl = docTypeDecl.withExternalId(ctx.receiveNode(docTypeDecl.getExternalId(), ctx::receiveTree));
            docTypeDecl = docTypeDecl.withInternalSubset(ctx.receiveNonNullNodes(docTypeDecl.getInternalSubset(), ctx::receiveTree));
            docTypeDecl = docTypeDecl.withExternalSubsets(ctx.receiveNode(docTypeDecl.getExternalSubsets(), ctx::receiveTree));
            docTypeDecl = docTypeDecl.withBeforeTagDelimiterPrefix(ctx.receiveNonNullValue(docTypeDecl.getBeforeTagDelimiterPrefix(), String.class));
            return docTypeDecl;
        }

        public Xml.DocTypeDecl.ExternalSubsets visitDocTypeDeclExternalSubsets(Xml.DocTypeDecl.ExternalSubsets externalSubsets, ReceiverContext ctx) {
            externalSubsets = externalSubsets.withId(ctx.receiveNonNullValue(externalSubsets.getId(), UUID.class));
            externalSubsets = externalSubsets.withPrefixUnsafe(ctx.receiveNonNullValue(externalSubsets.getPrefixUnsafe(), String.class));
            externalSubsets = externalSubsets.withMarkers(ctx.receiveNonNullNode(externalSubsets.getMarkers(), ctx::receiveMarkers));
            externalSubsets = externalSubsets.withElements(ctx.receiveNonNullNodes(externalSubsets.getElements(), ctx::receiveTree));
            return externalSubsets;
        }

        public Xml.Element visitElement(Xml.Element element, ReceiverContext ctx) {
            element = element.withId(ctx.receiveNonNullValue(element.getId(), UUID.class));
            element = element.withPrefixUnsafe(ctx.receiveNonNullValue(element.getPrefixUnsafe(), String.class));
            element = element.withMarkers(ctx.receiveNonNullNode(element.getMarkers(), ctx::receiveMarkers));
            element = element.withSubset(ctx.receiveNonNullNodes(element.getSubset(), ctx::receiveTree));
            element = element.withBeforeTagDelimiterPrefix(ctx.receiveNonNullValue(element.getBeforeTagDelimiterPrefix(), String.class));
            return element;
        }

        public Xml.Ident visitIdent(Xml.Ident ident, ReceiverContext ctx) {
            ident = ident.withId(ctx.receiveNonNullValue(ident.getId(), UUID.class));
            ident = ident.withPrefixUnsafe(ctx.receiveNonNullValue(ident.getPrefixUnsafe(), String.class));
            ident = ident.withMarkers(ctx.receiveNonNullNode(ident.getMarkers(), ctx::receiveMarkers));
            ident = ident.withName(ctx.receiveNonNullValue(ident.getName(), String.class));
            return ident;
        }

        public Xml.JspDirective visitJspDirective(Xml.JspDirective jspDirective, ReceiverContext ctx) {
            jspDirective = jspDirective.withId(ctx.receiveNonNullValue(jspDirective.getId(), UUID.class));
            jspDirective = jspDirective.withPrefixUnsafe(ctx.receiveNonNullValue(jspDirective.getPrefixUnsafe(), String.class));
            jspDirective = jspDirective.withMarkers(ctx.receiveNonNullNode(jspDirective.getMarkers(), ctx::receiveMarkers));
            jspDirective = jspDirective.withBeforeTypePrefix(ctx.receiveNonNullValue(jspDirective.getBeforeTypePrefix(), String.class));
            jspDirective = jspDirective.withType(ctx.receiveNonNullValue(jspDirective.getType(), String.class));
            jspDirective = jspDirective.withAttributes(ctx.receiveNonNullNodes(jspDirective.getAttributes(), ctx::receiveTree));
            jspDirective = jspDirective.withBeforeDirectiveEndPrefix(ctx.receiveNonNullValue(jspDirective.getBeforeDirectiveEndPrefix(), String.class));
            return jspDirective;
        }
    }

    private static class Factory
    implements ReceiverFactory {
        private Factory() {
        }

        @Override
        public <T> T create(Class<T> type, ReceiverContext ctx) {
            if (type == Xml.Document.class) {
                return (T)new Xml.Document(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, Path.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveValue(null, String.class), ctx.receiveNonNullValue(null, Boolean.TYPE).booleanValue(), ctx.receiveValue(null, Checksum.class), ctx.receiveValue(null, FileAttributes.class), ctx.receiveNonNullNode(null, ctx::receiveTree), ctx.receiveNonNullNode(null, ctx::receiveTree), ctx.receiveNonNullValue(null, String.class));
            }
            if (type == Xml.Prolog.class) {
                return (T)new Xml.Prolog(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNode(null, ctx::receiveTree), ctx.receiveNonNullNodes(null, ctx::receiveTree), ctx.receiveNonNullNodes(null, ctx::receiveTree));
            }
            if (type == Xml.XmlDecl.class) {
                return (T)new Xml.XmlDecl(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNodes(null, ctx::receiveTree), ctx.receiveNonNullValue(null, String.class));
            }
            if (type == Xml.ProcessingInstruction.class) {
                return (T)new Xml.ProcessingInstruction(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveTree), ctx.receiveNonNullValue(null, String.class));
            }
            if (type == Xml.Tag.class) {
                return (T)new Xml.Tag(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNodes(null, ctx::receiveTree), ctx.receiveNodes(null, ctx::receiveTree), ctx.receiveNode(null, ctx::receiveTree), ctx.receiveNonNullValue(null, String.class));
            }
            if (type == Xml.Tag.Closing.class) {
                return (T)new Xml.Tag.Closing(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullValue(null, String.class));
            }
            if (type == Xml.Attribute.class) {
                return (T)new Xml.Attribute(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullNode(null, ctx::receiveTree), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveTree));
            }
            if (type == Xml.Attribute.Value.class) {
                return (T)new Xml.Attribute.Value(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullValue(null, Xml.Attribute.Value.Quote.class), ctx.receiveNonNullValue(null, String.class));
            }
            if (type == Xml.CharData.class) {
                return (T)new Xml.CharData(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullValue(null, Boolean.TYPE).booleanValue(), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullValue(null, String.class));
            }
            if (type == Xml.Comment.class) {
                return (T)new Xml.Comment(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullValue(null, String.class));
            }
            if (type == Xml.DocTypeDecl.class) {
                return (T)new Xml.DocTypeDecl(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullNode(null, ctx::receiveTree), ctx.receiveNode(null, ctx::receiveTree), ctx.receiveNonNullNodes(null, ctx::receiveTree), ctx.receiveNode(null, ctx::receiveTree), ctx.receiveNonNullValue(null, String.class));
            }
            if (type == Xml.DocTypeDecl.ExternalSubsets.class) {
                return (T)new Xml.DocTypeDecl.ExternalSubsets(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullNodes(null, ctx::receiveTree));
            }
            if (type == Xml.Element.class) {
                return (T)new Xml.Element(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullNodes(null, ctx::receiveTree), ctx.receiveNonNullValue(null, String.class));
            }
            if (type == Xml.Ident.class) {
                return (T)new Xml.Ident(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullValue(null, String.class));
            }
            if (type == Xml.JspDirective.class) {
                return (T)new Xml.JspDirective(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNodes(null, ctx::receiveTree), ctx.receiveNonNullValue(null, String.class));
            }
            throw new IllegalArgumentException("Unknown type: " + type);
        }
    }
}

