/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote.properties;

import java.util.function.Function;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.remote.Sender;
import org.openrewrite.remote.SenderContext;

public final class PropertiesSender
implements Sender<Properties> {
    @Override
    public void send(Properties after, @Nullable Properties before, SenderContext ctx) {
        Visitor visitor = new Visitor();
        visitor.visit((Tree)after, ctx.fork((TreeVisitor<?, SenderContext>)visitor, (Tree)before));
        ctx.flush();
    }

    @Generated
    public PropertiesSender() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof PropertiesSender;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "PropertiesSender()";
    }

    private static class Visitor
    extends PropertiesVisitor<SenderContext> {
        private Visitor() {
        }

        public @Nullable Properties visit(@Nullable Tree tree, SenderContext ctx) {
            this.setCursor(new Cursor(this.getCursor(), (Object)tree));
            ctx.sendNode(tree, Function.identity(), ctx::sendTree);
            this.setCursor(this.getCursor().getParent());
            return (Properties)tree;
        }

        public Properties.File visitFile(Properties.File file, SenderContext ctx) {
            ctx.sendValue(file, Properties.File::getId);
            ctx.sendValue(file, Properties.File::getPrefix);
            ctx.sendNode(file, Properties.File::getMarkers, ctx::sendMarkers);
            ctx.sendValue(file, Properties.File::getSourcePath);
            ctx.sendNodes(file, Properties.File::getContent, ctx::sendTree, Tree::getId);
            ctx.sendValue(file, Properties.File::getEof);
            ctx.sendValue(file, e -> e.getCharset() != null ? e.getCharset().name() : "UTF-8");
            ctx.sendValue(file, Properties.File::isCharsetBomMarked);
            ctx.sendTypedValue(file, Properties.File::getFileAttributes);
            ctx.sendTypedValue(file, Properties.File::getChecksum);
            return file;
        }

        public Properties.Entry visitEntry(Properties.Entry entry, SenderContext ctx) {
            ctx.sendValue(entry, Properties.Entry::getId);
            ctx.sendValue(entry, Properties.Entry::getPrefix);
            ctx.sendNode(entry, Properties.Entry::getMarkers, ctx::sendMarkers);
            ctx.sendValue(entry, Properties.Entry::getKey);
            ctx.sendValue(entry, Properties.Entry::getBeforeEquals);
            ctx.sendValue(entry, Properties.Entry::getDelimiter);
            ctx.sendTypedValue(entry, Properties.Entry::getValue);
            return entry;
        }

        public Properties.Value visitValue(Properties.Value value, SenderContext ctx) {
            ctx.sendValue(value, Properties.Value::getId);
            ctx.sendValue(value, Properties.Value::getPrefix);
            ctx.sendNode(value, Properties.Value::getMarkers, ctx::sendMarkers);
            ctx.sendValue(value, Properties.Value::getText);
            return value;
        }

        public Properties.Comment visitComment(Properties.Comment comment, SenderContext ctx) {
            ctx.sendValue(comment, Properties.Comment::getId);
            ctx.sendValue(comment, Properties.Comment::getPrefix);
            ctx.sendNode(comment, Properties.Comment::getMarkers, ctx::sendMarkers);
            ctx.sendValue(comment, Properties.Comment::getDelimiter);
            ctx.sendValue(comment, Properties.Comment::getMessage);
            return comment;
        }
    }
}

