/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.remote.model.LstType;

public interface LstModel {

    public static final class Info {
        private final int id;
        private final String name;
        private final String shortName;
        private final Class<? extends Tree> modelClass;
        private final @Nullable Info extended;
        private final List<LstType.Info> types;

        private Info(int id, String name, String shortName, Class<? extends Tree> modelClass, @Nullable Info extended, List<LstType.Info> types) {
            this.id = id;
            this.name = name;
            this.shortName = shortName;
            this.modelClass = modelClass;
            this.extended = extended;
            this.types = Collections.unmodifiableList(types);
        }

        @Generated
        public static InfoBuilder builder() {
            return new InfoBuilder();
        }

        @Generated
        public int getId() {
            return this.id;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getShortName() {
            return this.shortName;
        }

        @Generated
        public Class<? extends Tree> getModelClass() {
            return this.modelClass;
        }

        @Generated
        public @Nullable Info getExtended() {
            return this.extended;
        }

        @Generated
        public List<LstType.Info> getTypes() {
            return this.types;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Info)) {
                return false;
            }
            Info other = (Info)o;
            if (this.getId() != other.getId()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$shortName = this.getShortName();
            String other$shortName = other.getShortName();
            if (this$shortName == null ? other$shortName != null : !this$shortName.equals(other$shortName)) {
                return false;
            }
            Class<? extends Tree> this$modelClass = this.getModelClass();
            Class<? extends Tree> other$modelClass = other.getModelClass();
            if (this$modelClass == null ? other$modelClass != null : !this$modelClass.equals(other$modelClass)) {
                return false;
            }
            Info this$extended = this.getExtended();
            Info other$extended = other.getExtended();
            if (this$extended == null ? other$extended != null : !((Object)this$extended).equals(other$extended)) {
                return false;
            }
            List<LstType.Info> this$types = this.getTypes();
            List<LstType.Info> other$types = other.getTypes();
            return !(this$types == null ? other$types != null : !((Object)this$types).equals(other$types));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getId();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $shortName = this.getShortName();
            result = result * 59 + ($shortName == null ? 43 : $shortName.hashCode());
            Class<? extends Tree> $modelClass = this.getModelClass();
            result = result * 59 + ($modelClass == null ? 43 : $modelClass.hashCode());
            Info $extended = this.getExtended();
            result = result * 59 + ($extended == null ? 43 : ((Object)$extended).hashCode());
            List<LstType.Info> $types = this.getTypes();
            result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LstModel.Info(id=" + this.getId() + ", name=" + this.getName() + ", shortName=" + this.getShortName() + ", modelClass=" + this.getModelClass() + ", extended=" + this.getExtended() + ", types=" + this.getTypes() + ")";
        }

        @Generated
        public static class InfoBuilder {
            @Generated
            private int id;
            @Generated
            private String name;
            @Generated
            private String shortName;
            @Generated
            private Class<? extends Tree> modelClass;
            @Generated
            private Info extended;
            @Generated
            private ArrayList<LstType.Info> types;

            @Generated
            InfoBuilder() {
            }

            @Generated
            public InfoBuilder id(int id) {
                this.id = id;
                return this;
            }

            @Generated
            public InfoBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public InfoBuilder shortName(String shortName) {
                this.shortName = shortName;
                return this;
            }

            @Generated
            public InfoBuilder modelClass(Class<? extends Tree> modelClass) {
                this.modelClass = modelClass;
                return this;
            }

            @Generated
            public InfoBuilder extended(@Nullable Info extended) {
                this.extended = extended;
                return this;
            }

            @Generated
            public InfoBuilder type(LstType.Info type) {
                if (this.types == null) {
                    this.types = new ArrayList();
                }
                this.types.add(type);
                return this;
            }

            @Generated
            public InfoBuilder types(Collection<? extends LstType.Info> types) {
                if (types == null) {
                    throw new NullPointerException("types cannot be null");
                }
                if (this.types == null) {
                    this.types = new ArrayList();
                }
                this.types.addAll(types);
                return this;
            }

            @Generated
            public InfoBuilder clearTypes() {
                if (this.types != null) {
                    this.types.clear();
                }
                return this;
            }

            @Generated
            public Info build() {
                List<Object> types;
                switch (this.types == null ? 0 : this.types.size()) {
                    case 0: {
                        types = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        types = Collections.singletonList(this.types.get(0));
                        break;
                    }
                    default: {
                        types = Collections.unmodifiableList(new ArrayList<LstType.Info>(this.types));
                    }
                }
                return new Info(this.id, this.name, this.shortName, this.modelClass, this.extended, types);
            }

            @Generated
            public String toString() {
                return "LstModel.Info.InfoBuilder(id=" + this.id + ", name=" + this.name + ", shortName=" + this.shortName + ", modelClass=" + this.modelClass + ", extended=" + this.extended + ", types=" + this.types + ")";
            }
        }

        public static enum Registry {
            INSTANCE;

            private final Map<Class<? extends Tree>, Info> modelClassMap = new HashMap<Class<? extends Tree>, Info>();
            private final ArrayList<@Nullable Info> idMap = new ArrayList();
            private final Map<Class<? extends Tree>, LstType.Info> typeInfoByClassMap = new HashMap<Class<? extends Tree>, LstType.Info>();
            private final ClassValue<Integer> propertyCountByClass = new ClassValue<Integer>(){

                @Override
                protected Integer computeValue(Class<?> type) {
                    return ((LstType.Info)typeInfoByClassMap.get(type)).getProperties().size();
                }
            };
            private final ClassValue<Integer> typeIdByClass = new ClassValue<Integer>(){

                @Override
                protected Integer computeValue(Class<?> type) {
                    return ((LstType.Info)typeInfoByClassMap.get(type)).getId();
                }
            };

            public void register(Info info) {
                Registry.INSTANCE.modelClassMap.put(info.getModelClass(), info);
                if (info.getId() >= Registry.INSTANCE.idMap.size()) {
                    Registry.INSTANCE.idMap.addAll(Collections.nCopies(info.getId() - Registry.INSTANCE.idMap.size() + 1, null));
                } else if (Registry.INSTANCE.idMap.get(info.getId()) != null) {
                    throw new IllegalArgumentException("Duplicate id " + info.getId() + " for " + info.getModelClass());
                }
                Registry.INSTANCE.idMap.set(info.getId(), info);
                List<LstType.Info> infoTypes = info.getTypes();
                for (LstType.Info type : infoTypes) {
                    Registry.INSTANCE.typeInfoByClassMap.put(type.getType(), type);
                }
            }

            public int getTypeId(Class<? extends Tree> type) {
                return Registry.INSTANCE.typeIdByClass.get(type);
            }

            public int getTypePropertyCount(Class<? extends Tree> type) {
                return Registry.INSTANCE.propertyCountByClass.get(type);
            }
        }
    }
}

