/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PathModule
extends SimpleModule {
    public PathModule() {
        this.addSerializer(Path.class, new PathSerializer());
        this.addDeserializer(Path.class, new PathDeserializer());
    }

    private static class PathSerializer
    extends JsonSerializer<Path> {
        private PathSerializer() {
        }

        public void serialize(Path value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.toString());
        }
    }

    private static class PathDeserializer
    extends JsonDeserializer<Path> {
        private PathDeserializer() {
        }

        public Path deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return Paths.get(p.getValueAsString(), new String[0]);
        }
    }
}

