/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Random;
import javax.net.ServerSocketFactory;

public class TcpUtils {
    private static final Random random = new Random(System.nanoTime());
    private static final int PORT_RANGE_MIN = 1024;
    private static final int PORT_RANGE_MAX = 65535;
    private static final int MAX_TRIES = 1000;

    public static int findAvailableTcpPortInternal() {
        for (int i = 0; i < 1000; ++i) {
            int candidatePort = 1024 + random.nextInt(64511);
            if (!TcpUtils.isPortAvailable(candidatePort)) continue;
            return candidatePort;
        }
        throw new IllegalStateException(String.format("Could not find an available TCP port in the range [%d, %d] after %d attempts", 1024, 65535, 1000));
    }

    public static boolean isPortAvailable(int port) {
        boolean bl;
        block8: {
            ServerSocket ignored = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));
            try {
                bl = true;
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception var2) {
                    return false;
                }
            }
            ignored.close();
        }
        return bl;
    }
}

