/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openrewrite.Tree;
import org.openrewrite.remote.Receiver;
import org.openrewrite.remote.Sender;
import org.openrewrite.remote.Validator;

public interface SenderReceiverProvider<T extends Tree> {
    public static Registry registry() {
        return Registry.INSTANCE;
    }

    public Class<T> getType();

    public Sender<T> newSender();

    public Receiver<T> newReceiver();

    default public Validator newValidator() {
        return Validator.noop();
    }

    public static enum Registry {
        INSTANCE;

        final SortedMap<Class<?>, SenderReceiverProvider<?>> store = new TreeMap(new TypeComparer());

        private Registry() {
            ServiceLoader<SenderReceiverProvider> serviceLoader = ServiceLoader.load(SenderReceiverProvider.class);
            for (SenderReceiverProvider senderReceiverProvider : serviceLoader) {
                this.store.put(senderReceiverProvider.getType(), senderReceiverProvider);
            }
        }

        <T extends Tree> SenderReceiverProvider<T> findCompatibleProvider(Class<?> type) {
            Optional<Map.Entry> entryOptional = this.store.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(type)).findFirst();
            if (!entryOptional.isPresent()) {
                throw new IllegalStateException("Unsupported LST type: " + type);
            }
            return (SenderReceiverProvider)entryOptional.get().getValue();
        }
    }

    public static class TypeComparer
    implements Comparator<Class<?>> {
        @Override
        public int compare(Class<?> x, Class<?> y) {
            return x == y ? 0 : (x.isAssignableFrom(y) ? 1 : -1);
        }
    }
}

