/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import com.fasterxml.jackson.core.type.TypeReference;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.remote.InstallableRemotingRecipe;
import org.openrewrite.remote.PackageSource;
import org.openrewrite.remote.RemotingExecutionContextView;
import org.openrewrite.remote.RemotingMessenger;
import org.openrewrite.remote.RemotingRecipe;
import org.openrewrite.remote.RemotingServerEngine;
import org.openrewrite.remote.ResolvedPackageVersion;

public class RemotingRecipeManager {
    final RemotingServerEngine remotingServerEngine;
    final Supplier<? extends RemotingServerEngine> serverEngineSupplier;

    public RemotingRecipeManager(RemotingServerEngine remotingServerEngine, Supplier<? extends RemotingServerEngine> serverEngineSupplier) {
        this.remotingServerEngine = remotingServerEngine;
        this.serverEngineSupplier = serverEngineSupplier;
    }

    public InstallableRemotingRecipe install(String packageId, String packageVersion, List<PackageSource> packageSources, boolean includeDefaultRepository, ExecutionContext ctx) {
        RemotingExecutionContextView view = RemotingExecutionContextView.view(ctx);
        Socket socket = view.getOrCreateSocket(this.remotingServerEngine);
        RemotingMessenger messenger = view.getOrCreateRemotingMessenger();
        return Objects.requireNonNull(messenger.sendRequest(generator -> {
            generator.writeString("recipe-install");
            generator.writeString(packageId);
            generator.writeString(packageVersion);
            generator.writeBoolean(includeDefaultRepository);
            generator.writeStartArray();
            for (int i = 0; i < packageSources.size(); ++i) {
                PackageSource packageSource = (PackageSource)packageSources.get(i);
                generator.writeObject((Object)packageSource);
            }
            generator.writeEndArray();
        }, parser -> {
            parser.nextToken();
            Map installableRemoteRecipe = (Map)parser.readValueAs((TypeReference)new TypeReference<Map<String, Object>>(){});
            List recipesDescriptors = (List)installableRemoteRecipe.get("recipes");
            String repository = installableRemoteRecipe.get("repository").toString();
            String version = installableRemoteRecipe.get("version").toString();
            List<Recipe> recipes = recipesDescriptors.stream().map(rawRecipe -> {
                String recipeName = rawRecipe.get("name").toString();
                URI source = URI.create(rawRecipe.get("source").toString());
                List options = (List)rawRecipe.get("options");
                return new RemotingRecipe(new RecipeDescriptor(recipeName, recipeName, recipeName, recipeName, Collections.emptySet(), null, options.stream().map(odm -> new OptionDescriptor(odm.get("name").toString(), odm.get("type").toString(), odm.getOrDefault("name", "").toString(), odm.getOrDefault("description", "").toString(), null, null, ((Boolean)odm.get("required")).booleanValue(), odm.getOrDefault("value", null))).collect(Collectors.toList()), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), source), this.serverEngineSupplier, this.remotingServerEngine.getClass());
            }).collect(Collectors.toList());
            return new InstallableRemotingRecipe(recipes, new ResolvedPackageVersion(new URL(repository), packageId, version, null));
        }, socket));
    }
}

