/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import java.lang.reflect.Field;
import java.net.Socket;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.remote.RemotingContext;
import org.openrewrite.remote.RemotingExecutionContextView;
import org.openrewrite.remote.RemotingMessenger;
import org.openrewrite.remote.RemotingServerEngine;

public final class RemotingRecipe
extends Recipe {
    static final Field DESCRIPTOR_FIELD;
    private final RecipeDescriptor recipeDescriptor;
    private final Supplier<? extends RemotingServerEngine> remotingServerEngineSupplier;
    private final Class<? extends RemotingServerEngine> remotingEngineType;

    public RemotingRecipe(RecipeDescriptor recipeDescriptor, Supplier<? extends RemotingServerEngine> remotingServerEngineSupplier, Class<? extends RemotingServerEngine> remotingEngineType) {
        this.recipeDescriptor = recipeDescriptor;
        this.remotingServerEngineSupplier = remotingServerEngineSupplier;
        this.remotingEngineType = remotingEngineType;
        try {
            DESCRIPTOR_FIELD.set((Object)this, recipeDescriptor);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.recipeDescriptor.getName();
    }

    public String getDisplayName() {
        return this.recipeDescriptor.getDisplayName();
    }

    public String getDescription() {
        return this.recipeDescriptor.getDescription();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    SourceFile sourceFile = (SourceFile)tree;
                    return RemotingRecipe.this.runRecipe(RemotingRecipe.this.recipeDescriptor, sourceFile, ctx);
                }
                return tree;
            }
        };
    }

    private <T extends SourceFile> T runRecipe(RecipeDescriptor recipe, T sourceFile, ExecutionContext ctx) {
        RemotingExecutionContextView view = RemotingExecutionContextView.view(ctx);
        Socket activeSocket = view.getOrCreateSocket(this.remotingEngineType, this.remotingServerEngineSupplier);
        RemotingMessenger messenger = view.getOrCreateRemotingMessenger();
        SourceFile remoteState = (SourceFile)view.getMessage("remote-state");
        if (remoteState != null && !remoteState.equals(sourceFile)) {
            remoteState = null;
            view.putMessage("remote-state", null);
        }
        remoteState = this.runRecipe0(recipe, sourceFile, remoteState, activeSocket, messenger, view);
        view.putMessage("remote-state", remoteState);
        return (T)remoteState;
    }

    private <T extends SourceFile> T runRecipe0(RecipeDescriptor recipe, T sourceFile, @Nullable T remoteState, Socket socket, RemotingMessenger messenger, RemotingExecutionContextView view) {
        RemotingContext context = Objects.requireNonNull(view.getRemotingContext());
        return (T)Objects.requireNonNull(messenger.sendRequest(generator -> {
            generator.writeString("run-recipe-load-and-visitor");
            generator.writeString(recipe.getName());
            generator.writeString(recipe.getSource().toString());
            generator.writeStartObject();
            List options = recipe.getOptions();
            for (OptionDescriptor option : options) {
                generator.writeFieldName(option.getName());
                generator.writeObject(option.getValue());
            }
            generator.writeEndObject();
            RemotingMessenger.sendTree(context, generator, sourceFile, remoteState);
        }, parser -> RemotingMessenger.receiveTree(context, parser, sourceFile), socket));
    }

    @Generated
    public RecipeDescriptor getRecipeDescriptor() {
        return this.recipeDescriptor;
    }

    @Generated
    public Supplier<? extends RemotingServerEngine> getRemotingServerEngineSupplier() {
        return this.remotingServerEngineSupplier;
    }

    @Generated
    public Class<? extends RemotingServerEngine> getRemotingEngineType() {
        return this.remotingEngineType;
    }

    @Generated
    public String toString() {
        return "RemotingRecipe(recipeDescriptor=" + this.getRecipeDescriptor() + ", remotingServerEngineSupplier=" + this.getRemotingServerEngineSupplier() + ", remotingEngineType=" + this.getRemotingEngineType() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemotingRecipe)) {
            return false;
        }
        RemotingRecipe other = (RemotingRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        RecipeDescriptor this$recipeDescriptor = this.getRecipeDescriptor();
        RecipeDescriptor other$recipeDescriptor = other.getRecipeDescriptor();
        if (this$recipeDescriptor == null ? other$recipeDescriptor != null : !this$recipeDescriptor.equals(other$recipeDescriptor)) {
            return false;
        }
        Supplier<? extends RemotingServerEngine> this$remotingServerEngineSupplier = this.getRemotingServerEngineSupplier();
        Supplier<? extends RemotingServerEngine> other$remotingServerEngineSupplier = other.getRemotingServerEngineSupplier();
        if (this$remotingServerEngineSupplier == null ? other$remotingServerEngineSupplier != null : !this$remotingServerEngineSupplier.equals(other$remotingServerEngineSupplier)) {
            return false;
        }
        Class<? extends RemotingServerEngine> this$remotingEngineType = this.getRemotingEngineType();
        Class<? extends RemotingServerEngine> other$remotingEngineType = other.getRemotingEngineType();
        return !(this$remotingEngineType == null ? other$remotingEngineType != null : !this$remotingEngineType.equals(other$remotingEngineType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemotingRecipe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RecipeDescriptor $recipeDescriptor = this.getRecipeDescriptor();
        result = result * 59 + ($recipeDescriptor == null ? 43 : $recipeDescriptor.hashCode());
        Supplier<? extends RemotingServerEngine> $remotingServerEngineSupplier = this.getRemotingServerEngineSupplier();
        result = result * 59 + ($remotingServerEngineSupplier == null ? 43 : $remotingServerEngineSupplier.hashCode());
        Class<? extends RemotingServerEngine> $remotingEngineType = this.getRemotingEngineType();
        result = result * 59 + ($remotingEngineType == null ? 43 : $remotingEngineType.hashCode());
        return result;
    }

    static {
        try {
            DESCRIPTOR_FIELD = Recipe.class.getDeclaredField("descriptor");
            DESCRIPTOR_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

