/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.remote.RemotingContext;
import org.openrewrite.remote.RemotingExecutionContextView;
import org.openrewrite.remote.RemotingMessenger;
import org.openrewrite.remote.RemotingParser;
import org.openrewrite.remote.RemotingServerEngine;
import org.openrewrite.tree.ParseError;

public final class RemotingProjectParser {
    private final RemotingServerEngine remotingServerEngine;

    public Stream<Path> findAllProjects(Path rootProjectFile, ExecutionContext ctx) {
        this.remotingServerEngine.start();
        RemotingExecutionContextView view = RemotingExecutionContextView.view(ctx);
        Socket socket = view.getOrCreateSocket(this.remotingServerEngine);
        RemotingMessenger messenger = view.getOrCreateRemotingMessenger();
        return Objects.requireNonNull(messenger.sendRequest(generator -> {
            generator.writeString("list-projects");
            generator.writeString(rootProjectFile.toString());
        }, parser -> {
            parser.nextToken();
            String[] projects = (String[])parser.readValueAs(String[].class);
            return Arrays.stream(projects).map(x$0 -> Paths.get(x$0, new String[0]));
        }, socket));
    }

    public Stream<SourceFile> parseProjectSources(Path projectFilePath, Path rootProjectFilePath, Path repositoryDir, ExecutionContext ctx) {
        this.remotingServerEngine.start();
        RemotingExecutionContextView view = RemotingExecutionContextView.view(ctx);
        RemotingContext remotingContext = view.getOrCreateRemotingContext();
        Socket activeSocket = view.getOrCreateSocket(this.remotingServerEngine);
        RemotingMessenger messenger = view.getOrCreateRemotingMessenger();
        return Objects.requireNonNull(messenger.sendRequest(generator -> {
            generator.writeString("parse-project-sources");
            generator.writeString(projectFilePath.toString());
            generator.writeString(rootProjectFilePath.toString());
            generator.writeString(repositoryDir.toString());
        }, parser -> {
            parser.nextToken();
            int count = parser.getIntValue();
            HelperParser parserAdapter = new HelperParser(remotingContext, parser, this.remotingServerEngine);
            ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>(count);
            for (int i = 0; i < count; ++i) {
                sourceFiles.add(parserAdapter.receiveNext(repositoryDir, ctx));
            }
            return sourceFiles.stream();
        }, activeSocket));
    }

    @Generated
    public RemotingProjectParser(RemotingServerEngine remotingServerEngine) {
        this.remotingServerEngine = remotingServerEngine;
    }

    @Generated
    public RemotingServerEngine getRemotingServerEngine() {
        return this.remotingServerEngine;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemotingProjectParser)) {
            return false;
        }
        RemotingProjectParser other = (RemotingProjectParser)o;
        RemotingServerEngine this$remotingServerEngine = this.getRemotingServerEngine();
        RemotingServerEngine other$remotingServerEngine = other.getRemotingServerEngine();
        return !(this$remotingServerEngine == null ? other$remotingServerEngine != null : !this$remotingServerEngine.equals(other$remotingServerEngine));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RemotingServerEngine $remotingServerEngine = this.getRemotingServerEngine();
        result = result * 59 + ($remotingServerEngine == null ? 43 : $remotingServerEngine.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RemotingProjectParser(remotingServerEngine=" + this.getRemotingServerEngine() + ")";
    }

    private static class HelperParser
    extends RemotingParser {
        private final RemotingContext remotingContext;
        private final CBORParser parser;

        public HelperParser(RemotingContext remotingContext, CBORParser parser, RemotingServerEngine remotingServerEngine) {
            super(remotingServerEngine);
            this.remotingContext = remotingContext;
            this.parser = parser;
        }

        public SourceFile receiveNext(Path relativeTo, ExecutionContext ctx) throws IOException {
            SourceFile sourceFile = RemotingMessenger.receiveTree(this.remotingContext, this.parser, null);
            Path path = relativeTo.resolve(sourceFile.getSourcePath());
            Parser.Input input = new Parser.Input(path, () -> {
                try {
                    return new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            return (sourceFile = sourceFile.withFileAttributes(input.getFileAttributes())) instanceof ParseError ? sourceFile : this.requirePrintEqualsInput(sourceFile, input, relativeTo, ctx);
        }

        public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
            return Stream.empty();
        }

        public boolean accept(Path path) {
            return true;
        }

        public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
            return Paths.get("Source.file", new String[0]);
        }
    }
}

