/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import java.nio.file.Path;
import java.util.Collections;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Parser;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.ExceptionUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.marker.Markers;
import org.openrewrite.remote.RemotingServerEngine;
import org.openrewrite.tree.ParseError;

abstract class RemotingParser
implements Parser {
    protected final RemotingServerEngine remotingServerEngine;

    RemotingParser(RemotingServerEngine remotingServerEngine) {
        this.remotingServerEngine = remotingServerEngine;
    }

    public SourceFile requirePrintEqualsInput(SourceFile sourceFile, Parser.Input input, @Nullable Path relativeTo, ExecutionContext ctx) {
        if (((Boolean)ctx.getMessage("org.openrewrite.requirePrintEqualsInput", (Object)true)).booleanValue() && !sourceFile.printEqualsInput(input, ctx)) {
            EncodingDetectingInputStream is = input.getSource(ctx);
            String sourceText = is.readFully();
            String diff = Result.diff((String)sourceText, (String)sourceFile.printAll(), (Path)input.getPath());
            return this.buildParseError(sourceFile, input, relativeTo, ctx, new IllegalStateException(sourceFile.getSourcePath() + " is not print idempotent. \n" + diff), is.isCharsetBomMarked(), sourceText);
        }
        return sourceFile;
    }

    protected ParseError buildParseError(@Nullable SourceFile sourceFile, Parser.Input input, @Nullable Path relativeTo, ExecutionContext ctx, Throwable t, boolean isCharsetBomMarked, String sourceText) {
        String tName = t.getClass().getSimpleName();
        return new ParseError(Tree.randomId(), new Markers(Tree.randomId(), Collections.singletonList(new ParseExceptionResult(Tree.randomId(), this.remotingServerEngine.getLanguageName() + "Parser", StringUtils.isBlank((String)tName) ? t.getClass().getName() : tName, ExceptionUtils.sanitizeStackTrace((Throwable)t, this.getClass()), null))), input.getRelativePath(relativeTo), input.getFileAttributes(), this.getCharset(ctx).name(), isCharsetBomMarked, null, sourceText, null);
    }
}

