/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import com.fasterxml.jackson.dataformat.cbor.CBORGenerator;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.remote.RemotingContext;
import org.openrewrite.remote.RemotingExecutionContextView;
import org.openrewrite.remote.RemotingMessenger;
import org.openrewrite.remote.RemotingParser;
import org.openrewrite.remote.RemotingServerEngine;
import org.openrewrite.remote.Validator;
import org.openrewrite.text.PlainTextParser;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class RemotingInputParser
extends RemotingParser {
    private final Predicate<Path> fileFilter;

    public RemotingInputParser(RemotingServerEngine remotingServerEngine, Predicate<Path> fileFilter) {
        super(remotingServerEngine);
        this.fileFilter = fileFilter;
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> inputs, @Nullable Path relativeTo, ExecutionContext ctx) {
        try {
            this.remotingServerEngine.start();
        }
        catch (Exception e) {
            return PlainTextParser.builder().build().parseInputs(inputs, relativeTo, ctx);
        }
        RemotingExecutionContextView view = RemotingExecutionContextView.view(ctx);
        RemotingContext remotingContext = view.getOrCreateRemotingContext();
        RemotingMessenger messenger = view.getOrCreateRemotingMessenger();
        ParsingExecutionContextView pctx = ParsingExecutionContextView.view((ExecutionContext)ctx);
        ParsingEventListener parsingListener = pctx.getParsingListener();
        return this.acceptedInputs(inputs).map(input -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    private SourceFile validate(SourceFile sourceFile, Parser.Input input, @Nullable Path relativeTo, RemotingContext remotingContext, ExecutionContext ctx) {
        Validator validator = remotingContext.getProvider(sourceFile.getClass()).newValidator();
        try {
            validator.validate((Tree)sourceFile, ctx);
        }
        catch (Exception e) {
            EncodingDetectingInputStream source = input.getSource(ctx);
            String sourceText = source.readFully();
            return this.buildParseError(sourceFile, input, relativeTo, ctx, e, source.isCharsetBomMarked(), sourceText);
        }
        return this.requirePrintEqualsInput(sourceFile, input, relativeTo, ctx);
    }

    public boolean accept(Path path) {
        return this.fileFilter.test(path);
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("Source.file");
    }

    private static /* synthetic */ SourceFile lambda$parseInputs$1(RemotingContext remotingContext, CBORParser parser) throws IOException {
        return RemotingMessenger.receiveTree(remotingContext, parser, null);
    }

    private static /* synthetic */ void lambda$parseInputs$0(Parser.Input input, EncodingDetectingInputStream is, Path relativeTo, CBORGenerator generator) throws IOException {
        if (input.isSynthetic() || !Files.isRegularFile(input.getPath(), new LinkOption[0])) {
            generator.writeString("parse-source");
            generator.writeString(is.readFully());
        } else {
            generator.writeString("parse-file");
            generator.writeString(input.getPath().toString());
            generator.writeString(relativeTo != null ? relativeTo.toString() : null);
        }
    }
}

