/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.Socket;
import java.util.Collections;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.openrewrite.DelegatingExecutionContext;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.remote.RemotingContext;
import org.openrewrite.remote.RemotingMessenger;
import org.openrewrite.remote.RemotingServerEngine;

public class RemotingExecutionContextView
extends DelegatingExecutionContext {
    private static final String REMOTING_CONTEXT = "org.openrewrite.remote.remotingContext";

    private RemotingExecutionContextView(ExecutionContext delegate) {
        super(delegate);
    }

    public static RemotingExecutionContextView view(ExecutionContext ctx) {
        return ctx instanceof RemotingExecutionContextView ? (RemotingExecutionContextView)ctx : new RemotingExecutionContextView(ctx);
    }

    public void setRemotingContext(RemotingContext remotingContext) {
        super.putMessage(REMOTING_CONTEXT, (Object)remotingContext);
    }

    public @Nullable RemotingContext getRemotingContext() {
        return (RemotingContext)super.getMessage(REMOTING_CONTEXT);
    }

    public RemotingContext getOrCreateRemotingContext() {
        RemotingContext remotingContext = this.getRemotingContext();
        if (remotingContext == null) {
            remotingContext = new RemotingContext(((Object)((Object)this)).getClass().getClassLoader(), false);
            this.setRemotingContext(remotingContext);
        }
        return remotingContext;
    }

    public Socket getOrCreateSocket(Class<? extends RemotingServerEngine> clazz, Supplier<? extends RemotingServerEngine> remotingServerEngineSupplier) {
        Socket activeSocket = (Socket)this.getMessage(clazz.getName() + Socket.class.getName());
        if (activeSocket == null || activeSocket.isClosed()) {
            try {
                RemotingServerEngine remotingServerEngine = remotingServerEngineSupplier.get();
                remotingServerEngine.start();
                activeSocket = remotingServerEngine.openConnection();
                this.putMessage(remotingServerEngine.getClass().getName() + Socket.class.getName(), activeSocket);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return activeSocket;
    }

    public Socket getOrCreateSocket(RemotingServerEngine remotingServerEngine) {
        Socket activeSocket = (Socket)this.getMessage(remotingServerEngine.getClass().getName() + Socket.class.getName());
        if (activeSocket == null || activeSocket.isClosed()) {
            try {
                activeSocket = remotingServerEngine.openConnection();
                this.putMessage(remotingServerEngine.getClass().getName() + Socket.class.getName(), activeSocket);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return activeSocket;
    }

    public RemotingMessenger getOrCreateRemotingMessenger() {
        RemotingMessenger messenger = (RemotingMessenger)this.getMessage(RemotingMessenger.class.getName());
        if (messenger == null) {
            messenger = new RemotingMessenger((CBORFactory)this.getOrCreateRemotingContext().objectMapper().getFactory(), Collections.emptyMap(), m -> new InMemoryExecutionContext());
            this.putMessage(RemotingMessenger.class.getName(), messenger);
        }
        return messenger;
    }
}

