/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.UUID;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.ParseErrorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.remote.Receiver;
import org.openrewrite.remote.ReceiverContext;
import org.openrewrite.remote.ReceiverFactory;
import org.openrewrite.tree.ParseError;

public final class ParseErrorReceiver
implements Receiver<ParseError> {
    @Override
    public ParseError receive(@Nullable ParseError before, ReceiverContext ctx) {
        ReceiverContext forked = this.fork(ctx);
        return (ParseError)forked.getVisitor().visit((Tree)before, (Object)forked);
    }

    @Override
    public ReceiverContext fork(ReceiverContext ctx) {
        return ctx.fork((TreeVisitor<?, ReceiverContext>)new Visitor(), new Factory());
    }

    @Generated
    public ParseErrorReceiver() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof ParseErrorReceiver;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "ParseErrorReceiver()";
    }

    private static class Visitor
    extends ParseErrorVisitor<ReceiverContext> {
        private Visitor() {
        }

        public @Nullable ParseError visit(@Nullable Tree tree, ReceiverContext ctx) {
            Cursor cursor = new Cursor(this.getCursor(), (Object)tree);
            this.setCursor(cursor);
            tree = (Tree)ctx.receiveNode((ParseError)tree, ctx::receiveTree);
            this.setCursor(cursor.getParent());
            return (ParseError)tree;
        }

        public ParseError visitParseError(ParseError parseError, ReceiverContext ctx) {
            parseError = parseError.withId(ctx.receiveNonNullValue(parseError.getId(), UUID.class));
            parseError = parseError.withMarkers(ctx.receiveNonNullNode(parseError.getMarkers(), ctx::receiveMarkers));
            parseError = parseError.withSourcePath(ctx.receiveNonNullValue(parseError.getSourcePath(), Path.class));
            String charsetName = ctx.receiveValue((parseError = parseError.withFileAttributes(ctx.receiveValue(parseError.getFileAttributes(), FileAttributes.class))).getCharset().name(), String.class);
            if (charsetName != null) {
                parseError = (ParseError)parseError.withCharset(Charset.forName(charsetName));
            }
            parseError = parseError.withCharsetBomMarked(ctx.receiveNonNullValue(parseError.isCharsetBomMarked(), Boolean.TYPE).booleanValue());
            parseError = parseError.withChecksum(ctx.receiveValue(parseError.getChecksum(), Checksum.class));
            parseError = parseError.withText(ctx.receiveNonNullValue(parseError.getText(), String.class));
            return parseError;
        }
    }

    private static class Factory
    implements ReceiverFactory {
        private Factory() {
        }

        @Override
        public <T> T create(Class<T> type, ReceiverContext ctx) {
            if (type == ParseError.class) {
                return (T)new ParseError(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullValue(null, Path.class), ctx.receiveValue(null, FileAttributes.class), ctx.receiveValue(null, String.class), ctx.receiveNonNullValue(null, Boolean.TYPE).booleanValue(), ctx.receiveValue(null, Checksum.class), ctx.receiveNonNullValue(null, String.class), null);
            }
            throw new IllegalArgumentException("Unknown type: " + type);
        }
    }
}

