/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.remote.DiffEvent;
import org.openrewrite.remote.EventType;
import org.openrewrite.remote.RemotingContext;
import org.openrewrite.remote.TimeoutException;
import org.openrewrite.remote.TreeReceiver;
import org.openrewrite.remote.TreeSender;

public class InMemorySenderReceiver
implements TreeSender,
TreeReceiver {
    private static final boolean DEBUG = false;
    private final AtomicInteger sendCounter = new AtomicInteger(0);
    private final AtomicInteger receiveCounter = new AtomicInteger(0);
    private final BlockingQueue<DiffEvent> eventQueue = new ArrayBlockingQueue<DiffEvent>(10000);
    private final RemotingContext context;
    private final long timeoutInSeconds;

    @Override
    public RemotingContext getContext() {
        return this.context;
    }

    @Override
    public void sendValue(DiffEvent event) {
        this.offer(event);
    }

    @Override
    public void sendNode(DiffEvent event, Consumer<TreeSender> visitor) {
        this.offer(event);
        if (event.getEventType() != EventType.NoChange && event.getEventType() != EventType.Delete) {
            visitor.accept(this);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public DiffEvent receiveValue(@Nullable Class<?> expectedType) {
        try {
            DiffEvent event = this.eventQueue.poll(this.timeoutInSeconds, TimeUnit.SECONDS);
            if (event == null) {
                throw new TimeoutException("Timed out waiting to receive an event");
            }
            return event;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DiffEvent receiveNode() {
        return this.receiveValue(null);
    }

    private void offer(DiffEvent event) {
        try {
            if (!this.eventQueue.offer(event, this.timeoutInSeconds, TimeUnit.SECONDS)) {
                throw new TimeoutException("Timed out waiting to send event: " + event);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public InMemorySenderReceiver(RemotingContext context, long timeoutInSeconds) {
        this.context = context;
        this.timeoutInSeconds = timeoutInSeconds;
    }
}

