/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.remote;

import java.util.function.Function;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.json.JsonVisitor;
import org.openrewrite.json.tree.Comment;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.JsonRightPadded;
import org.openrewrite.json.tree.JsonValue;
import org.openrewrite.json.tree.Space;
import org.openrewrite.remote.Sender;
import org.openrewrite.remote.SenderContext;

public final class JsonSender
implements Sender<Json> {
    @Override
    public void send(Json after, @Nullable Json before, SenderContext ctx) {
        Visitor visitor = new Visitor();
        visitor.visit((Tree)after, ctx.fork((TreeVisitor<?, SenderContext>)visitor, (Tree)before));
        ctx.flush();
    }

    private static void sendComment(Comment comment, SenderContext ctx) {
        ctx.sendValue(comment, Comment::isMultiline);
        ctx.sendValue(comment, Comment::getText);
        ctx.sendValue(comment, Comment::getSuffix);
        ctx.sendNode(comment, Comment::getMarkers, ctx::sendMarkers);
    }

    private static <T extends Json> void sendRightPadded(JsonRightPadded<T> rightPadded, SenderContext ctx) {
        ctx.sendNode(rightPadded, JsonRightPadded::getElement, ctx::sendTree);
        ctx.sendNode(rightPadded, JsonRightPadded::getAfter, JsonSender::sendSpace);
        ctx.sendNode(rightPadded, JsonRightPadded::getMarkers, ctx::sendMarkers);
    }

    private static void sendSpace(Space space, SenderContext ctx) {
        ctx.sendNodes(space, Space::getComments, JsonSender::sendComment, Function.identity());
        ctx.sendValue(space, Space::getWhitespace);
    }

    @Generated
    public JsonSender() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof JsonSender;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "JsonSender()";
    }

    private static class Visitor
    extends JsonVisitor<SenderContext> {
        private Visitor() {
        }

        public @Nullable Json visit(@Nullable Tree tree, SenderContext ctx) {
            this.setCursor(new Cursor(this.getCursor(), (Object)tree));
            ctx.sendNode(tree, Function.identity(), ctx::sendTree);
            this.setCursor(this.getCursor().getParent());
            return (Json)tree;
        }

        public Json.Array visitArray(Json.Array array, SenderContext ctx) {
            ctx.sendValue(array, Json.Array::getId);
            ctx.sendNode(array, Json.Array::getPrefix, (x$0, x$1) -> JsonSender.sendSpace(x$0, x$1));
            ctx.sendNode(array, Json.Array::getMarkers, ctx::sendMarkers);
            ctx.sendNodes(array, e -> e.getPadding().getValues(), (x$0, x$1) -> JsonSender.sendRightPadded(x$0, x$1), e -> ((JsonValue)e.getElement()).getId());
            return array;
        }

        public Json.Document visitDocument(Json.Document document, SenderContext ctx) {
            ctx.sendValue(document, Json.Document::getId);
            ctx.sendValue(document, Json.Document::getSourcePath);
            ctx.sendNode(document, Json.Document::getPrefix, (x$0, x$1) -> JsonSender.sendSpace(x$0, x$1));
            ctx.sendNode(document, Json.Document::getMarkers, ctx::sendMarkers);
            ctx.sendValue(document, e -> e.getCharset() != null ? e.getCharset().name() : "UTF-8");
            ctx.sendValue(document, Json.Document::isCharsetBomMarked);
            ctx.sendTypedValue(document, Json.Document::getChecksum);
            ctx.sendTypedValue(document, Json.Document::getFileAttributes);
            ctx.sendNode(document, Json.Document::getValue, ctx::sendTree);
            ctx.sendNode(document, Json.Document::getEof, (x$0, x$1) -> JsonSender.sendSpace(x$0, x$1));
            return document;
        }

        public Json.Empty visitEmpty(Json.Empty empty, SenderContext ctx) {
            ctx.sendValue(empty, Json.Empty::getId);
            ctx.sendNode(empty, Json.Empty::getPrefix, (x$0, x$1) -> JsonSender.sendSpace(x$0, x$1));
            ctx.sendNode(empty, Json.Empty::getMarkers, ctx::sendMarkers);
            return empty;
        }

        public Json.Identifier visitIdentifier(Json.Identifier identifier, SenderContext ctx) {
            ctx.sendValue(identifier, Json.Identifier::getId);
            ctx.sendNode(identifier, Json.Identifier::getPrefix, (x$0, x$1) -> JsonSender.sendSpace(x$0, x$1));
            ctx.sendNode(identifier, Json.Identifier::getMarkers, ctx::sendMarkers);
            ctx.sendValue(identifier, Json.Identifier::getName);
            return identifier;
        }

        public Json.Literal visitLiteral(Json.Literal literal, SenderContext ctx) {
            ctx.sendValue(literal, Json.Literal::getId);
            ctx.sendNode(literal, Json.Literal::getPrefix, (x$0, x$1) -> JsonSender.sendSpace(x$0, x$1));
            ctx.sendNode(literal, Json.Literal::getMarkers, ctx::sendMarkers);
            ctx.sendValue(literal, Json.Literal::getSource);
            ctx.sendTypedValue(literal, Json.Literal::getValue);
            return literal;
        }

        public Json.Member visitMember(Json.Member member, SenderContext ctx) {
            ctx.sendValue(member, Json.Member::getId);
            ctx.sendNode(member, Json.Member::getPrefix, (x$0, x$1) -> JsonSender.sendSpace(x$0, x$1));
            ctx.sendNode(member, Json.Member::getMarkers, ctx::sendMarkers);
            ctx.sendNode(member, e -> e.getPadding().getKey(), (x$0, x$1) -> JsonSender.sendRightPadded(x$0, x$1));
            ctx.sendNode(member, Json.Member::getValue, ctx::sendTree);
            return member;
        }

        public Json.JsonObject visitObject(Json.JsonObject jsonObject, SenderContext ctx) {
            ctx.sendValue(jsonObject, Json.JsonObject::getId);
            ctx.sendNode(jsonObject, Json.JsonObject::getPrefix, (x$0, x$1) -> JsonSender.sendSpace(x$0, x$1));
            ctx.sendNode(jsonObject, Json.JsonObject::getMarkers, ctx::sendMarkers);
            ctx.sendNodes(jsonObject, e -> e.getPadding().getMembers(), (x$0, x$1) -> JsonSender.sendRightPadded(x$0, x$1), e -> e.getElement().getId());
            return jsonObject;
        }
    }
}

