/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.remote;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.json.JsonVisitor;
import org.openrewrite.json.tree.Comment;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.JsonRightPadded;
import org.openrewrite.json.tree.Space;
import org.openrewrite.remote.Receiver;
import org.openrewrite.remote.ReceiverContext;
import org.openrewrite.remote.ReceiverFactory;

public final class JsonReceiver
implements Receiver<Json> {
    @Override
    public Json receive(@Nullable Json before, ReceiverContext ctx) {
        ReceiverContext forked = this.fork(ctx);
        return (Json)forked.getVisitor().visit((Tree)before, (Object)forked);
    }

    @Override
    public ReceiverContext fork(ReceiverContext ctx) {
        return ctx.fork((TreeVisitor<?, ReceiverContext>)new Visitor(), new Factory());
    }

    private static Comment receiveComment(@Nullable Comment comment, @Nullable Class<?> type, ReceiverContext ctx) {
        if (comment != null) {
            comment = comment.withMultiline(ctx.receiveNonNullValue(comment.isMultiline(), Boolean.TYPE).booleanValue());
            comment = comment.withText(ctx.receiveNonNullValue(comment.getText(), String.class));
            comment = comment.withSuffix(ctx.receiveNonNullValue(comment.getSuffix(), String.class));
            comment = comment.withMarkers(ctx.receiveNonNullNode(comment.getMarkers(), ctx::receiveMarkers));
        } else {
            comment = new Comment(ctx.receiveNonNullValue(null, Boolean.TYPE).booleanValue(), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers));
        }
        return comment;
    }

    private static <T extends Json> JsonRightPadded<T> receiveRightPadded(@Nullable JsonRightPadded<T> rightPadded, @Nullable Class<?> type, ReceiverContext ctx) {
        if (rightPadded != null) {
            rightPadded = rightPadded.withElement(ctx.receiveNonNullNode(rightPadded.getElement(), ctx::receiveTree));
            rightPadded = rightPadded.withAfter(ctx.receiveNonNullNode(rightPadded.getAfter(), JsonReceiver::receiveSpace));
            rightPadded = rightPadded.withMarkers(ctx.receiveNonNullNode(rightPadded.getMarkers(), ctx::receiveMarkers));
        } else {
            rightPadded = new JsonRightPadded(ctx.receiveNonNullNode(null, ctx::receiveTree), ctx.receiveNonNullNode(null, JsonReceiver::receiveSpace), ctx.receiveNonNullNode(null, ctx::receiveMarkers));
        }
        return rightPadded;
    }

    private static Space receiveSpace(@Nullable Space space, @Nullable Class<? super Space> ignore, ReceiverContext ctx) {
        if (space == null) {
            List<Comment> comments = ctx.receiveNonNullNodes(null, JsonReceiver::receiveComment);
            String whitespace = ctx.receiveNonNullValue(null, String.class);
            return Space.build((String)whitespace, comments);
        }
        space = space.withComments(ctx.receiveNonNullNodes(space.getComments(), JsonReceiver::receiveComment));
        space = space.withWhitespace(ctx.receiveNonNullValue(space.getWhitespace(), String.class));
        return space;
    }

    @Generated
    public JsonReceiver() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof JsonReceiver;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "JsonReceiver()";
    }

    private static class Visitor
    extends JsonVisitor<ReceiverContext> {
        private Visitor() {
        }

        public @Nullable Json visit(@Nullable Tree tree, ReceiverContext ctx) {
            Cursor cursor = new Cursor(this.getCursor(), (Object)tree);
            this.setCursor(cursor);
            tree = (Tree)ctx.receiveNode((Json)tree, ctx::receiveTree);
            this.setCursor(cursor.getParent());
            return (Json)tree;
        }

        public Json.Array visitArray(Json.Array array, ReceiverContext ctx) {
            array = array.withId(ctx.receiveNonNullValue(array.getId(), UUID.class));
            array = array.withPrefix(ctx.receiveNonNullNode(array.getPrefix(), (x$0, x$1, x$2) -> JsonReceiver.receiveSpace(x$0, x$1, x$2)));
            array = array.withMarkers(ctx.receiveNonNullNode(array.getMarkers(), ctx::receiveMarkers));
            array = array.getPadding().withValues(ctx.receiveNonNullNodes(array.getPadding().getValues(), (x$0, x$1, x$2) -> JsonReceiver.receiveRightPadded(x$0, x$1, x$2)));
            return array;
        }

        public Json.Document visitDocument(Json.Document document, ReceiverContext ctx) {
            document = document.withId(ctx.receiveNonNullValue(document.getId(), UUID.class));
            document = document.withSourcePath(ctx.receiveNonNullValue(document.getSourcePath(), Path.class));
            document = document.withPrefix(ctx.receiveNonNullNode(document.getPrefix(), (x$0, x$1, x$2) -> JsonReceiver.receiveSpace(x$0, x$1, x$2)));
            String charsetName = ctx.receiveValue((document = document.withMarkers(ctx.receiveNonNullNode(document.getMarkers(), ctx::receiveMarkers))).getCharset().name(), String.class);
            if (charsetName != null) {
                document = document.withCharset(Charset.forName(charsetName));
            }
            document = document.withCharsetBomMarked(ctx.receiveNonNullValue(document.isCharsetBomMarked(), Boolean.TYPE).booleanValue());
            document = document.withChecksum(ctx.receiveValue(document.getChecksum(), Checksum.class));
            document = document.withFileAttributes(ctx.receiveValue(document.getFileAttributes(), FileAttributes.class));
            document = document.withValue(ctx.receiveNonNullNode(document.getValue(), ctx::receiveTree));
            document = document.withEof(ctx.receiveNonNullNode(document.getEof(), (x$0, x$1, x$2) -> JsonReceiver.receiveSpace(x$0, x$1, x$2)));
            return document;
        }

        public Json.Empty visitEmpty(Json.Empty empty, ReceiverContext ctx) {
            empty = empty.withId(ctx.receiveNonNullValue(empty.getId(), UUID.class));
            empty = empty.withPrefix(ctx.receiveNonNullNode(empty.getPrefix(), (x$0, x$1, x$2) -> JsonReceiver.receiveSpace(x$0, x$1, x$2)));
            empty = empty.withMarkers(ctx.receiveNonNullNode(empty.getMarkers(), ctx::receiveMarkers));
            return empty;
        }

        public Json.Identifier visitIdentifier(Json.Identifier identifier, ReceiverContext ctx) {
            identifier = identifier.withId(ctx.receiveNonNullValue(identifier.getId(), UUID.class));
            identifier = identifier.withPrefix(ctx.receiveNonNullNode(identifier.getPrefix(), (x$0, x$1, x$2) -> JsonReceiver.receiveSpace(x$0, x$1, x$2)));
            identifier = identifier.withMarkers(ctx.receiveNonNullNode(identifier.getMarkers(), ctx::receiveMarkers));
            identifier = identifier.withName(ctx.receiveNonNullValue(identifier.getName(), String.class));
            return identifier;
        }

        public Json.Literal visitLiteral(Json.Literal literal, ReceiverContext ctx) {
            literal = literal.withId(ctx.receiveNonNullValue(literal.getId(), UUID.class));
            literal = literal.withPrefix(ctx.receiveNonNullNode(literal.getPrefix(), (x$0, x$1, x$2) -> JsonReceiver.receiveSpace(x$0, x$1, x$2)));
            literal = literal.withMarkers(ctx.receiveNonNullNode(literal.getMarkers(), ctx::receiveMarkers));
            literal = literal.withSource(ctx.receiveNonNullValue(literal.getSource(), String.class));
            literal = literal.withValue(ctx.receiveValue(literal.getValue(), Object.class));
            return literal;
        }

        public Json.Member visitMember(Json.Member member, ReceiverContext ctx) {
            member = member.withId(ctx.receiveNonNullValue(member.getId(), UUID.class));
            member = member.withPrefix(ctx.receiveNonNullNode(member.getPrefix(), (x$0, x$1, x$2) -> JsonReceiver.receiveSpace(x$0, x$1, x$2)));
            member = member.withMarkers(ctx.receiveNonNullNode(member.getMarkers(), ctx::receiveMarkers));
            member = member.getPadding().withKey(ctx.receiveNonNullNode(member.getPadding().getKey(), (x$0, x$1, x$2) -> JsonReceiver.receiveRightPadded(x$0, x$1, x$2)));
            member = member.withValue(ctx.receiveNonNullNode(member.getValue(), ctx::receiveTree));
            return member;
        }

        public Json.JsonObject visitObject(Json.JsonObject jsonObject, ReceiverContext ctx) {
            jsonObject = jsonObject.withId(ctx.receiveNonNullValue(jsonObject.getId(), UUID.class));
            jsonObject = jsonObject.withPrefix(ctx.receiveNonNullNode(jsonObject.getPrefix(), (x$0, x$1, x$2) -> JsonReceiver.receiveSpace(x$0, x$1, x$2)));
            jsonObject = jsonObject.withMarkers(ctx.receiveNonNullNode(jsonObject.getMarkers(), ctx::receiveMarkers));
            jsonObject = jsonObject.getPadding().withMembers(ctx.receiveNonNullNodes(jsonObject.getPadding().getMembers(), (x$0, x$1, x$2) -> JsonReceiver.receiveRightPadded(x$0, x$1, x$2)));
            return jsonObject;
        }
    }

    private static class Factory
    implements ReceiverFactory {
        private final ClassValue<Function<ReceiverContext, Object>> factories = new ClassValue<Function<ReceiverContext, Object>>(){

            @Override
            protected Function<ReceiverContext, Object> computeValue(Class type) {
                if (type == Json.Array.class) {
                    return x$0 -> Factory.createJsonArray(x$0);
                }
                if (type == Json.Document.class) {
                    return x$0 -> Factory.createJsonDocument(x$0);
                }
                if (type == Json.Empty.class) {
                    return x$0 -> Factory.createJsonEmpty(x$0);
                }
                if (type == Json.Identifier.class) {
                    return x$0 -> Factory.createJsonIdentifier(x$0);
                }
                if (type == Json.Literal.class) {
                    return x$0 -> Factory.createJsonLiteral(x$0);
                }
                if (type == Json.Member.class) {
                    return x$0 -> Factory.createJsonMember(x$0);
                }
                if (type == Json.JsonObject.class) {
                    return x$0 -> Factory.createJsonJsonObject(x$0);
                }
                throw new IllegalArgumentException("Unknown type: " + type);
            }
        };

        private Factory() {
        }

        @Override
        public <T> T create(Class<T> type, ReceiverContext ctx) {
            return (T)this.factories.get(type).apply(ctx);
        }

        private static Json.Array createJsonArray(ReceiverContext ctx) {
            return new Json.Array(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullNode(null, (x$0, x$1, x$2) -> JsonReceiver.receiveSpace(x$0, x$1, x$2)), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullNodes(null, (x$0, x$1, x$2) -> JsonReceiver.receiveRightPadded(x$0, x$1, x$2)));
        }

        private static Json.Document createJsonDocument(ReceiverContext ctx) {
            return new Json.Document(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, Path.class), ctx.receiveNonNullNode(null, (x$0, x$1, x$2) -> JsonReceiver.receiveSpace(x$0, x$1, x$2)), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveValue(null, String.class), ctx.receiveNonNullValue(null, Boolean.TYPE).booleanValue(), ctx.receiveValue(null, Checksum.class), ctx.receiveValue(null, FileAttributes.class), ctx.receiveNonNullNode(null, ctx::receiveTree), ctx.receiveNonNullNode(null, (x$0, x$1, x$2) -> JsonReceiver.receiveSpace(x$0, x$1, x$2)));
        }

        private static Json.Empty createJsonEmpty(ReceiverContext ctx) {
            return new Json.Empty(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullNode(null, (x$0, x$1, x$2) -> JsonReceiver.receiveSpace(x$0, x$1, x$2)), ctx.receiveNonNullNode(null, ctx::receiveMarkers));
        }

        private static Json.Identifier createJsonIdentifier(ReceiverContext ctx) {
            return new Json.Identifier(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullNode(null, (x$0, x$1, x$2) -> JsonReceiver.receiveSpace(x$0, x$1, x$2)), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullValue(null, String.class));
        }

        private static Json.Literal createJsonLiteral(ReceiverContext ctx) {
            return new Json.Literal(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullNode(null, (x$0, x$1, x$2) -> JsonReceiver.receiveSpace(x$0, x$1, x$2)), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullValue(null, String.class), ctx.receiveValue(null, Object.class));
        }

        private static Json.Member createJsonMember(ReceiverContext ctx) {
            return new Json.Member(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullNode(null, (x$0, x$1, x$2) -> JsonReceiver.receiveSpace(x$0, x$1, x$2)), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullNode(null, (x$0, x$1, x$2) -> JsonReceiver.receiveRightPadded(x$0, x$1, x$2)), ctx.receiveNonNullNode(null, ctx::receiveTree));
        }

        private static Json.JsonObject createJsonJsonObject(ReceiverContext ctx) {
            return new Json.JsonObject(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullNode(null, (x$0, x$1, x$2) -> JsonReceiver.receiveSpace(x$0, x$1, x$2)), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullNodes(null, (x$0, x$1, x$2) -> JsonReceiver.receiveRightPadded(x$0, x$1, x$2)));
        }
    }
}

