/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote.xml;

import java.util.function.Function;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.remote.Sender;
import org.openrewrite.remote.SenderContext;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public final class XmlSender
implements Sender<Xml> {
    @Override
    public void send(Xml after, @Nullable Xml before, SenderContext ctx) {
        Visitor visitor = new Visitor();
        visitor.visit((Tree)after, ctx.fork((TreeVisitor<?, SenderContext>)visitor, (Tree)before));
        ctx.flush();
    }

    @Generated
    public XmlSender() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof XmlSender;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "XmlSender()";
    }

    private static class Visitor
    extends XmlVisitor<SenderContext> {
        private Visitor() {
        }

        public @Nullable Xml visit(@Nullable Tree tree, SenderContext ctx) {
            this.setCursor(new Cursor(this.getCursor(), (Object)tree));
            ctx.sendNode(tree, Function.identity(), ctx::sendTree);
            this.setCursor(this.getCursor().getParent());
            return (Xml)tree;
        }

        public Xml.Document visitDocument(Xml.Document document, SenderContext ctx) {
            ctx.sendValue(document, Xml.Document::getId);
            ctx.sendValue(document, Xml.Document::getSourcePath);
            ctx.sendValue(document, Xml.Document::getPrefixUnsafe);
            ctx.sendNode(document, Xml.Document::getMarkers, ctx::sendMarkers);
            ctx.sendValue(document, e -> e.getCharset() != null ? e.getCharset().name() : "UTF-8");
            ctx.sendValue(document, Xml.Document::isCharsetBomMarked);
            ctx.sendTypedValue(document, Xml.Document::getChecksum);
            ctx.sendTypedValue(document, Xml.Document::getFileAttributes);
            ctx.sendNode(document, Xml.Document::getProlog, ctx::sendTree);
            ctx.sendNode(document, Xml.Document::getRoot, ctx::sendTree);
            ctx.sendValue(document, Xml.Document::getEof);
            return document;
        }

        public Xml.Prolog visitProlog(Xml.Prolog prolog, SenderContext ctx) {
            ctx.sendValue(prolog, Xml.Prolog::getId);
            ctx.sendValue(prolog, Xml.Prolog::getPrefixUnsafe);
            ctx.sendNode(prolog, Xml.Prolog::getMarkers, ctx::sendMarkers);
            ctx.sendNode(prolog, Xml.Prolog::getXmlDecl, ctx::sendTree);
            ctx.sendNodes(prolog, Xml.Prolog::getMisc, ctx::sendTree, Tree::getId);
            ctx.sendNodes(prolog, Xml.Prolog::getJspDirectives, ctx::sendTree, Tree::getId);
            return prolog;
        }

        public Xml.XmlDecl visitXmlDecl(Xml.XmlDecl xmlDecl, SenderContext ctx) {
            ctx.sendValue(xmlDecl, Xml.XmlDecl::getId);
            ctx.sendValue(xmlDecl, Xml.XmlDecl::getPrefixUnsafe);
            ctx.sendNode(xmlDecl, Xml.XmlDecl::getMarkers, ctx::sendMarkers);
            ctx.sendValue(xmlDecl, Xml.XmlDecl::getName);
            ctx.sendNodes(xmlDecl, Xml.XmlDecl::getAttributes, ctx::sendTree, Tree::getId);
            ctx.sendValue(xmlDecl, Xml.XmlDecl::getBeforeTagDelimiterPrefix);
            return xmlDecl;
        }

        public Xml.ProcessingInstruction visitProcessingInstruction(Xml.ProcessingInstruction processingInstruction, SenderContext ctx) {
            ctx.sendValue(processingInstruction, Xml.ProcessingInstruction::getId);
            ctx.sendValue(processingInstruction, Xml.ProcessingInstruction::getPrefixUnsafe);
            ctx.sendNode(processingInstruction, Xml.ProcessingInstruction::getMarkers, ctx::sendMarkers);
            ctx.sendValue(processingInstruction, Xml.ProcessingInstruction::getName);
            ctx.sendNode(processingInstruction, Xml.ProcessingInstruction::getProcessingInstructions, ctx::sendTree);
            ctx.sendValue(processingInstruction, Xml.ProcessingInstruction::getBeforeTagDelimiterPrefix);
            return processingInstruction;
        }

        public Xml.Tag visitTag(Xml.Tag tag, SenderContext ctx) {
            ctx.sendValue(tag, Xml.Tag::getId);
            ctx.sendValue(tag, Xml.Tag::getPrefixUnsafe);
            ctx.sendNode(tag, Xml.Tag::getMarkers, ctx::sendMarkers);
            ctx.sendValue(tag, Xml.Tag::getName);
            ctx.sendNodes(tag, Xml.Tag::getAttributes, ctx::sendTree, Tree::getId);
            ctx.sendNodes(tag, Xml.Tag::getContent, ctx::sendTree, Tree::getId);
            ctx.sendNode(tag, Xml.Tag::getClosing, ctx::sendTree);
            ctx.sendValue(tag, Xml.Tag::getBeforeTagDelimiterPrefix);
            return tag;
        }

        public Xml.Tag.Closing visitTagClosing(Xml.Tag.Closing closing, SenderContext ctx) {
            ctx.sendValue(closing, Xml.Tag.Closing::getId);
            ctx.sendValue(closing, Xml.Tag.Closing::getPrefixUnsafe);
            ctx.sendNode(closing, Xml.Tag.Closing::getMarkers, ctx::sendMarkers);
            ctx.sendValue(closing, Xml.Tag.Closing::getName);
            ctx.sendValue(closing, Xml.Tag.Closing::getBeforeTagDelimiterPrefix);
            return closing;
        }

        public Xml.Attribute visitAttribute(Xml.Attribute attribute, SenderContext ctx) {
            ctx.sendValue(attribute, Xml.Attribute::getId);
            ctx.sendValue(attribute, Xml.Attribute::getPrefixUnsafe);
            ctx.sendNode(attribute, Xml.Attribute::getMarkers, ctx::sendMarkers);
            ctx.sendNode(attribute, Xml.Attribute::getKey, ctx::sendTree);
            ctx.sendValue(attribute, Xml.Attribute::getBeforeEquals);
            ctx.sendNode(attribute, Xml.Attribute::getValue, ctx::sendTree);
            return attribute;
        }

        public Xml.Attribute.Value visitAttributeValue(Xml.Attribute.Value value, SenderContext ctx) {
            ctx.sendValue(value, Xml.Attribute.Value::getId);
            ctx.sendValue(value, Xml.Attribute.Value::getPrefixUnsafe);
            ctx.sendNode(value, Xml.Attribute.Value::getMarkers, ctx::sendMarkers);
            ctx.sendValue(value, Xml.Attribute.Value::getQuote);
            ctx.sendValue(value, Xml.Attribute.Value::getValue);
            return value;
        }

        public Xml.CharData visitCharData(Xml.CharData charData, SenderContext ctx) {
            ctx.sendValue(charData, Xml.CharData::getId);
            ctx.sendValue(charData, Xml.CharData::getPrefixUnsafe);
            ctx.sendNode(charData, Xml.CharData::getMarkers, ctx::sendMarkers);
            ctx.sendValue(charData, Xml.CharData::isCdata);
            ctx.sendValue(charData, Xml.CharData::getText);
            ctx.sendValue(charData, Xml.CharData::getAfterText);
            return charData;
        }

        public Xml.Comment visitComment(Xml.Comment comment, SenderContext ctx) {
            ctx.sendValue(comment, Xml.Comment::getId);
            ctx.sendValue(comment, Xml.Comment::getPrefixUnsafe);
            ctx.sendNode(comment, Xml.Comment::getMarkers, ctx::sendMarkers);
            ctx.sendValue(comment, Xml.Comment::getText);
            return comment;
        }

        public Xml.DocTypeDecl visitDocTypeDecl(Xml.DocTypeDecl docTypeDecl, SenderContext ctx) {
            ctx.sendValue(docTypeDecl, Xml.DocTypeDecl::getId);
            ctx.sendValue(docTypeDecl, Xml.DocTypeDecl::getPrefixUnsafe);
            ctx.sendNode(docTypeDecl, Xml.DocTypeDecl::getMarkers, ctx::sendMarkers);
            ctx.sendNode(docTypeDecl, Xml.DocTypeDecl::getName, ctx::sendTree);
            ctx.sendNode(docTypeDecl, Xml.DocTypeDecl::getExternalId, ctx::sendTree);
            ctx.sendNodes(docTypeDecl, Xml.DocTypeDecl::getInternalSubset, ctx::sendTree, Tree::getId);
            ctx.sendNode(docTypeDecl, Xml.DocTypeDecl::getExternalSubsets, ctx::sendTree);
            ctx.sendValue(docTypeDecl, Xml.DocTypeDecl::getBeforeTagDelimiterPrefix);
            return docTypeDecl;
        }

        public Xml.DocTypeDecl.ExternalSubsets visitDocTypeDeclExternalSubsets(Xml.DocTypeDecl.ExternalSubsets externalSubsets, SenderContext ctx) {
            ctx.sendValue(externalSubsets, Xml.DocTypeDecl.ExternalSubsets::getId);
            ctx.sendValue(externalSubsets, Xml.DocTypeDecl.ExternalSubsets::getPrefixUnsafe);
            ctx.sendNode(externalSubsets, Xml.DocTypeDecl.ExternalSubsets::getMarkers, ctx::sendMarkers);
            ctx.sendNodes(externalSubsets, Xml.DocTypeDecl.ExternalSubsets::getElements, ctx::sendTree, Tree::getId);
            return externalSubsets;
        }

        public Xml.Element visitElement(Xml.Element element, SenderContext ctx) {
            ctx.sendValue(element, Xml.Element::getId);
            ctx.sendValue(element, Xml.Element::getPrefixUnsafe);
            ctx.sendNode(element, Xml.Element::getMarkers, ctx::sendMarkers);
            ctx.sendNodes(element, Xml.Element::getSubset, ctx::sendTree, Tree::getId);
            ctx.sendValue(element, Xml.Element::getBeforeTagDelimiterPrefix);
            return element;
        }

        public Xml.Ident visitIdent(Xml.Ident ident, SenderContext ctx) {
            ctx.sendValue(ident, Xml.Ident::getId);
            ctx.sendValue(ident, Xml.Ident::getPrefixUnsafe);
            ctx.sendNode(ident, Xml.Ident::getMarkers, ctx::sendMarkers);
            ctx.sendValue(ident, Xml.Ident::getName);
            return ident;
        }

        public Xml.JspDirective visitJspDirective(Xml.JspDirective jspDirective, SenderContext ctx) {
            ctx.sendValue(jspDirective, Xml.JspDirective::getId);
            ctx.sendValue(jspDirective, Xml.JspDirective::getPrefixUnsafe);
            ctx.sendNode(jspDirective, Xml.JspDirective::getMarkers, ctx::sendMarkers);
            ctx.sendValue(jspDirective, Xml.JspDirective::getBeforeTypePrefix);
            ctx.sendValue(jspDirective, Xml.JspDirective::getType);
            ctx.sendNodes(jspDirective, Xml.JspDirective::getAttributes, ctx::sendTree, Tree::getId);
            ctx.sendValue(jspDirective, Xml.JspDirective::getBeforeDirectiveEndPrefix);
            return jspDirective;
        }
    }
}

