/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Random;
import javax.net.ServerSocketFactory;

public class TcpUtils {
    private static final int PORT_RANGE_MIN = 1024;
    private static final int PORT_RANGE_MAX = 65535;
    private static final int PORT_RANGE_PLUS_ONE = 64512;
    private static final int MAX_ATTEMPTS = 1000;
    private static final Random random = new Random(System.nanoTime());

    public static int findAvailableTcpPortInternal() {
        int candidatePort;
        int searchCounter = 0;
        do {
            if (++searchCounter > 1000) continue;
            throw new IllegalStateException(String.format("Could not find an available TCP port in the range [%d, %d] after %d attempts", 1024, 65535, 1000));
        } while (!TcpUtils.isPortAvailable(candidatePort = 1024 + random.nextInt(64512)));
        return candidatePort;
    }

    public static boolean isPortAvailable(int port) {
        try {
            ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));
            serverSocket.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

