/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.csharp.tree.Cs;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.json.tree.Json;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.python.tree.Py;
import org.openrewrite.remote.DiffEvent;
import org.openrewrite.remote.EventType;
import org.openrewrite.remote.JsonSender;
import org.openrewrite.remote.OmniSender;
import org.openrewrite.remote.ParseErrorSender;
import org.openrewrite.remote.RemoteUtils;
import org.openrewrite.remote.RemotingContext;
import org.openrewrite.remote.Sender;
import org.openrewrite.remote.TreeSender;
import org.openrewrite.remote.csharp.CSharpSender;
import org.openrewrite.remote.java.JavaSender;
import org.openrewrite.remote.properties.PropertiesSender;
import org.openrewrite.remote.python.PythonSender;
import org.openrewrite.remote.xml.XmlSender;
import org.openrewrite.remote.yaml.YamlSender;
import org.openrewrite.tree.ParseError;
import org.openrewrite.xml.tree.Xml;
import org.openrewrite.yaml.tree.Yaml;

public final class SenderContext {
    private final TreeSender sender;
    private final RemotingContext context;
    private @Nullable TreeVisitor<?, SenderContext> visitor;
    private @Nullable Object before;

    public SenderContext(TreeSender sender, RemotingContext context) {
        this.sender = sender;
        this.context = context;
        this.visitor = null;
        this.before = null;
    }

    private SenderContext(TreeSender sender, RemotingContext context, TreeVisitor<?, SenderContext> visitor, @Nullable Tree before) {
        this.sender = sender;
        this.context = context;
        this.visitor = visitor;
        this.before = before;
    }

    public static <T extends Tree> void sendTree(T after, @Nullable T before, JsonSender jsonSender) {
        new SenderContext(jsonSender, jsonSender.context()).sendTree(after, before);
    }

    public <T extends Tree> void sendTree(T after, @Nullable T before) {
        new OmniSender().send(after, before, this);
    }

    public <T extends Tree> Sender<T> newSender(Class<? extends T> clazz) {
        if (Properties.class.isAssignableFrom(clazz)) {
            return new PropertiesSender();
        }
        if (Xml.class.isAssignableFrom(clazz)) {
            return new XmlSender();
        }
        if (Yaml.class.isAssignableFrom(clazz)) {
            return new YamlSender();
        }
        if (Json.class.isAssignableFrom(clazz)) {
            return new org.openrewrite.remote.json.JsonSender();
        }
        if (Cs.class.isAssignableFrom(clazz)) {
            return new CSharpSender();
        }
        if (Py.class.isAssignableFrom(clazz)) {
            return new PythonSender();
        }
        if (J.class.isAssignableFrom(clazz)) {
            return new JavaSender();
        }
        if (ParseError.class.isAssignableFrom(clazz)) {
            return new ParseErrorSender();
        }
        throw new IllegalArgumentException("Unsupported sender type: " + clazz);
    }

    public SenderContext fork(TreeVisitor<?, SenderContext> visitor, @Nullable Tree before) {
        return new SenderContext(this.sender, this.context, visitor, before);
    }

    private <V> void visit(BiConsumer<V, SenderContext> consumer, V after, @Nullable V before) {
        Object saveBefore = this.before;
        this.before = before;
        consumer.accept(after, this);
        this.before = saveBefore;
    }

    public <T, V> void sendNode(T owner, Function<T, V> extractor, BiConsumer<V, SenderContext> details) {
        this.sendNode(extractor.apply(owner), this.before != null ? (V)extractor.apply(this.before) : null, details);
    }

    public <T, V> void sendValue(T owner, Function<T, V> valueExtractor) {
        V afterValue = valueExtractor.apply(owner);
        V beforeValue = this.before != null ? (V)valueExtractor.apply(this.before) : null;
        this.sendValue(afterValue, beforeValue);
    }

    public <T, V> void sendTypedValue(T owner, Function<T, V> valueExtractor) {
        Object beforeValue;
        V afterValue = valueExtractor.apply(owner);
        Object object = beforeValue = this.before != null ? (Object)valueExtractor.apply(this.before) : null;
        this.sendTypedValue(afterValue, beforeValue, afterValue != null ? afterValue.getClass() : (beforeValue != null ? beforeValue.getClass() : null));
    }

    private <V> void sendNode(@Nullable V after, @Nullable V before, BiConsumer<V, SenderContext> details) {
        DiffEvent event = before == after ? new DiffEvent(EventType.NoChange, null, null) : (before == null ? new DiffEvent(EventType.Add, after.getClass() != Markers.class ? after.getClass() : null, null) : (after == null ? new DiffEvent(EventType.Delete, null, null) : new DiffEvent(EventType.Update, null, null)));
        this.sender.sendNode(event, sender -> this.visit(details, after, before));
    }

    private <V> void sendValue(@Nullable V after, @Nullable V before) {
        DiffEvent event = this.before != null && before == after ? new DiffEvent(EventType.NoChange, null, null) : (this.before == null || before == null ? new DiffEvent(EventType.Add, null, after) : (after == null ? new DiffEvent(EventType.Delete, null, null) : new DiffEvent(EventType.Update, null, after)));
        this.sender.sendValue(event);
    }

    private <V> void sendTypedValue(@Nullable V after, @Nullable V before, @Nullable Class<? extends V> type) {
        DiffEvent event;
        if (this.before != null && before == after) {
            event = new DiffEvent(EventType.NoChange, null, null);
        } else {
            if (before instanceof JavaType || after instanceof JavaType) {
                this.sendValue(after, before);
                return;
            }
            event = this.before == null || before == null ? new DiffEvent(EventType.Add, type, after) : (after == null ? new DiffEvent(EventType.Delete, null, null) : new DiffEvent(EventType.Update, null, after));
        }
        this.sender.sendValue(event);
    }

    public <T, V, I> void sendNodes(T owner, Function<T, List<V>> elementExtractor, BiConsumer<V, SenderContext> details, Function<V, I> idFunction) {
        List<V> beforeList;
        List<V> afterList = elementExtractor.apply(owner);
        List<V> list = beforeList = this.before == null ? null : elementExtractor.apply(this.before);
        if (this.sendListEvent(afterList, beforeList)) {
            if (beforeList != null) {
                this.sender.sendValue(new DiffEvent(EventType.StartList, null, null));
            }
            RemoteUtils.calculateListDiff(beforeList == null ? Collections.emptyList() : beforeList, afterList, idFunction, (op, beforeIndex, afterIndex, beforeValue, afterValue) -> {
                switch (op) {
                    case Delete: 
                    case NoChange: 
                    case Add: 
                    case Update: {
                        this.sendNode(afterValue, beforeValue, Objects.requireNonNull(details));
                        break;
                    }
                    case Move: {
                        throw new UnsupportedOperationException("Unexpected operation: " + (Object)((Object)op));
                    }
                }
            });
            if (beforeList != null) {
                this.sender.sendValue(new DiffEvent(EventType.EndList, null, null));
            }
        }
    }

    public <T, V, I> void sendValues(T owner, Function<T, List<V>> valueExtractor, Function<V, I> idFunction) {
        List<V> beforeList;
        List<V> afterList = valueExtractor.apply(owner);
        List<V> list = beforeList = this.before == null ? null : valueExtractor.apply(this.before);
        if (this.sendListEvent(afterList, beforeList)) {
            if (beforeList != null) {
                this.sender.sendValue(new DiffEvent(EventType.StartList, null, null));
            }
            RemoteUtils.calculateListDiff(beforeList == null ? Collections.emptyList() : beforeList, afterList, idFunction, (op, beforeIndex, afterIndex, beforeValue, afterValue) -> {
                switch (op) {
                    case Delete: 
                    case NoChange: 
                    case Add: 
                    case Update: {
                        this.sendValue(afterValue, beforeValue);
                        break;
                    }
                    case Move: {
                        throw new UnsupportedOperationException("Unexpected operation: " + (Object)((Object)op));
                    }
                }
            });
            if (beforeList != null) {
                this.sender.sendValue(new DiffEvent(EventType.EndList, null, null));
            }
        }
    }

    public <T, V, I> void sendTypedValues(T owner, Function<T, List<V>> valueExtractor, Function<V, I> idFunction) {
        List<V> beforeList;
        List<V> afterList = valueExtractor.apply(owner);
        List<V> list = beforeList = this.before == null ? null : valueExtractor.apply(this.before);
        if (this.sendListEvent(afterList, beforeList)) {
            if (beforeList != null) {
                this.sender.sendValue(new DiffEvent(EventType.StartList, null, null));
            }
            RemoteUtils.calculateListDiff(beforeList == null ? Collections.emptyList() : beforeList, afterList, idFunction, (op, beforeIndex, afterIndex, beforeValue, afterValue) -> {
                switch (op) {
                    case Delete: 
                    case NoChange: 
                    case Add: 
                    case Update: {
                        this.sendTypedValue(afterValue, beforeValue, afterValue != null ? afterValue.getClass() : (beforeValue != null ? beforeValue.getClass() : null));
                        break;
                    }
                    case Move: {
                        throw new UnsupportedOperationException("Unexpected operation: " + (Object)((Object)op));
                    }
                }
            });
            if (beforeList != null) {
                this.sender.sendValue(new DiffEvent(EventType.EndList, null, null));
            }
        }
    }

    private <V> boolean sendListEvent(@Nullable List<V> after, @Nullable List<V> before) {
        DiffEvent event = before == after ? new DiffEvent(EventType.NoChange, null, null) : (before == null ? new DiffEvent(EventType.Add, null, after.size()) : (after == null ? new DiffEvent(EventType.Delete, null, null) : new DiffEvent(EventType.Update, null, after.size())));
        this.sender.sendValue(event);
        return event.getEventType() != EventType.NoChange && event.getEventType() != EventType.Delete;
    }

    public void sendMarkers(Markers markers, SenderContext ignore) {
        this.sendValue((Object)markers, (Object)Markers::getId);
        this.sendValues(markers, Markers::getMarkers, Marker::getId);
    }

    public <T extends Tree> void sendTree(T after, SenderContext ctx) {
        after.accept(Objects.requireNonNull(this.visitor), (Object)ctx);
    }

    public void flush() {
        this.sender.flush();
        this.context.mergeNewObjectIds();
    }

    @Generated
    public TreeSender getSender() {
        return this.sender;
    }

    @Generated
    public RemotingContext getContext() {
        return this.context;
    }

    @Generated
    public @Nullable TreeVisitor<?, SenderContext> getVisitor() {
        return this.visitor;
    }

    @Generated
    public @Nullable Object getBefore() {
        return this.before;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SenderContext)) {
            return false;
        }
        SenderContext other = (SenderContext)o;
        TreeSender this$sender = this.getSender();
        TreeSender other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
            return false;
        }
        RemotingContext this$context = this.getContext();
        RemotingContext other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        TreeVisitor<?, SenderContext> this$visitor = this.getVisitor();
        TreeVisitor<?, SenderContext> other$visitor = other.getVisitor();
        if (this$visitor == null ? other$visitor != null : !this$visitor.equals(other$visitor)) {
            return false;
        }
        Object this$before = this.getBefore();
        Object other$before = other.getBefore();
        return !(this$before == null ? other$before != null : !this$before.equals(other$before));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TreeSender $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
        RemotingContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        TreeVisitor<?, SenderContext> $visitor = this.getVisitor();
        result = result * 59 + ($visitor == null ? 43 : $visitor.hashCode());
        Object $before = this.getBefore();
        result = result * 59 + ($before == null ? 43 : $before.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SenderContext(sender=" + this.getSender() + ", context=" + this.getContext() + ", visitor=" + this.getVisitor() + ", before=" + this.getBefore() + ")";
    }
}

