/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.openrewrite.remote.DiffEvent;
import org.openrewrite.remote.EventType;
import org.openrewrite.remote.ReceiverContext;

public final class RemoteUtils {
    public static final ConcurrentMap<Object, Runnable> cleaner = new ConcurrentHashMap<Object, Runnable>();

    public static <T> @Nullable List<T> receiveNodes(@Nullable List<T> before, ReceiverContext.DetailsReceiver<T> details, ReceiverContext ctx) {
        DiffEvent listEvent = ctx.getReceiver().receiveValue(List.class);
        switch (listEvent.getEventType()) {
            case NoChange: {
                return before;
            }
            case Delete: {
                return null;
            }
            case Add: {
                int afterSize = (Integer)listEvent.getMsg();
                ArrayList<Object> after = new ArrayList<Object>(afterSize);
                for (int i = 0; i < afterSize; ++i) {
                    DiffEvent event = ctx.getReceiver().receiveNode();
                    if (event.getEventType() == EventType.Add) {
                        after.add(details.receiveDetails(null, event.getConcreteType(), ctx));
                        continue;
                    }
                    if (event.getEventType() == EventType.NoChange) {
                        after.add(null);
                        continue;
                    }
                    throw new UnsupportedOperationException("Unexpected operation: " + (Object)((Object)event.getEventType()));
                }
                return after;
            }
            case Update: {
                return RemoteUtils.receiveUpdatedNodes(Objects.requireNonNull(before), (Integer)listEvent.getMsg(), details, ctx);
            }
        }
        throw new UnsupportedOperationException("Unexpected operation: " + (Object)((Object)listEvent.getEventType()));
    }

    public static <T> @Nullable List<T> receiveValues(@Nullable List<T> before, Class<? super T> type, ReceiverContext ctx) {
        DiffEvent listEvent = ctx.getReceiver().receiveValue(List.class);
        switch (listEvent.getEventType()) {
            case NoChange: {
                return before;
            }
            case Delete: {
                return null;
            }
            case Add: {
                int afterSize = (Integer)listEvent.getMsg();
                ArrayList<Object> after = new ArrayList<Object>(afterSize);
                for (int i = 0; i < afterSize; ++i) {
                    DiffEvent event = ctx.getReceiver().receiveValue(type);
                    if (event.getEventType() == EventType.Add) {
                        after.add(event.getMsg());
                        continue;
                    }
                    if (event.getEventType() == EventType.NoChange) {
                        after.add(null);
                        continue;
                    }
                    throw new UnsupportedOperationException("Unexpected operation: " + (Object)((Object)event.getEventType()));
                }
                return after;
            }
            case Update: {
                return RemoteUtils.receiveUpdatedValues(Objects.requireNonNull(before), (Integer)listEvent.getMsg(), type, ctx);
            }
        }
        throw new UnsupportedOperationException("Unexpected operation: " + (Object)((Object)listEvent.getEventType()));
    }

    private static <T> List<T> receiveUpdatedNodes(List<T> before, int afterSize, ReceiverContext.DetailsReceiver<T> details, ReceiverContext ctx) {
        boolean modified = false;
        List<T> afterList = before;
        DiffEvent event = ctx.getReceiver().receiveValue(List.class);
        if (event.getEventType() != EventType.StartList) {
            throw new IllegalStateException("Expected start list event: " + (Object)((Object)event.getEventType()));
        }
        int beforeIdx = 0;
        do {
            event = ctx.getReceiver().receiveNode();
            switch (event.getEventType()) {
                case NoChange: 
                case EndList: {
                    break;
                }
                case Delete: 
                case Add: 
                case Update: {
                    if (modified) break;
                    afterList = new ArrayList<T>(before.subList(0, beforeIdx));
                    modified = true;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unexpected operation: " + (Object)((Object)event.getEventType()));
                }
            }
            switch (event.getEventType()) {
                case NoChange: {
                    if (modified) {
                        afterList.add(before.get(beforeIdx));
                    }
                    ++beforeIdx;
                    break;
                }
                case Delete: {
                    ++beforeIdx;
                    break;
                }
                case Update: {
                    afterList.add(details.receiveDetails(before.get(beforeIdx), event.getConcreteType(), ctx));
                    ++beforeIdx;
                    break;
                }
                case Add: {
                    afterList.add(details.receiveDetails(null, event.getConcreteType(), ctx));
                }
            }
        } while (event.getEventType() != EventType.EndList);
        return afterList.size() > afterSize ? afterList.subList(0, afterSize) : afterList;
    }

    private static <T> List<T> receiveUpdatedValues(List<T> before, int afterSize, Class<? super T> type, ReceiverContext ctx) {
        boolean modified = false;
        List<T> afterList = before;
        DiffEvent event = ctx.getReceiver().receiveValue(List.class);
        if (event.getEventType() != EventType.StartList) {
            throw new IllegalStateException("Expected start list event: " + (Object)((Object)event.getEventType()));
        }
        int beforeIdx = 0;
        do {
            event = ctx.getReceiver().receiveValue(type);
            switch (event.getEventType()) {
                case NoChange: 
                case EndList: {
                    break;
                }
                case Delete: 
                case Add: 
                case Update: {
                    if (modified) break;
                    afterList = new ArrayList<T>(before.subList(0, beforeIdx));
                    modified = true;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unexpected operation: " + (Object)((Object)event.getEventType()));
                }
            }
            switch (event.getEventType()) {
                case NoChange: {
                    if (modified) {
                        afterList.add(before.get(beforeIdx));
                    }
                    ++beforeIdx;
                    break;
                }
                case Delete: {
                    ++beforeIdx;
                    break;
                }
                case Update: {
                    afterList.add(event.getMsg());
                    ++beforeIdx;
                    break;
                }
                case Add: {
                    afterList.add(event.getMsg());
                }
            }
        } while (event.getEventType() != EventType.EndList);
        return afterList.size() > afterSize ? afterList.subList(0, afterSize) : afterList;
    }

    static <T, I> void calculateListDiff(List<T> before, List<T> after, Function<T, I> idFunction, ListDiffConsumer<T> consumer) {
        int beforeIdx = 0;
        int afterIdx = 0;
        int beforeSize = before.size();
        int afterSize = after.size();
        Map<I, Integer> afterMap = null;
        while (beforeIdx < beforeSize || afterIdx < afterSize) {
            Integer newAfterIdx;
            I afterId;
            if (beforeIdx >= beforeSize) {
                consumer.accept(ListDiffConsumer.Operation.Add, -1, afterIdx, null, after.get(afterIdx++));
                continue;
            }
            if (afterIdx >= afterSize) {
                consumer.accept(ListDiffConsumer.Operation.Delete, beforeIdx, -1, before.get(beforeIdx++), null);
                continue;
            }
            if (before.get(beforeIdx) == after.get(afterIdx)) {
                consumer.accept(ListDiffConsumer.Operation.NoChange, beforeIdx, afterIdx, before.get(beforeIdx++), after.get(afterIdx++));
                continue;
            }
            I beforeId = idFunction.apply(before.get(beforeIdx));
            if (beforeId.equals(afterId = idFunction.apply(after.get(afterIdx)))) {
                consumer.accept(ListDiffConsumer.Operation.Update, beforeIdx, afterIdx, before.get(beforeIdx++), after.get(afterIdx++));
                continue;
            }
            if (afterMap == null) {
                afterMap = RemoteUtils.createIndexMap(after, afterIdx, idFunction);
            }
            if ((newAfterIdx = (Integer)afterMap.get(beforeId)) == null) {
                consumer.accept(ListDiffConsumer.Operation.Delete, beforeIdx, -1, before.get(beforeIdx++), null);
                continue;
            }
            consumer.accept(ListDiffConsumer.Operation.Add, -1, afterIdx, null, after.get(afterIdx++));
        }
    }

    private static <I, T> Map<I, Integer> createIndexMap(List<T> list, int fromIndex, Function<T, I> idFunction) {
        HashMap<I, Integer> result = new HashMap<I, Integer>(list.size() - fromIndex);
        for (int i = fromIndex; i < list.size(); ++i) {
            result.put(idFunction.apply(list.get(i)), i);
        }
        return result;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> cleaner.forEach((k, v) -> {
            try {
                v.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        })));
    }

    @FunctionalInterface
    static interface ListDiffConsumer<T> {
        public void accept(Operation var1, int var2, int var3, @Nullable T var4, @Nullable T var5);

        public static enum Operation {
            NoChange,
            Update,
            Add,
            Delete,
            Move;

        }
    }
}

