/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.Throwing;
import org.openrewrite.scheduling.WorkingDirectoryExecutionContextView;

public final class RecipeResources {
    private final String contextKey;
    private final ClassLoader classLoader;

    private RecipeResources(String keyPrefix, ClassLoader classLoader) {
        this.contextKey = keyPrefix + ".RESOURCES";
        this.classLoader = classLoader;
    }

    public static RecipeResources from(Class<?> contextClass) {
        String classPath = contextClass.getName().replace('.', '/') + ".class";
        URL resource = contextClass.getClassLoader().getResource(classPath);
        assert (resource != null);
        String key = resource.toString().substring(0, resource.toString().length() - classPath.length());
        return new RecipeResources(key, contextClass.getClassLoader());
    }

    public Path init(ExecutionContext ctx) {
        Path resources = (Path)ctx.getMessage(this.contextKey);
        if (resources == null) {
            resources = this.extractResources(() -> {
                WorkingDirectoryExecutionContextView view = WorkingDirectoryExecutionContextView.view((ExecutionContext)ctx);
                try {
                    return Files.createDirectory(view.getWorkingDirectory().resolve("recipe-resources"), new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException e) {
                    return view.getWorkingDirectory().resolve("recipe-resources");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            ctx.putMessage(this.contextKey, (Object)resources);
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path extractResources(Supplier<Path> dir) {
        Class<RecipeResources> clazz = RecipeResources.class;
        synchronized (RecipeResources.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.extractResources("META-INF/rewrite/resources", dir);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Path extractResources(String resource, Supplier<Path> dir) {
        try {
            FileSystem fileSystem;
            URI uri = Objects.requireNonNull(this.classLoader.getResource(resource)).toURI();
            if (!"jar".equals(uri.getScheme())) {
                if (!"file".equals(uri.getScheme())) throw new IllegalArgumentException("Unsupported scheme: " + uri.getScheme());
                return Paths.get(uri);
            }
            try {
                fileSystem = FileSystems.getFileSystem(uri);
            }
            catch (FileSystemNotFoundException e) {
                fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap(), null);
            }
            try (FileSystem localFileSystem = fileSystem;){
                Path source = localFileSystem.getPath("/" + resource, new String[0]);
                Path target = dir.get();
                RecipeResources.copyRecursively(source, target);
                Path path = target;
                return path;
            }
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static void copyRecursively(Path sourceDir, Path targetDir) throws IOException, InterruptedException {
        try (Stream<Path> stream = Files.walk(sourceDir, new FileVisitOption[0]);){
            stream.forEach(source -> {
                try {
                    Files.copy(source, targetDir.resolve(sourceDir.relativize((Path)source).toString()), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e) {
                    Throwing.sneakyThrow((Throwable)e);
                }
            });
        }
    }
}

