/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.remote.DiffEvent;
import org.openrewrite.remote.EventType;
import org.openrewrite.remote.RemotingContext;
import org.openrewrite.remote.TreeReceiver;

public class JsonReceiver
implements TreeReceiver {
    private final AtomicInteger receiveCounter = new AtomicInteger(0);
    private final RemotingContext context;
    private final JsonParser parser;
    private final DefaultDeserializationContext ctxt;
    private final ClassValue<JsonDeserializer<Object>> deserializerCache = new ClassValue<JsonDeserializer<Object>>(){

        @Override
        protected JsonDeserializer<Object> computeValue(Class<?> type) {
            JavaType javaType = JsonReceiver.this.ctxt.getTypeFactory().constructType(type);
            return JsonReceiver.this.ctxt.findRootValueDeserializer(javaType);
        }
    };
    private final boolean debug;
    private final Map<String, Class<?>> classCache = new HashMap();

    public JsonReceiver(InputStream in, RemotingContext context) {
        this.context = context;
        try {
            ObjectMapper mapper = context.objectMapper();
            this.parser = mapper.createParser(in);
            this.ctxt = ((DefaultDeserializationContext)mapper.getDeserializationContext()).createInstance(mapper.getDeserializationConfig(), this.parser, mapper.getInjectableValues());
            this.debug = context.debug();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonReceiver(JsonParser parser, RemotingContext context) {
        this.context = context;
        ObjectMapper mapper = context.objectMapper();
        this.parser = parser;
        this.ctxt = ((DefaultDeserializationContext)mapper.getDeserializationContext()).createInstance(mapper.getDeserializationConfig(), parser, mapper.getInjectableValues());
        this.debug = context.debug();
    }

    @Override
    public RemotingContext getContext() {
        return this.context;
    }

    @Override
    public DiffEvent receiveValue(Class<?> expectedType) {
        try {
            DiffEvent event = this.receiveEventForValue(expectedType);
            if (this.debug) {
                System.out.println("RECV " + this.receiveCounter.getAndIncrement() + ": " + event);
            }
            return event;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DiffEvent receiveNode() {
        try {
            DiffEvent event = this.receiveEventForNode();
            if (this.debug) {
                System.out.println("RECV " + this.receiveCounter.getAndIncrement() + ": " + event);
            }
            return event;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DiffEvent receiveEventForValue(Class<?> expectedType) throws IOException {
        JsonToken jsonToken = this.parser.nextToken();
        if (jsonToken != JsonToken.START_ARRAY) throw new IllegalStateException("Expected array but got " + jsonToken);
        jsonToken = this.parser.nextToken();
        if (jsonToken != JsonToken.VALUE_NUMBER_INT) {
            throw new IllegalStateException("Expected number but got " + jsonToken);
        }
        EventType eventType = EventType.values()[this.parser.getIntValue()];
        switch (eventType) {
            case Add: 
            case Update: {
                Object msg;
                JsonToken ignore;
                Class<?> concreteType = null;
                if (expectedType == Integer.class || expectedType == Integer.TYPE || List.class.isAssignableFrom(expectedType)) {
                    ignore = this.parser.nextToken();
                    msg = this.parser.getIntValue();
                } else if (expectedType == String.class) {
                    ignore = this.parser.nextToken();
                    msg = this.parser.getValueAsString();
                } else if (expectedType == UUID.class || expectedType == Path.class) {
                    ignore = this.parser.nextToken();
                    JsonDeserializer<Object> deserializer = this.deserializerCache.get(expectedType);
                    msg = deserializer.deserialize(this.parser, (DeserializationContext)this.ctxt);
                } else if (Enum.class.isAssignableFrom(expectedType) && expectedType != JavaType.Primitive.class) {
                    JsonToken enumOrdinal = this.parser.nextToken();
                    msg = enumOrdinal == JsonToken.VALUE_NULL ? null : expectedType.getEnumConstants()[this.parser.getIntValue()];
                } else if (expectedType == Boolean.class || expectedType == Boolean.TYPE) {
                    ignore = this.parser.nextToken();
                    msg = this.parser.getValueAsBoolean();
                } else if (expectedType == Long.class || expectedType == Long.TYPE) {
                    ignore = this.parser.nextToken();
                    msg = this.parser.getValueAsLong();
                } else {
                    jsonToken = this.parser.nextToken();
                    if (jsonToken == JsonToken.VALUE_STRING) {
                        String string = this.parser.getValueAsString();
                        JsonToken maybeValue = this.parser.nextToken();
                        if (maybeValue == JsonToken.END_ARRAY) return new DiffEvent(eventType, concreteType, string);
                        concreteType = this.getType(string);
                        JsonDeserializer<Object> deserializer = this.deserializerCache.get(concreteType);
                        msg = deserializer.deserialize(this.parser, (DeserializationContext)this.ctxt);
                    } else {
                        msg = jsonToken == JsonToken.VALUE_NULL ? null : (jsonToken == JsonToken.VALUE_FALSE ? Boolean.valueOf(false) : (jsonToken == JsonToken.VALUE_TRUE ? Boolean.valueOf(true) : this.deserializerCache.get(expectedType).deserialize(this.parser, (DeserializationContext)this.ctxt)));
                    }
                }
                ignore = this.parser.nextToken();
                return new DiffEvent(eventType, concreteType, msg);
            }
            case NoChange: 
            case Delete: 
            case StartList: 
            case EndList: {
                this.parser.nextToken();
                return new DiffEvent(eventType, null, null);
            }
        }
        throw new IllegalStateException("Expected array but got " + jsonToken);
    }

    private DiffEvent receiveEventForNode() throws IOException {
        JsonToken jsonToken = this.parser.nextToken();
        if (jsonToken == JsonToken.START_ARRAY) {
            jsonToken = this.parser.nextToken();
            if (jsonToken != JsonToken.VALUE_NUMBER_INT) {
                throw new IllegalStateException("Expected number but got " + jsonToken);
            }
            EventType eventType = EventType.values()[this.parser.getIntValue()];
            switch (eventType) {
                case Add: 
                case Update: {
                    Class<?> concreteType = null;
                    if (eventType == EventType.Add) {
                        JsonToken maybeEnd = this.parser.nextToken();
                        if (maybeEnd != JsonToken.END_ARRAY) {
                            concreteType = this.getType(this.parser.getValueAsString());
                            JsonToken jsonToken2 = this.parser.nextToken();
                        }
                    } else {
                        JsonToken jsonToken3 = this.parser.nextToken();
                    }
                    return new DiffEvent(eventType, concreteType, null);
                }
                case NoChange: 
                case Delete: 
                case StartList: 
                case EndList: {
                    this.parser.nextToken();
                    return new DiffEvent(eventType, null, null);
                }
            }
        }
        throw new IllegalStateException("Expected array but got " + jsonToken);
    }

    @NotNull
    private Class<?> getType(String className) {
        return this.classCache.computeIfAbsent(className, c -> {
            try {
                return Class.forName(c);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

