/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.remote.EventType;

public final class DiffEvent {
    private final EventType eventType;
    private final @Nullable Class<?> concreteType;
    private final @Nullable Object msg;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.eventType) {
            case NoChange: {
                sb.append("NOC");
                break;
            }
            case Add: {
                sb.append("ADD");
                break;
            }
            case Delete: {
                sb.append("DEL");
                break;
            }
            case Move: {
                sb.append("MOV");
                break;
            }
            case Update: {
                sb.append("UPD");
                break;
            }
            case StartList: {
                sb.append("STL");
                break;
            }
            case EndList: {
                sb.append("ENL");
            }
        }
        sb.append('{');
        if (this.concreteType != null) {
            sb.append(this.concreteType).append('{');
        }
        if (this.msg != null) {
            if (this.msg instanceof Tree) {
                sb.append(((Tree)this.msg).getId());
            } else if (this.msg instanceof Marker) {
                sb.append(((Marker)this.msg).getId());
            } else if (this.msg instanceof Markers) {
                sb.append(((Markers)this.msg).getId());
            } else if (this.msg instanceof String) {
                sb.append('\"').append(((String)this.msg).replace("\n", "\\n")).append('\"');
            } else {
                sb.append(this.msg);
            }
        }
        if (this.concreteType != null) {
            sb.append('}');
        }
        sb.append('}');
        return sb.toString();
    }

    @Generated
    public DiffEvent(EventType eventType, @Nullable Class<?> concreteType, @Nullable Object msg) {
        this.eventType = eventType;
        this.concreteType = concreteType;
        this.msg = msg;
    }

    @Generated
    public EventType getEventType() {
        return this.eventType;
    }

    @Generated
    public @Nullable Class<?> getConcreteType() {
        return this.concreteType;
    }

    @Generated
    public @Nullable Object getMsg() {
        return this.msg;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DiffEvent)) {
            return false;
        }
        DiffEvent other = (DiffEvent)o;
        EventType this$eventType = this.getEventType();
        EventType other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !((Object)((Object)this$eventType)).equals((Object)other$eventType)) {
            return false;
        }
        Class<?> this$concreteType = this.getConcreteType();
        Class<?> other$concreteType = other.getConcreteType();
        if (this$concreteType == null ? other$concreteType != null : !this$concreteType.equals(other$concreteType)) {
            return false;
        }
        Object this$msg = this.getMsg();
        Object other$msg = other.getMsg();
        return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventType $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : ((Object)((Object)$eventType)).hashCode());
        Class<?> $concreteType = this.getConcreteType();
        result = result * 59 + ($concreteType == null ? 43 : $concreteType.hashCode());
        Object $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        return result;
    }
}

