/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote.java;

import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Logger;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.Throwing;
import org.openrewrite.remote.RemoteUtils;
import org.openrewrite.remote.RemotingContext;
import org.openrewrite.remote.RemotingExecutionContextView;
import org.openrewrite.remote.RemotingMessageType;
import org.openrewrite.remote.RemotingMessenger;
import org.openrewrite.remote.java.CommonHandler;
import org.openrewrite.remote.java.RemotingClient;
import org.openrewrite.scheduling.WatchableExecutionContext;

public final class RemotingServer {
    @Generated
    private static final Logger log = Logger.getLogger(RemotingServer.class.getName());
    private static final boolean debug = false;
    private static final byte[] MESSAGE_END = new byte[]{-127, 23};
    private static final int BUFFER_SIZE = 8192;
    private final ByteBuffer receiveBuffer = ByteBuffer.allocate(8192);
    private final ByteBuffer sendBuffer = ByteBuffer.allocate(8192);
    private final byte[] bytes = new byte[8192];
    private final ExecutorService service = Executors.newSingleThreadExecutor();
    private final int port;
    private final RemotingContext context;
    private final long timeout;
    private final TimeUnit unit;
    private final CBORFactory factory = new CBORFactory();
    private final List<Recipe> recipes = new ArrayList<Recipe>();
    private @Nullable ServerSocket serverSocket;
    private @Nullable Socket activeSocket;
    private CountDownLatch started = new CountDownLatch(1);
    private @Nullable SourceFile remoteState;
    private final Map<String, Supplier<RemotingMessenger.RequestHandler<?>>> handlers;

    public RemotingServer(int port, RemotingContext context, long timeout, TimeUnit unit) {
        this.port = port;
        this.context = context;
        this.timeout = timeout;
        this.unit = unit;
        this.handlers = CommonHandler.createHandlersMapping(context, this.recipes);
    }

    public static RemotingServer create(ExecutionContext ctx, ClassLoader classLoader) {
        return RemotingServer.create(ctx, classLoader, 65432, 2L, TimeUnit.MINUTES);
    }

    public static RemotingServer create(ExecutionContext ctx, ClassLoader classLoader, int port) {
        return RemotingServer.create(ctx, classLoader, port, 2L, TimeUnit.MINUTES);
    }

    public static RemotingServer create(ExecutionContext ctx, ClassLoader classLoader, int port, long timeout, TimeUnit unit) {
        RemotingServer remotingServer = (RemotingServer)ctx.getMessage(RemotingServer.class.getName());
        if (remotingServer == null) {
            RemotingContext context = new RemotingContext(classLoader, false);
            remotingServer = new RemotingServer(port, context, timeout, unit);
            ctx.putMessage(RemotingServer.class.getName(), (Object)remotingServer);
        }
        return remotingServer;
    }

    void ensureStarted() {
        if (this.started.getCount() == 0L) {
            return;
        }
        this.service.execute(() -> {
            try (ServerSocket serverSocket = new ServerSocket(this.port, 50, InetAddress.getLoopbackAddress());){
                this.serverSocket = serverSocket;
                this.started.countDown();
                System.out.println("Remoting server started on " + this.port + " ...");
                long timeoutMillis = System.currentTimeMillis() + this.unit.toMillis(this.timeout);
                while (System.currentTimeMillis() < timeoutMillis) {
                    try {
                        RemotingServer remotingServer = this;
                        synchronized (remotingServer) {
                            Socket socket = serverSocket.accept();
                            try {
                                this.activeSocket = socket;
                                log.fine("Remoting server accepted " + socket);
                                ResponseBuffer response = this.processRequest(socket);
                                while (response != null) {
                                    this.writeResponse(socket, response);
                                    response = this.processRequest(socket);
                                }
                            }
                            catch (SocketException e) {
                                log.info("Connection closed");
                            }
                        }
                    }
                    finally {
                        if (Thread.currentThread().isInterrupted()) break;
                    }
                }
                this.started = new CountDownLatch(1);
            }
            catch (IOException e) {
                Throwing.sneakyThrow((Throwable)e);
            }
        });
        try {
            if (!this.started.await(5L, TimeUnit.SECONDS)) {
                this.stop();
                throw new IllegalStateException("Failed to start RemotingServer on " + this.port);
            }
            RemoteUtils.cleaner.put(this, () -> {
                try {
                    this.serverSocket.close();
                    log.info("terminating server " + this.service.shutdownNow());
                    this.service.awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (IOException | InterruptedException exception) {
                    // empty catch block
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        if (this.serverSocket != null) {
            this.serverSocket.close();
            if (this.activeSocket != null) {
                this.activeSocket.close();
            }
        }
        this.service.shutdownNow();
        this.service.awaitTermination(5L, TimeUnit.SECONDS);
        this.started = new CountDownLatch(1);
    }

    private void writeResponse(Socket client, ResponseBuffer response) {
        try {
            response.toSocket(client);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private @Nullable ResponseBuffer processRequest(Socket socket) throws IOException {
        byte[] bytes = new byte[1];
        int read = socket.getInputStream().read(bytes);
        if (read <= 0) {
            return null;
        }
        RemotingMessageType messageType = RemotingMessageType.of((int)bytes[0]);
        assert (messageType == RemotingMessageType.Request);
        ResponseBuffer outputStream = new ResponseBuffer();
        return new RemotingMessenger((CBORFactory)this.context.objectMapper().getFactory(), this.handlers, messenger -> {
            InMemoryExecutionContext ctx = new InMemoryExecutionContext();
            RemotingExecutionContextView view = RemotingExecutionContextView.view((ExecutionContext)ctx);
            view.setRemotingContext(this.context);
            view.putMessage("org.openrewrite.remote.remotingClient", (Object)RemotingClient.create(this.context, messenger, socket));
            return ctx;
        }).processRequest(socket) ? outputStream : null;
    }

    public static void main(String[] args) {
        WatchableExecutionContext ctx = new WatchableExecutionContext((ExecutionContext)new InMemoryExecutionContext());
        RemotingServer server = args.length == 0 ? RemotingServer.create((ExecutionContext)ctx, RemotingServer.class.getClassLoader(), 65432, 1L, TimeUnit.DAYS) : RemotingServer.create((ExecutionContext)ctx, RemotingServer.class.getClassLoader(), Integer.parseInt(args[0]), 2L, TimeUnit.MINUTES);
        server.ensureStarted();
    }

    @Generated
    public ByteBuffer getReceiveBuffer() {
        return this.receiveBuffer;
    }

    @Generated
    public ByteBuffer getSendBuffer() {
        return this.sendBuffer;
    }

    @Generated
    public byte[] getBytes() {
        return this.bytes;
    }

    @Generated
    public ExecutorService getService() {
        return this.service;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public RemotingContext getContext() {
        return this.context;
    }

    @Generated
    public long getTimeout() {
        return this.timeout;
    }

    @Generated
    public TimeUnit getUnit() {
        return this.unit;
    }

    @Generated
    public CBORFactory getFactory() {
        return this.factory;
    }

    @Generated
    public List<Recipe> getRecipes() {
        return this.recipes;
    }

    @Generated
    public @Nullable ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    @Generated
    public @Nullable Socket getActiveSocket() {
        return this.activeSocket;
    }

    @Generated
    public CountDownLatch getStarted() {
        return this.started;
    }

    @Generated
    public @Nullable SourceFile getRemoteState() {
        return this.remoteState;
    }

    @Generated
    public Map<String, Supplier<RemotingMessenger.RequestHandler<?>>> getHandlers() {
        return this.handlers;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemotingServer)) {
            return false;
        }
        RemotingServer other = (RemotingServer)o;
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        ByteBuffer this$receiveBuffer = this.getReceiveBuffer();
        ByteBuffer other$receiveBuffer = other.getReceiveBuffer();
        if (this$receiveBuffer == null ? other$receiveBuffer != null : !((Object)this$receiveBuffer).equals(other$receiveBuffer)) {
            return false;
        }
        ByteBuffer this$sendBuffer = this.getSendBuffer();
        ByteBuffer other$sendBuffer = other.getSendBuffer();
        if (this$sendBuffer == null ? other$sendBuffer != null : !((Object)this$sendBuffer).equals(other$sendBuffer)) {
            return false;
        }
        if (!Arrays.equals(this.getBytes(), other.getBytes())) {
            return false;
        }
        ExecutorService this$service = this.getService();
        ExecutorService other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        RemotingContext this$context = this.getContext();
        RemotingContext other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        TimeUnit this$unit = this.getUnit();
        TimeUnit other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !((Object)((Object)this$unit)).equals((Object)other$unit)) {
            return false;
        }
        CBORFactory this$factory = this.getFactory();
        CBORFactory other$factory = other.getFactory();
        if (this$factory == null ? other$factory != null : !this$factory.equals(other$factory)) {
            return false;
        }
        List<Recipe> this$recipes = this.getRecipes();
        List<Recipe> other$recipes = other.getRecipes();
        if (this$recipes == null ? other$recipes != null : !((Object)this$recipes).equals(other$recipes)) {
            return false;
        }
        ServerSocket this$serverSocket = this.getServerSocket();
        ServerSocket other$serverSocket = other.getServerSocket();
        if (this$serverSocket == null ? other$serverSocket != null : !this$serverSocket.equals(other$serverSocket)) {
            return false;
        }
        Socket this$activeSocket = this.getActiveSocket();
        Socket other$activeSocket = other.getActiveSocket();
        if (this$activeSocket == null ? other$activeSocket != null : !this$activeSocket.equals(other$activeSocket)) {
            return false;
        }
        CountDownLatch this$started = this.getStarted();
        CountDownLatch other$started = other.getStarted();
        if (this$started == null ? other$started != null : !this$started.equals(other$started)) {
            return false;
        }
        SourceFile this$remoteState = this.getRemoteState();
        SourceFile other$remoteState = other.getRemoteState();
        if (this$remoteState == null ? other$remoteState != null : !this$remoteState.equals(other$remoteState)) {
            return false;
        }
        Map<String, Supplier<RemotingMessenger.RequestHandler<?>>> this$handlers = this.getHandlers();
        Map<String, Supplier<RemotingMessenger.RequestHandler<?>>> other$handlers = other.getHandlers();
        return !(this$handlers == null ? other$handlers != null : !((Object)this$handlers).equals(other$handlers));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        long $timeout = this.getTimeout();
        result = result * 59 + (int)($timeout >>> 32 ^ $timeout);
        ByteBuffer $receiveBuffer = this.getReceiveBuffer();
        result = result * 59 + ($receiveBuffer == null ? 43 : ((Object)$receiveBuffer).hashCode());
        ByteBuffer $sendBuffer = this.getSendBuffer();
        result = result * 59 + ($sendBuffer == null ? 43 : ((Object)$sendBuffer).hashCode());
        result = result * 59 + Arrays.hashCode(this.getBytes());
        ExecutorService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        RemotingContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        TimeUnit $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : ((Object)((Object)$unit)).hashCode());
        CBORFactory $factory = this.getFactory();
        result = result * 59 + ($factory == null ? 43 : $factory.hashCode());
        List<Recipe> $recipes = this.getRecipes();
        result = result * 59 + ($recipes == null ? 43 : ((Object)$recipes).hashCode());
        ServerSocket $serverSocket = this.getServerSocket();
        result = result * 59 + ($serverSocket == null ? 43 : $serverSocket.hashCode());
        Socket $activeSocket = this.getActiveSocket();
        result = result * 59 + ($activeSocket == null ? 43 : $activeSocket.hashCode());
        CountDownLatch $started = this.getStarted();
        result = result * 59 + ($started == null ? 43 : $started.hashCode());
        SourceFile $remoteState = this.getRemoteState();
        result = result * 59 + ($remoteState == null ? 43 : $remoteState.hashCode());
        Map<String, Supplier<RemotingMessenger.RequestHandler<?>>> $handlers = this.getHandlers();
        result = result * 59 + ($handlers == null ? 43 : ((Object)$handlers).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RemotingServer(receiveBuffer=" + this.getReceiveBuffer() + ", sendBuffer=" + this.getSendBuffer() + ", bytes=" + Arrays.toString(this.getBytes()) + ", service=" + this.getService() + ", port=" + this.getPort() + ", context=" + this.getContext() + ", timeout=" + this.getTimeout() + ", unit=" + (Object)((Object)this.getUnit()) + ", factory=" + this.getFactory() + ", recipes=" + this.getRecipes() + ", serverSocket=" + this.getServerSocket() + ", activeSocket=" + this.getActiveSocket() + ", started=" + this.getStarted() + ", remoteState=" + this.getRemoteState() + ", handlers=" + this.getHandlers() + ")";
    }

    private static final class ResponseBuffer
    extends ByteArrayOutputStream {
        ResponseBuffer() {
            super(4096);
        }

        public void toSocket(Socket socket) throws IOException {
            socket.getOutputStream().write(this.buf, 0, this.count);
        }
    }
}

