/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote.java;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.dataformat.cbor.CBORGenerator;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.LargeSourceSet;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeRun;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.InMemoryLargeSourceSet;
import org.openrewrite.remote.RemotingContext;
import org.openrewrite.remote.RemotingMessenger;
import org.openrewrite.remote.java.RemotingRecipe;

public class CommonHandler {
    public static Map<String, Supplier<RemotingMessenger.RequestHandler<?>>> createHandlersMapping(final RemotingContext context, final List<Recipe> recipes) {
        return new HashMap<String, Supplier<RemotingMessenger.RequestHandler<?>>>(){
            {
                this.put("reset", () -> RemotingMessenger.RequestHandler.of((parser, ctx) -> null, (ignore, generator, ctx) -> {
                    context.reset();
                    recipes.clear();
                }));
                this.put("load-recipe", () -> RemotingMessenger.RequestHandler.of((parser, ctx) -> {
                    Recipe recipe;
                    parser.nextToken();
                    String recipeName = parser.getValueAsString();
                    try {
                        Class recipeClass = context.findClass(recipeName);
                        Constructor constructor = recipeClass.getConstructor(new Class[0]);
                        constructor.setAccessible(true);
                        recipe = (Recipe)constructor.newInstance(new Object[0]);
                        parser.nextToken();
                        TreeNode treeNode = parser.readValueAsTree();
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                    return recipe;
                }, (recipe, generator, ctx) -> {
                    recipes.add(recipe);
                    generator.writeNumber(recipes.size() - 1);
                }));
                this.put("run-recipe-visitor", () -> new RemotingMessenger.RequestHandler<SourceFile>(){
                    private @Nullable SourceFile sourceFile;

                    public @Nullable SourceFile receiveRequest(CBORParser parser, ExecutionContext ctx) throws IOException {
                        parser.nextToken();
                        Recipe recipe = (Recipe)recipes.get(parser.getIntValue());
                        this.sourceFile = (SourceFile)RemotingMessenger.receiveTree((RemotingContext)context, (CBORParser)parser, null);
                        return (SourceFile)Objects.requireNonNull(recipe).getVisitor().visit((Tree)this.sourceFile, (Object)ctx);
                    }

                    public void sendResponse(@Nullable SourceFile updated, CBORGenerator generator, ExecutionContext ctx) {
                        RemotingMessenger.sendTree((RemotingContext)context, (CBORGenerator)generator, (SourceFile)updated, (SourceFile)this.sourceFile);
                    }
                });
                this.put("run-recipe", () -> new RemotingMessenger.RequestHandler<RecipeRun>(){
                    private final List<SourceFile> sourceFiles = new ArrayList<SourceFile>();

                    public RecipeRun receiveRequest(CBORParser parser, ExecutionContext ctx) throws IOException {
                        parser.nextToken();
                        String recipeName = parser.getValueAsString();
                        parser.nextToken();
                        HashMap options = (HashMap)parser.readValueAs((TypeReference)new TypeReference<Map<String, Object>>(){});
                        ArrayList<OptionDescriptor> recipeOptions = new ArrayList<OptionDescriptor>();
                        for (Map.Entry entry : options.entrySet()) {
                            recipeOptions.add(new OptionDescriptor((String)entry.getKey(), "", null, null, null, null, true, null));
                        }
                        RecipeDescriptor recipeDescriptor = new RecipeDescriptor(recipeName, "", "", Collections.emptySet(), null, recipeOptions, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), URI.create("recipe://" + recipeName));
                        parser.nextToken();
                        int fileCount = parser.getIntValue();
                        for (int i = 0; i < fileCount; ++i) {
                            this.sourceFiles.add((SourceFile)RemotingMessenger.receiveTree((RemotingContext)context, (CBORParser)parser, null));
                        }
                        InMemoryLargeSourceSet largeSourceSet = new InMemoryLargeSourceSet(this.sourceFiles);
                        RemotingRecipe recipe = new RemotingRecipe(recipeDescriptor);
                        return recipe.run((LargeSourceSet)largeSourceSet, ctx);
                    }

                    public void sendResponse(@Nullable RecipeRun recipeRun, CBORGenerator generator, ExecutionContext ctx) {
                        if (recipeRun.getChangeset().size() == 0) {
                            for (SourceFile sourceFile : this.sourceFiles) {
                                RemotingMessenger.sendTree((RemotingContext)context, (CBORGenerator)generator, (SourceFile)sourceFile, (SourceFile)sourceFile);
                            }
                        } else {
                            List results = recipeRun.getChangeset().getAllResults();
                            for (Result result : results) {
                                RemotingMessenger.sendTree((RemotingContext)context, (CBORGenerator)generator, (SourceFile)result.getAfter(), (SourceFile)result.getBefore());
                            }
                        }
                    }
                });
                this.put("print", () -> RemotingMessenger.RequestHandler.of((parser, ctx) -> {
                    Tree received = RemotingMessenger.receiveTree((RemotingContext)context, (CBORParser)parser, null);
                    return context.getProvider(received.getClass()).newValidator().validate(received, ctx);
                }, (tree, generator, ctx) -> {
                    String print = Objects.requireNonNull(tree).print(new Cursor(null, (Object)"root"));
                    generator.writeString(print);
                }));
            }
        };
    }
}

