/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote.java;

import java.util.Objects;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.remote.RemotingExecutionContextView;
import org.openrewrite.remote.java.RemotingClient;

final class RemotingRecipe
extends Recipe {
    private final RecipeDescriptor recipeDescriptor;

    public String getDisplayName() {
        return this.recipeDescriptor.getDisplayName();
    }

    public String getDescription() {
        return this.recipeDescriptor.getDescription();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    SourceFile sourceFile = (SourceFile)tree;
                    RemotingClient client = (RemotingClient)((Object)RemotingExecutionContextView.view((ExecutionContext)ctx).getMessage("org.openrewrite.remote.remotingClient"));
                    return Objects.requireNonNull(client).runRecipe(RemotingRecipe.this.recipeDescriptor, sourceFile);
                }
                return tree;
            }
        };
    }

    @Generated
    public RemotingRecipe(RecipeDescriptor recipeDescriptor) {
        this.recipeDescriptor = recipeDescriptor;
    }

    @Generated
    public RecipeDescriptor getRecipeDescriptor() {
        return this.recipeDescriptor;
    }

    @Generated
    public String toString() {
        return "RemotingRecipe(recipeDescriptor=" + this.getRecipeDescriptor() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemotingRecipe)) {
            return false;
        }
        RemotingRecipe other = (RemotingRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        RecipeDescriptor this$recipeDescriptor = this.getRecipeDescriptor();
        RecipeDescriptor other$recipeDescriptor = other.getRecipeDescriptor();
        return !(this$recipeDescriptor == null ? other$recipeDescriptor != null : !this$recipeDescriptor.equals(other$recipeDescriptor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemotingRecipe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RecipeDescriptor $recipeDescriptor = this.getRecipeDescriptor();
        result = result * 59 + ($recipeDescriptor == null ? 43 : $recipeDescriptor.hashCode());
        return result;
    }
}

