/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote.java;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.remote.AbstractRemotingClient;
import org.openrewrite.remote.ReceiverContext;
import org.openrewrite.remote.RemotingContext;
import org.openrewrite.remote.RemotingExecutionContextView;
import org.openrewrite.remote.RemotingMessenger;
import org.openrewrite.remote.TreeReceiver;

public final class RemotingClient
extends AbstractRemotingClient {
    static final String REMOTING_CLIENT = "org.openrewrite.remote.remotingClient";
    private static final boolean debug = false;
    private @Nullable SourceFile remoteState;
    private final Map<RecipeDescriptor, Integer> remoteRecipes = new HashMap<RecipeDescriptor, Integer>();

    public RemotingClient(Supplier<Socket> socketSupplier, RemotingContext context, RemotingMessenger messenger) {
        super(socketSupplier, context, messenger);
    }

    public static RemotingClient create(ExecutionContext ctx, Class<?> contextClass, Supplier<Socket> socketChannelSupplier) {
        RemotingExecutionContextView view = RemotingExecutionContextView.view((ExecutionContext)ctx);
        RemotingContext context = view.getRemotingContext();
        if (context == null) {
            context = new RemotingContext(contextClass.getClassLoader(), false);
        }
        return new RemotingClient(socketChannelSupplier, context, new RemotingMessenger((CBORFactory)context.objectMapper().getFactory(), Collections.emptyMap(), m -> new InMemoryExecutionContext()));
    }

    static RemotingClient create(RemotingContext context, RemotingMessenger messenger, Socket openSocket) {
        RemotingClient client = new RemotingClient(() -> openSocket, context, messenger);
        client.socket = openSocket;
        return client;
    }

    public <T extends SourceFile> T runRecipe(RecipeDescriptor recipe, T sourceFile) {
        if (this.remoteState != null && !this.remoteState.equals(sourceFile)) {
            this.remoteState = null;
        }
        this.remoteState = this.runUsingSocket((socket, messenger) -> this.runRecipe0(recipe, sourceFile, (SourceFile)this.remoteState, (Socket)socket));
        return (T)this.remoteState;
    }

    private <T extends SourceFile> T runRecipe0(RecipeDescriptor recipe, T sourceFile, @Nullable T remoteState, Socket socket) {
        int recipeId = this.sendLoadRecipe(recipe, socket);
        return (T)Objects.requireNonNull((SourceFile)this.messenger.sendRequest(generator -> {
            generator.writeString("run-recipe-visitor");
            generator.writeNumber(recipeId);
            this.context.newSenderContext((JsonGenerator)generator).sendTree((Tree)sourceFile, (Tree)remoteState);
        }, parser -> (SourceFile)new ReceiverContext((TreeReceiver)this.context.newReceiver((JsonParser)parser), this.context).receiveTree((Tree)sourceFile), socket));
    }

    private int sendLoadRecipe(RecipeDescriptor recipe, Socket socket) {
        if (this.remoteRecipes.isEmpty()) {
            // empty if block
        }
        if (!this.remoteRecipes.containsKey(recipe)) {
            Integer recipeId = (Integer)this.messenger.sendRequest(generator -> {
                generator.writeString("load-recipe");
                generator.writeString(recipe.getName());
                generator.writeStartObject();
                List options = recipe.getOptions();
                for (OptionDescriptor option : options) {
                    generator.writeFieldName(option.getName());
                    generator.writeObject(option.getValue());
                }
                generator.writeEndObject();
            }, parser -> {
                parser.nextToken();
                return parser.getIntValue();
            }, socket);
            this.remoteRecipes.put(recipe, recipeId);
        }
        return this.remoteRecipes.get(recipe);
    }

    public <T> T runUsingSocket(BiFunction<Socket, RemotingMessenger, T> command) {
        return (T)this.withActiveSocket(s -> command.apply((Socket)s, this.messenger));
    }

    private void sendReset() {
        this.runUsingSocket((socket, messenger) -> {
            messenger.sendReset(socket);
            return null;
        });
        this.remoteRecipes.clear();
    }

    @Generated
    public @Nullable SourceFile getRemoteState() {
        return this.remoteState;
    }

    @Generated
    public Map<RecipeDescriptor, Integer> getRemoteRecipes() {
        return this.remoteRecipes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemotingClient)) {
            return false;
        }
        RemotingClient other = (RemotingClient)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        SourceFile this$remoteState = this.getRemoteState();
        SourceFile other$remoteState = other.getRemoteState();
        if (this$remoteState == null ? other$remoteState != null : !this$remoteState.equals(other$remoteState)) {
            return false;
        }
        Map<RecipeDescriptor, Integer> this$remoteRecipes = this.getRemoteRecipes();
        Map<RecipeDescriptor, Integer> other$remoteRecipes = other.getRemoteRecipes();
        return !(this$remoteRecipes == null ? other$remoteRecipes != null : !((Object)this$remoteRecipes).equals(other$remoteRecipes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemotingClient;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SourceFile $remoteState = this.getRemoteState();
        result = result * 59 + ($remoteState == null ? 43 : $remoteState.hashCode());
        Map<RecipeDescriptor, Integer> $remoteRecipes = this.getRemoteRecipes();
        result = result * 59 + ($remoteRecipes == null ? 43 : ((Object)$remoteRecipes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RemotingClient(remoteState=" + this.getRemoteState() + ", remoteRecipes=" + this.getRemoteRecipes() + ")";
    }
}

