/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python.marker;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Marker;

public final class GroupedStatement
implements Marker {
    private final UUID id;
    private final UUID groupId;

    @Nullable
    public static <T extends Statement> StatementGroup<T> findCurrentStatementGroup(List<JRightPadded<T>> statements, int firstIndex) {
        UUID nextId;
        int lastIndex;
        @Nullable UUID firstId = GroupedStatement.getGroupId(statements.get(firstIndex));
        if (firstId == null) {
            return null;
        }
        for (lastIndex = firstIndex; lastIndex < statements.size() - 1 && (nextId = GroupedStatement.getGroupId(statements.get(lastIndex + 1))) != null && nextId.equals(firstId); ++lastIndex) {
        }
        return new StatementGroup(firstIndex, lastIndex, JRightPadded.getElements(statements).subList(firstIndex, lastIndex + 1));
    }

    @Nullable
    public static <T extends Statement> UUID getGroupId(JRightPadded<T> padded) {
        return GroupedStatement.getGroupId((Statement)padded.getElement());
    }

    @Nullable
    public static UUID getGroupId(Statement statement) {
        Optional marker = statement.getMarkers().findFirst(GroupedStatement.class);
        if (marker.isPresent()) {
            return ((GroupedStatement)marker.get()).getGroupId();
        }
        return null;
    }

    public GroupedStatement(UUID id, UUID groupId) {
        this.id = id;
        this.groupId = groupId;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getGroupId() {
        return this.groupId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupedStatement)) {
            return false;
        }
        GroupedStatement other = (GroupedStatement)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$groupId = this.getGroupId();
        UUID other$groupId = other.getGroupId();
        return !(this$groupId == null ? other$groupId != null : !((Object)this$groupId).equals(other$groupId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : ((Object)$groupId).hashCode());
        return result;
    }

    public String toString() {
        return "GroupedStatement(id=" + this.getId() + ", groupId=" + this.getGroupId() + ")";
    }

    public GroupedStatement withId(UUID id) {
        return this.id == id ? this : new GroupedStatement(id, this.groupId);
    }

    public GroupedStatement withGroupId(UUID groupId) {
        return this.groupId == groupId ? this : new GroupedStatement(this.id, groupId);
    }

    public static final class StatementGroup<T extends Statement> {
        private final int firstIndex;
        private final int lastIndex;
        private final List<T> statements;

        public boolean containsIndex(int index) {
            return index >= this.firstIndex && index <= this.lastIndex;
        }

        public StatementGroup(int firstIndex, int lastIndex, List<T> statements) {
            this.firstIndex = firstIndex;
            this.lastIndex = lastIndex;
            this.statements = statements;
        }

        public int getFirstIndex() {
            return this.firstIndex;
        }

        public int getLastIndex() {
            return this.lastIndex;
        }

        public List<T> getStatements() {
            return this.statements;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatementGroup)) {
                return false;
            }
            StatementGroup other = (StatementGroup)o;
            if (this.getFirstIndex() != other.getFirstIndex()) {
                return false;
            }
            if (this.getLastIndex() != other.getLastIndex()) {
                return false;
            }
            List<T> this$statements = this.getStatements();
            List<T> other$statements = other.getStatements();
            return !(this$statements == null ? other$statements != null : !((Object)this$statements).equals(other$statements));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getFirstIndex();
            result = result * 59 + this.getLastIndex();
            List<T> $statements = this.getStatements();
            result = result * 59 + ($statements == null ? 43 : ((Object)$statements).hashCode());
            return result;
        }

        public String toString() {
            return "GroupedStatement.StatementGroup(firstIndex=" + this.getFirstIndex() + ", lastIndex=" + this.getLastIndex() + ", statements=" + this.getStatements() + ")";
        }
    }
}

