/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyStringLiteralCoreUtil;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl;
import org.jetbrains.annotations.NotNull;

public class PyStringLiteralExpressionManipulator
extends AbstractElementManipulator<PyStringLiteralExpressionImpl> {
    public PyStringLiteralExpressionImpl handleContentChange(@NotNull PyStringLiteralExpressionImpl element, @NotNull TextRange range, String newContent) {
        if (element == null) {
            PyStringLiteralExpressionManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            PyStringLiteralExpressionManipulator.$$$reportNull$$$0(1);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(element.getProject());
        String escapedText = PyStringLiteralExpressionManipulator.calculateEscapedText(element.getText(), range, newContent);
        PyStringLiteralExpression escaped = elementGenerator.createStringLiteralAlreadyEscaped(escapedText);
        return (PyStringLiteralExpressionImpl)element.replace(escaped);
    }

    public PyStringLiteralExpressionImpl handleContentChange(@NotNull PyStringLiteralExpressionImpl element, String newContent) throws IncorrectOperationException {
        if (element == null) {
            PyStringLiteralExpressionManipulator.$$$reportNull$$$0(2);
        }
        return this.handleContentChange(element, TextRange.create(0, element.getTextLength()), newContent);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull PyStringLiteralExpressionImpl element) {
        if (element == null) {
            PyStringLiteralExpressionManipulator.$$$reportNull$$$0(3);
        }
        TextRange textRange = element.getStringValueTextRange();
        if (textRange == null) {
            PyStringLiteralExpressionManipulator.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    @NotNull
    private static String calculateEscapedText(@NotNull String prevText, @NotNull TextRange range, String newContent) {
        String newText;
        if (prevText == null) {
            PyStringLiteralExpressionManipulator.$$$reportNull$$$0(5);
        }
        if (range == null) {
            PyStringLiteralExpressionManipulator.$$$reportNull$$$0(6);
        }
        if (PyStringLiteralCoreUtil.isQuoted(newText = range.replace(prevText, newContent))) {
            String string = newText;
            if (string == null) {
                PyStringLiteralExpressionManipulator.$$$reportNull$$$0(7);
            }
            return string;
        }
        Pair<String, String> quotes = PyStringLiteralExpressionManipulator.calculateQuotes(prevText);
        String string = (String)quotes.first + newText + (String)quotes.second;
        if (string == null) {
            PyStringLiteralExpressionManipulator.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static Pair<String, String> calculateQuotes(@NotNull String text) {
        Pair<String, String> quotes;
        if (text == null) {
            PyStringLiteralExpressionManipulator.$$$reportNull$$$0(9);
        }
        if ((quotes = PyStringLiteralCoreUtil.getQuotes(text)) == null || quotes.first == null && quotes.second == null) {
            Pair.NonNull<String, String> nonNull = Pair.createNonNull("\"", "\"");
            if (nonNull == null) {
                PyStringLiteralExpressionManipulator.$$$reportNull$$$0(10);
            }
            return nonNull;
        }
        if (quotes.first == null) {
            Pair.NonNull<String, String> nonNull = Pair.createNonNull((String)quotes.second, (String)quotes.second);
            if (nonNull == null) {
                PyStringLiteralExpressionManipulator.$$$reportNull$$$0(11);
            }
            return nonNull;
        }
        if (quotes.second == null) {
            Pair.NonNull<String, String> nonNull = Pair.createNonNull((String)quotes.first, (String)quotes.first);
            if (nonNull == null) {
                PyStringLiteralExpressionManipulator.$$$reportNull$$$0(12);
            }
            return nonNull;
        }
        Pair<String, String> pair = quotes;
        if (pair == null) {
            PyStringLiteralExpressionManipulator.$$$reportNull$$$0(13);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 8, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyStringLiteralExpressionManipulator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyStringLiteralExpressionManipulator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateEscapedText";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateQuotes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calculateEscapedText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calculateQuotes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 8, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

