/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PyUserInitiatedResolvableReference;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.pyi.PyiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyGotoDeclarationHandler
extends GotoDeclarationHandlerBase {
    @Nullable
    public PsiElement getGotoDeclarationTarget(@Nullable PsiElement sourceElement, Editor editor) {
        if (sourceElement == null) {
            return null;
        }
        PyResolveContext context = PyResolveContext.defaultContext(TypeEvalContext.userInitiated(sourceElement.getProject(), sourceElement.getContainingFile()));
        PyReferenceOwner referenceOwner = null;
        PsiElement parent = sourceElement.getParent();
        if (sourceElement instanceof PyReferenceOwner) {
            referenceOwner = (PyReferenceOwner)sourceElement;
        } else if (parent instanceof PyReferenceOwner) {
            referenceOwner = (PyReferenceOwner)parent;
        }
        if (referenceOwner != null) {
            PsiElement resolved = PyResolveUtil.resolveDeclaration(referenceOwner.getReference(context), context);
            if (resolved != null && resolved.getContainingFile() instanceof PyiFile) {
                return ObjectUtils.chooseNotNull(PyiUtil.getOriginalElement((PyElement)((PyElement)resolved)), resolved);
            }
            return resolved != referenceOwner ? resolved : null;
        }
        PsiElement element = PyGotoDeclarationHandler.findProvidedReferenceAndResolve(sourceElement);
        if (element != null) {
            return element;
        }
        if (parent != null) {
            return PyGotoDeclarationHandler.findProvidedReferenceAndResolve(parent);
        }
        return null;
    }

    @Nullable
    private static PsiElement findProvidedReferenceAndResolve(@NotNull PsiElement sourceElement) {
        if (sourceElement == null) {
            PyGotoDeclarationHandler.$$$reportNull$$$0(0);
        }
        for (PsiReference reference : sourceElement.getReferences()) {
            PsiElement element;
            if (!(reference instanceof PyUserInitiatedResolvableReference) || (element = ((PyUserInitiatedResolvableReference)reference).userInitiatedResolve()) == null || element == sourceElement) continue;
            return element;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/jetbrains/python/psi/impl/PyGotoDeclarationHandler", "findProvidedReferenceAndResolve"));
    }
}

