/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySliceExpression;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyElementImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyAssignmentStatementImpl
extends PyElementImpl
implements PyAssignmentStatement {
    private volatile PyExpression @Nullable [] myTargets;

    public PyAssignmentStatementImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyAssignmentStatement(this);
    }

    @Override
    public PyExpression @NotNull [] getTargets() {
        PyExpression[] result = this.myTargets;
        if (result == null) {
            result = this.calcTargets(false);
            this.myTargets = result;
        }
        if (result == null) {
            PyAssignmentStatementImpl.$$$reportNull$$$0(0);
        }
        return result;
    }

    @Override
    public PyExpression @NotNull [] getRawTargets() {
        return this.calcTargets(true);
    }

    private PyExpression @NotNull [] calcTargets(boolean raw) {
        ASTNode[] eqSigns = this.getNode().getChildren(TokenSet.create(PyTokenTypes.EQ));
        if (eqSigns.length == 0) {
            if (PyExpression.EMPTY_ARRAY == null) {
                PyAssignmentStatementImpl.$$$reportNull$$$0(1);
            }
            return PyExpression.EMPTY_ARRAY;
        }
        ASTNode lastEq = eqSigns[eqSigns.length - 1];
        ArrayList<PyExpression> candidates = new ArrayList<PyExpression>();
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null && node != lastEq; node = node.getTreeNext()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof PyExpression)) continue;
            if (raw) {
                candidates.add((PyExpression)psi);
                continue;
            }
            PyAssignmentStatementImpl.addCandidate(candidates, (PyExpression)psi);
        }
        ArrayList<PyExpression> targets = new ArrayList<PyExpression>();
        for (PyExpression expr : candidates) {
            if (!raw && !(expr instanceof PyTargetExpression) && !(expr instanceof PyReferenceExpression) && !(expr instanceof PySubscriptionExpression) && !(expr instanceof PySliceExpression)) continue;
            targets.add(expr);
        }
        PyExpression[] pyExpressionArray = targets.toArray(PyExpression.EMPTY_ARRAY);
        if (pyExpressionArray == null) {
            PyAssignmentStatementImpl.$$$reportNull$$$0(2);
        }
        return pyExpressionArray;
    }

    @Override
    @Nullable
    public PyAnnotation getAnnotation() {
        return this.findChildByClass(PyAnnotation.class);
    }

    @Override
    @Nullable
    public String getAnnotationValue() {
        return PyAssignmentStatementImpl.getAnnotationContentFromPsi(this);
    }

    private static void addCandidate(List<PyExpression> candidates, PyExpression psi) {
        if (psi instanceof PyParenthesizedExpression) {
            PyAssignmentStatementImpl.addCandidate(candidates, ((PyParenthesizedExpression)psi).getContainedExpression());
        } else if (psi instanceof PySequenceExpression) {
            PyExpression[] pyExpressions;
            for (PyExpression pyExpression : pyExpressions = ((PySequenceExpression)psi).getElements()) {
                PyAssignmentStatementImpl.addCandidate(candidates, pyExpression);
            }
        } else if (psi instanceof PyStarExpression) {
            PyExpression expression = ((PyStarExpression)psi).getExpression();
            if (expression != null) {
                PyAssignmentStatementImpl.addCandidate(candidates, expression);
            }
        } else {
            candidates.add(psi);
        }
    }

    @Override
    @Nullable
    public PyExpression getAssignedValue() {
        PsiElement child;
        for (child = this.getLastChild(); child != null && !(child instanceof PyExpression); child = child.getPrevSibling()) {
            if (!(child instanceof PsiErrorElement)) continue;
            return null;
        }
        return (PyExpression)child;
    }

    @Override
    @NotNull
    public List<Pair<PyExpression, PyExpression>> getTargetsToValuesMapping() {
        Object[] constituents;
        SmartList<Pair<PyExpression, PyExpression>> ret = new SmartList<Pair<PyExpression, PyExpression>>();
        if (!PsiTreeUtil.hasErrorElements(this) && (constituents = (PyExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)this, PyExpression.class)) != null && constituents.length > 1) {
            PyExpression rhs = constituents[constituents.length - 1];
            ArrayList lhses = Lists.newArrayList((Object[])constituents);
            if (lhses.size() > 0) {
                lhses.remove(lhses.size() - 1);
            }
            for (PyExpression lhs : lhses) {
                PyAssignmentStatementImpl.mapToValues(lhs, rhs, ret);
            }
        }
        SmartList<Pair<PyExpression, PyExpression>> smartList = ret;
        if (smartList == null) {
            PyAssignmentStatementImpl.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    @Override
    @Nullable
    public PyExpression getLeftHandSideExpression() {
        PsiElement child;
        for (child = this.getFirstChild(); child != null && !(child instanceof PyExpression); child = child.getPrevSibling()) {
            if (!(child instanceof PsiErrorElement)) continue;
            return null;
        }
        return (PyExpression)child;
    }

    @Override
    public boolean isAssignmentTo(@NotNull String name) {
        PyExpression lhs;
        if (name == null) {
            PyAssignmentStatementImpl.$$$reportNull$$$0(4);
        }
        return (lhs = this.getLeftHandSideExpression()) instanceof PyTargetExpression && name.equals(lhs.getName());
    }

    private static void mapToValues(PyExpression lhs, PyExpression rhs, List<Pair<PyExpression, PyExpression>> map) {
        PySequenceExpression lhs_tuple = null;
        PyExpression lhs_one = null;
        if (lhs instanceof PySequenceExpression) {
            lhs_tuple = (PySequenceExpression)lhs;
        } else if (lhs != null) {
            lhs_one = lhs;
        }
        PySequenceExpression rhs_tuple = null;
        PyExpression rhs_one = null;
        if (rhs instanceof PyParenthesizedExpression) {
            PyExpression exp = ((PyParenthesizedExpression)rhs).getContainedExpression();
            if (exp instanceof PyTupleExpression) {
                rhs_tuple = (PySequenceExpression)exp;
            } else {
                rhs_one = rhs;
            }
        } else if (rhs instanceof PySequenceExpression) {
            rhs_tuple = (PySequenceExpression)rhs;
        } else if (rhs != null) {
            rhs_one = rhs;
        }
        if (lhs_one != null) {
            map.add(Pair.create(lhs_one, rhs));
        } else if (lhs_tuple != null && rhs_one != null) {
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(rhs_one.getProject());
            LanguageLevel languageLevel = LanguageLevel.forElement(lhs);
            int counter = 0;
            for (PyExpression tuple_elt : lhs_tuple.getElements()) {
                try {
                    PyExpression expression = elementGenerator.createExpressionFromText(languageLevel, "(" + rhs_one.getText() + ")[" + counter + "]");
                    map.add(Pair.create(tuple_elt, expression));
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
                ++counter;
            }
        } else if (lhs_tuple != null && rhs_tuple != null) {
            List<PyExpression> lhsTupleElements = Arrays.asList(lhs_tuple.getElements());
            List<PyExpression> rhsTupleElements = Arrays.asList(rhs_tuple.getElements());
            int size = Math.max(lhsTupleElements.size(), rhsTupleElements.size());
            map.addAll(StreamEx.zip(PyAssignmentStatementImpl.alignToSize(lhsTupleElements, size), PyAssignmentStatementImpl.alignToSize(rhsTupleElements, size), Pair::create).toList());
        }
    }

    @NotNull
    private static <T> List<T> alignToSize(@NotNull List<T> list, int size) {
        if (list == null) {
            PyAssignmentStatementImpl.$$$reportNull$$$0(5);
        }
        List list2 = list.size() == size ? list : IntStreamEx.range((int)size).mapToObj(index -> ContainerUtil.getOrElse(list, index, null)).toList();
        if (list2 == null) {
            PyAssignmentStatementImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<PsiNamedElement> getNamedElements() {
        List<PyExpression> expressions = PyUtil.flattenedParensAndStars(this.getTargets());
        ArrayList<PsiNamedElement> result = new ArrayList<PsiNamedElement>();
        for (PyExpression expression : expressions) {
            if (expression instanceof PyQualifiedExpression && ((PyQualifiedExpression)expression).isQualified() || !(expression instanceof PsiNamedElement)) continue;
            result.add((PsiNamedElement)((Object)expression));
        }
        ArrayList<PsiNamedElement> arrayList = result;
        if (arrayList == null) {
            PyAssignmentStatementImpl.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    public PsiNamedElement getNamedElement(@NotNull String the_name) {
        PyExpression[] targets;
        if (the_name == null) {
            PyAssignmentStatementImpl.$$$reportNull$$$0(8);
        }
        if ((targets = this.getTargets()).length == 1 && targets[0] instanceof PyTargetExpression) {
            PyTargetExpression target = (PyTargetExpression)targets[0];
            return !target.isQualified() && the_name.equals(target.getName()) ? target : null;
        }
        return PyUtil.IterHelper.findName(this.getNamedElements(), (String)the_name);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myTargets = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyAssignmentStatementImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "the_name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calcTargets";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetsToValuesMapping";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyAssignmentStatementImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "alignToSize";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedElements";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAssignmentTo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "alignToSize";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNamedElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 8 -> new IllegalArgumentException(string);
        };
    }
}

