/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternBean;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiReferenceProviderBean
implements KeyedLazyInstance<PsiReferenceProviderBean>,
PluginAware {
    public static final ExtensionPointName<PsiReferenceProviderBean> EP_NAME = new ExtensionPointName("com.intellij.psi.referenceProvider");
    @Attribute(value="language")
    public String language = Language.ANY.getID();
    @Attribute(value="providerClass")
    @RequiredElement
    public String className;
    @Tag(value="description")
    public String description;
    @Property(surroundWithTag=false)
    @XCollection
    @RequiredElement
    public ElementPatternBean[] patterns;
    private PluginDescriptor pluginDescriptor;

    public String getDescription() {
        return this.description;
    }

    public PsiReferenceProvider instantiate() {
        try {
            return (PsiReferenceProvider)ApplicationManager.getApplication().instantiateClass(this.className, this.pluginDescriptor);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(PsiReferenceProviderBean.class).error(e);
            return null;
        }
    }

    @Override
    @Transient
    public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            PsiReferenceProviderBean.$$$reportNull$$$0(0);
        }
        this.pluginDescriptor = pluginDescriptor;
    }

    @Nullable
    public ElementPattern<PsiElement> createElementPattern() {
        if (this.patterns.length > 1) {
            List<ElementPattern> result = new ArrayList(this.patterns.length);
            for (ElementPatternBean t : this.patterns) {
                ElementPattern o = t.compilePattern();
                if (o == null) continue;
                result.add(o);
            }
            result = result.isEmpty() ? Collections.emptyList() : result;
            return StandardPatterns.or((ElementPattern[])result.toArray(new ElementPattern[0]));
        }
        if (this.patterns.length == 1) {
            return this.patterns[0].compilePattern();
        }
        Logger.getInstance(PsiReferenceProviderBean.class).error("At least one pattern should be specified");
        return null;
    }

    @Override
    @NotNull
    public String getKey() {
        String string = this.language;
        if (string == null) {
            PsiReferenceProviderBean.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public PsiReferenceProviderBean getInstance() {
        PsiReferenceProviderBean psiReferenceProviderBean = this;
        if (psiReferenceProviderBean == null) {
            PsiReferenceProviderBean.$$$reportNull$$$0(2);
        }
        return psiReferenceProviderBean;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiReferenceProviderBean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiReferenceProviderBean";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setPluginDescriptor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

