/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python.remote;

import java.util.List;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;
import org.openrewrite.python.tree.PyComment;
import org.openrewrite.remote.ReceiverContext;
import org.openrewrite.remote.SenderContext;

public final class Extensions {
    private static final ClassValue<ReceiverContext.DetailsReceiver<JLeftPadded>> leftPaddedValueReceiverCache = new ClassValue<ReceiverContext.DetailsReceiver<JLeftPadded>>(){

        @Override
        protected ReceiverContext.DetailsReceiver<JLeftPadded> computeValue(Class<?> valueType) {
            return (leftPadded, type, ctx) -> {
                if (leftPadded != null) {
                    leftPadded = leftPadded.withBefore((Space)ctx.receiveNonNullNode((Object)leftPadded.getBefore(), Extensions::receiveSpace));
                    leftPadded = leftPadded.withElement(ctx.receiveNonNullValue(leftPadded.getElement(), valueType));
                    leftPadded = leftPadded.withMarkers((Markers)ctx.receiveNonNullNode((Object)leftPadded.getMarkers(), (arg_0, arg_1, arg_2) -> ((ReceiverContext)ctx).receiveMarkers(arg_0, arg_1, arg_2)));
                } else {
                    leftPadded = new JLeftPadded((Space)ctx.receiveNonNullNode(null, Extensions::receiveSpace), ctx.receiveNonNullValue(null, valueType), (Markers)ctx.receiveNonNullNode(null, (arg_0, arg_1, arg_2) -> ((ReceiverContext)ctx).receiveMarkers(arg_0, arg_1, arg_2)));
                }
                return leftPadded;
            };
        }
    };
    private static final ClassValue<ReceiverContext.DetailsReceiver<JLeftPadded>> leftPaddedNodeReceiverCache = new ClassValue<ReceiverContext.DetailsReceiver<JLeftPadded>>(){

        @Override
        protected ReceiverContext.DetailsReceiver<JLeftPadded> computeValue(Class<?> nodeType) {
            if (nodeType == Space.class) {
                return (leftPadded, type, ctx) -> {
                    if (leftPadded != null) {
                        leftPadded = leftPadded.withBefore((Space)ctx.receiveNonNullNode((Object)leftPadded.getBefore(), Extensions::receiveSpace));
                        leftPadded = leftPadded.withElement(ctx.receiveNonNullNode((Object)((Space)leftPadded.getElement()), Extensions::receiveSpace));
                        leftPadded = leftPadded.withMarkers((Markers)ctx.receiveNonNullNode((Object)leftPadded.getMarkers(), (arg_0, arg_1, arg_2) -> ((ReceiverContext)ctx).receiveMarkers(arg_0, arg_1, arg_2)));
                    } else {
                        leftPadded = new JLeftPadded((Space)ctx.receiveNonNullNode(null, Extensions::receiveSpace), (Object)((Space)ctx.receiveNonNullNode(null, Extensions::receiveSpace)), (Markers)ctx.receiveNonNullNode(null, (arg_0, arg_1, arg_2) -> ((ReceiverContext)ctx).receiveMarkers(arg_0, arg_1, arg_2)));
                    }
                    return leftPadded;
                };
            }
            throw new IllegalArgumentException("Unsupported type: " + nodeType);
        }
    };
    private static final ClassValue<ReceiverContext.DetailsReceiver<JRightPadded>> rightPaddedValueReceiverCache = new ClassValue<ReceiverContext.DetailsReceiver<JRightPadded>>(){

        @Override
        protected ReceiverContext.DetailsReceiver<JRightPadded> computeValue(Class<?> valueType) {
            return (rightPadded, type, ctx) -> {
                if (rightPadded != null) {
                    rightPadded = rightPadded.withElement(ctx.receiveNonNullValue(rightPadded.getElement(), valueType));
                    rightPadded = rightPadded.withAfter((Space)ctx.receiveNonNullNode((Object)rightPadded.getAfter(), Extensions::receiveSpace));
                    rightPadded = rightPadded.withMarkers((Markers)ctx.receiveNonNullNode((Object)rightPadded.getMarkers(), (arg_0, arg_1, arg_2) -> ((ReceiverContext)ctx).receiveMarkers(arg_0, arg_1, arg_2)));
                } else {
                    rightPadded = new JRightPadded(ctx.receiveNonNullValue(null, valueType), (Space)ctx.receiveNonNullNode(null, Extensions::receiveSpace), (Markers)ctx.receiveNonNullNode(null, (arg_0, arg_1, arg_2) -> ((ReceiverContext)ctx).receiveMarkers(arg_0, arg_1, arg_2)));
                }
                return rightPadded;
            };
        }
    };
    private static final ClassValue<ReceiverContext.DetailsReceiver<JRightPadded>> rightPaddedNodeReceiverCache = new ClassValue<ReceiverContext.DetailsReceiver<JRightPadded>>(){

        @Override
        protected ReceiverContext.DetailsReceiver<JRightPadded> computeValue(Class<?> nodeType) {
            if (nodeType == Space.class) {
                return (rightPadded, type, ctx) -> {
                    if (rightPadded != null) {
                        rightPadded = rightPadded.withElement(ctx.receiveNonNullNode((Object)((Space)rightPadded.getElement()), Extensions::receiveSpace));
                        rightPadded = rightPadded.withAfter((Space)ctx.receiveNonNullNode((Object)rightPadded.getAfter(), Extensions::receiveSpace));
                        rightPadded = rightPadded.withMarkers((Markers)ctx.receiveNonNullNode((Object)rightPadded.getMarkers(), (arg_0, arg_1, arg_2) -> ((ReceiverContext)ctx).receiveMarkers(arg_0, arg_1, arg_2)));
                    } else {
                        rightPadded = new JRightPadded((Object)((Space)ctx.receiveNonNullNode(null, Extensions::receiveSpace)), (Space)ctx.receiveNonNullNode(null, Extensions::receiveSpace), (Markers)ctx.receiveNonNullNode(null, (arg_0, arg_1, arg_2) -> ((ReceiverContext)ctx).receiveMarkers(arg_0, arg_1, arg_2)));
                    }
                    return rightPadded;
                };
            }
            throw new IllegalArgumentException("Unsupported type: " + nodeType);
        }
    };

    public static Space receiveSpace(@Nullable Space space, Class<?> type, ReceiverContext ctx) {
        if (space != null) {
            space = space.withComments(ctx.receiveNonNullNodes(space.getComments(), Extensions::receiveComment));
            space = space.withWhitespace((String)ctx.receiveNonNullValue((Object)space.getWhitespace(), String.class));
        } else {
            List comments = ctx.receiveNonNullNodes(null, Extensions::receiveComment);
            String whitespace = (String)ctx.receiveValue(null, String.class);
            space = Space.build((String)whitespace, (List)comments);
        }
        return space;
    }

    public static Comment receiveComment(@Nullable Comment comment, @Nullable Class<Comment> type, ReceiverContext ctx) {
        if (comment != null) {
            comment = ((PyComment)comment).withText((String)ctx.receiveNonNullValue((Object)((PyComment)comment).getText(), String.class));
            comment = comment.withSuffix((String)ctx.receiveNonNullValue((Object)comment.getSuffix(), String.class));
            comment = ((PyComment)comment).withAlignedToIndent(((Boolean)ctx.receiveNonNullValue((Object)((PyComment)comment).isAlignedToIndent(), Boolean.TYPE)).booleanValue());
            comment = comment.withMarkers((Markers)ctx.receiveNonNullNode((Object)comment.getMarkers(), (arg_0, arg_1, arg_2) -> ((ReceiverContext)ctx).receiveMarkers(arg_0, arg_1, arg_2)));
        } else {
            comment = new PyComment((String)ctx.receiveNonNullValue(null, String.class), (String)ctx.receiveNonNullValue(null, String.class), ((Boolean)ctx.receiveNonNullValue(null, Boolean.TYPE)).booleanValue(), (Markers)ctx.receiveNonNullNode(null, (arg_0, arg_1, arg_2) -> ((ReceiverContext)ctx).receiveMarkers(arg_0, arg_1, arg_2)));
        }
        return comment;
    }

    public static void sendSpace(Space space, SenderContext ctx) {
        ctx.sendNodes((Object)space, Space::getComments, Extensions::sendComment, Function.identity());
        ctx.sendValue((Object)space, Space::getWhitespace);
    }

    public static void sendComment(Comment comment, SenderContext ctx) {
        if (!(comment instanceof PyComment)) {
            throw new UnsupportedOperationException("Unsupported comment type: " + comment.getClass().getName());
        }
        ctx.sendValue((Object)((PyComment)comment), PyComment::getText);
        ctx.sendValue((Object)comment, Comment::getSuffix);
        ctx.sendValue((Object)((PyComment)comment), PyComment::isAlignedToIndent);
        ctx.sendNode((Object)comment, Comment::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
    }

    public static <T extends J> void sendContainer(JContainer<T> container, SenderContext ctx) {
        ctx.sendNode(container, JContainer::getBefore, Extensions::sendSpace);
        ctx.sendNodes(container, c -> c.getPadding().getElements(), Extensions::sendRightPadded, e -> ((J)e.getElement()).getId());
        ctx.sendNode(container, JContainer::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
    }

    public static <T> void sendLeftPadded(JLeftPadded<T> leftPadded, SenderContext ctx) {
        ctx.sendNode(leftPadded, JLeftPadded::getBefore, Extensions::sendSpace);
        if (leftPadded.getElement() instanceof Tree) {
            ctx.sendNode(leftPadded, e -> (Tree)e.getElement(), (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
        } else if (leftPadded.getElement() instanceof Space) {
            ctx.sendNode(leftPadded, e -> (Space)e.getElement(), Extensions::sendSpace);
        } else {
            ctx.sendValue(leftPadded, JLeftPadded::getElement);
        }
        ctx.sendNode(leftPadded, JLeftPadded::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
    }

    public static <T> void sendRightPadded(JRightPadded<T> rightPadded, SenderContext ctx) {
        if (rightPadded.getElement() instanceof Tree) {
            ctx.sendNode(rightPadded, e -> (Tree)e.getElement(), (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
        } else if (rightPadded.getElement() instanceof Space) {
            ctx.sendNode(rightPadded, e -> (Space)e.getElement(), Extensions::sendSpace);
        } else {
            ctx.sendValue(rightPadded, JRightPadded::getElement);
        }
        ctx.sendNode(rightPadded, JRightPadded::getAfter, Extensions::sendSpace);
        ctx.sendNode(rightPadded, JRightPadded::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
    }

    public static <T extends J> JContainer<T> receiveContainer(@Nullable JContainer<T> container, @Nullable Class<?> type, ReceiverContext ctx) {
        if (container != null) {
            container = container.withBefore((Space)ctx.receiveNonNullNode((Object)container.getBefore(), Extensions::receiveSpace));
            container = container.getPadding().withElements(ctx.receiveNonNullNodes(container.getPadding().getElements(), Extensions::receiveRightPaddedTree));
            container = container.withMarkers((Markers)ctx.receiveNonNullNode((Object)container.getMarkers(), (arg_0, arg_1, arg_2) -> ((ReceiverContext)ctx).receiveMarkers(arg_0, arg_1, arg_2)));
        } else {
            container = JContainer.build((Space)((Space)ctx.receiveNonNullNode(null, Extensions::receiveSpace)), (List)ctx.receiveNonNullNodes(null, Extensions::receiveRightPaddedTree), (Markers)((Markers)ctx.receiveNonNullNode(null, (arg_0, arg_1, arg_2) -> ((ReceiverContext)ctx).receiveMarkers(arg_0, arg_1, arg_2))));
        }
        return container;
    }

    public static <T> ReceiverContext.DetailsReceiver<JLeftPadded<T>> leftPaddedValueReceiver(Class<T> valueType) {
        return leftPaddedValueReceiverCache.get(valueType);
    }

    public static <T> ReceiverContext.DetailsReceiver<JLeftPadded<T>> leftPaddedNodeReceiver(Class<T> nodeType) {
        return leftPaddedNodeReceiverCache.get(nodeType);
    }

    public static <T extends J> JLeftPadded<T> receiveLeftPaddedTree(@Nullable JLeftPadded<T> leftPadded, @Nullable Class<?> type, ReceiverContext ctx) {
        if (leftPadded != null) {
            leftPadded = leftPadded.withBefore((Space)ctx.receiveNonNullNode((Object)leftPadded.getBefore(), Extensions::receiveSpace));
            leftPadded = leftPadded.withElement((Object)((J)ctx.receiveNonNullNode((Object)((J)leftPadded.getElement()), (arg_0, arg_1, arg_2) -> ((ReceiverContext)ctx).receiveTree(arg_0, arg_1, arg_2))));
            leftPadded = leftPadded.withMarkers((Markers)ctx.receiveNonNullNode((Object)leftPadded.getMarkers(), (arg_0, arg_1, arg_2) -> ((ReceiverContext)ctx).receiveMarkers(arg_0, arg_1, arg_2)));
        } else {
            leftPadded = new JLeftPadded((Space)ctx.receiveNonNullNode(null, Extensions::receiveSpace), (Object)((J)ctx.receiveNonNullNode(null, (arg_0, arg_1, arg_2) -> ((ReceiverContext)ctx).receiveTree(arg_0, arg_1, arg_2))), (Markers)ctx.receiveNonNullNode(null, (arg_0, arg_1, arg_2) -> ((ReceiverContext)ctx).receiveMarkers(arg_0, arg_1, arg_2)));
        }
        return leftPadded;
    }

    public static <T> ReceiverContext.DetailsReceiver<JRightPadded<T>> rightPaddedValueReceiver(Class<T> valueType) {
        return rightPaddedValueReceiverCache.get(valueType);
    }

    public static <T> ReceiverContext.DetailsReceiver<JRightPadded<T>> rightPaddedNodeReceiver(Class<T> nodeType) {
        return rightPaddedNodeReceiverCache.get(nodeType);
    }

    public static <T extends J> JRightPadded<T> receiveRightPaddedTree(@Nullable JRightPadded<T> rightPadded, @Nullable Class<?> type, ReceiverContext ctx) {
        if (rightPadded != null) {
            rightPadded = rightPadded.withElement((Object)((J)ctx.receiveNonNullNode((Object)((J)rightPadded.getElement()), (arg_0, arg_1, arg_2) -> ((ReceiverContext)ctx).receiveTree(arg_0, arg_1, arg_2))));
            rightPadded = rightPadded.withAfter((Space)ctx.receiveNonNullNode((Object)rightPadded.getAfter(), Extensions::receiveSpace));
            rightPadded = rightPadded.withMarkers((Markers)ctx.receiveNonNullNode((Object)rightPadded.getMarkers(), (arg_0, arg_1, arg_2) -> ((ReceiverContext)ctx).receiveMarkers(arg_0, arg_1, arg_2)));
        } else {
            rightPadded = new JRightPadded((Object)((J)ctx.receiveNonNullNode(null, (arg_0, arg_1, arg_2) -> ((ReceiverContext)ctx).receiveTree(arg_0, arg_1, arg_2))), (Space)ctx.receiveNonNullNode(null, Extensions::receiveSpace), (Markers)ctx.receiveNonNullNode(null, (arg_0, arg_1, arg_2) -> ((ReceiverContext)ctx).receiveMarkers(arg_0, arg_1, arg_2)));
        }
        return rightPadded;
    }
}

