/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.marketplace;

import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Recipe;
import org.openrewrite.config.Environment;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.RecipeLoader;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeListing;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;

public class ResolvedMavenRecipeBundle
implements RecipeBundle {
    private final ResolvedGroupArtifactVersion gav;
    private final Path recipeJar;
    private final List<Path> classpath;
    private final @Nullable String team;
    private transient @Nullable Environment environment;
    private transient @Nullable RecipeLoader recipeLoader;
    private transient @Nullable ClassLoader classLoader;

    public String getPackageEcosystem() {
        return "maven";
    }

    public String getPackageName() {
        return this.gav.getGroupId() + ":" + this.gav.getArtifactId();
    }

    public String getVersion() {
        return this.gav.getDatedSnapshotVersion() == null ? this.gav.getVersion() : this.gav.getDatedSnapshotVersion();
    }

    public RecipeDescriptor describe(RecipeListing listing) {
        for (RecipeDescriptor descriptor : this.getEnvironment().listRecipeDescriptors()) {
            if (!descriptor.getName().equals(listing.getName())) continue;
            return descriptor.withBundle((RecipeBundle)this);
        }
        throw new IllegalArgumentException("Did not find a matching recipe descriptor in the recipe JAR " + this.gav);
    }

    public Environment getEnvironment() {
        if (this.environment == null) {
            this.environment = Environment.builder().scanJar(this.recipeJar, this.classpath, this.classLoader()).build();
        }
        return this.environment;
    }

    public Recipe prepare(RecipeListing listing, Map<String, Object> options) {
        return this.recipeLoader().load(listing.getName(), options);
    }

    private RecipeLoader recipeLoader() {
        if (this.recipeLoader == null) {
            this.recipeLoader = new RecipeLoader(this.classLoader());
        }
        return this.recipeLoader;
    }

    private ClassLoader classLoader() {
        if (this.classLoader == null) {
            this.classLoader = new URLClassLoader((URL[])Stream.concat(this.classpath.stream(), Stream.of(this.recipeJar)).map(Path::toUri).map(uri -> {
                try {
                    return uri.toURL();
                }
                catch (MalformedURLException e) {
                    throw new UncheckedIOException(e);
                }
            }).toArray(URL[]::new));
        }
        return this.classLoader;
    }

    @Generated
    public ResolvedMavenRecipeBundle(ResolvedGroupArtifactVersion gav, Path recipeJar, List<Path> classpath, @Nullable String team) {
        this.gav = gav;
        this.recipeJar = recipeJar;
        this.classpath = classpath;
        this.team = team;
    }

    @Generated
    public @Nullable String getTeam() {
        return this.team;
    }
}

