/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.marketplace;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.config.CategoryDescriptor;
import org.openrewrite.config.DeclarativeRecipe;
import org.openrewrite.config.Environment;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeListing;
import org.openrewrite.marketplace.RecipeMarketplace;
import org.openrewrite.marketplace.RecipeMarketplaceWriter;
import org.openrewrite.marketplace.YamlRecipeBundle;
import org.openrewrite.maven.marketplace.MavenRecipeBundle;
import org.openrewrite.maven.marketplace.ResolvedMavenRecipeBundle;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;

public class MavenRecipeMarketplaceGenerator {
    private final ResolvedGroupArtifactVersion gav;
    private final Path recipeJar;
    private final List<Path> classpath;

    public RecipeMarketplace generate() {
        try {
            if (Files.notExists(this.recipeJar, new LinkOption[0])) {
                throw new IllegalArgumentException("Recipe JAR does not exist " + this.recipeJar);
            }
            ResolvedMavenRecipeBundle bundle = new ResolvedMavenRecipeBundle(this.gav, this.recipeJar, this.classpath, null);
            Environment env = bundle.getEnvironment();
            RecipeMarketplace root = RecipeMarketplace.newEmpty();
            for (RecipeDescriptor descriptor : env.listRecipeDescriptors()) {
                RecipeDescriptor bundledDescriptor = descriptor.withBundle(this.createBundle(descriptor, env));
                List<String> categories = this.extractCategories(descriptor.getName(), env);
                root.addRecipe((RecipeListing)bundledDescriptor, categories.toArray(new String[0]));
            }
            return root;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate marketplace for " + this.gav, e);
        }
    }

    private RecipeBundle createBundle(RecipeDescriptor descriptor, Environment env) {
        DeclarativeRecipe declarativeRecipe;
        URI source;
        Recipe recipe = env.activateRecipes(new String[]{descriptor.getName()});
        if (recipe instanceof DeclarativeRecipe && (source = this.getDeclarativeSource(declarativeRecipe = (DeclarativeRecipe)recipe)) != null && this.isYamlSource(source)) {
            return new YamlRecipeBundle(URI.create("maven-rewrite-yaml:" + this.gav.getGroupId() + ":" + this.gav.getArtifactId() + ":" + this.gav.getVersion() + "!/" + this.extractPathFromJarUri(source.toString())), new Properties(), null){

                public String getVersion() {
                    return MavenRecipeMarketplaceGenerator.this.gav.getDatedSnapshotVersion() == null ? MavenRecipeMarketplaceGenerator.this.gav.getVersion() : MavenRecipeMarketplaceGenerator.this.gav.getDatedSnapshotVersion();
                }
            };
        }
        return new MavenRecipeBundle(this.gav, (ExecutionContext)new InMemoryExecutionContext(), null, null);
    }

    private @Nullable URI getDeclarativeSource(DeclarativeRecipe recipe) {
        try {
            Field sourceField = DeclarativeRecipe.class.getDeclaredField("source");
            sourceField.setAccessible(true);
            return (URI)sourceField.get(recipe);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isYamlSource(URI source) {
        String path = source.toString();
        return path.contains("META-INF/rewrite") && (path.endsWith(".yml") || path.endsWith(".yaml"));
    }

    private String extractPathFromJarUri(String uriString) {
        int bangIndex = uriString.indexOf("!");
        if (bangIndex != -1) {
            return uriString.substring(bangIndex + 2);
        }
        int metaInfIndex = uriString.indexOf("META-INF/rewrite");
        if (metaInfIndex != -1) {
            return uriString.substring(metaInfIndex);
        }
        return uriString;
    }

    private List<String> extractCategories(String recipeName, Environment env) {
        int lastDot = recipeName.lastIndexOf(46);
        if (lastDot == -1) {
            return Collections.emptyList();
        }
        String packageName = recipeName.substring(0, lastDot);
        String[] parts = packageName.split("\\.");
        ArrayList<String> categories = new ArrayList<String>(parts.length);
        block0: for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            String partialPackage = String.join((CharSequence)".", Arrays.copyOfRange(parts, 0, i + 1));
            for (CategoryDescriptor categoryDescriptor : env.listCategoryDescriptors()) {
                String categoryPackageName = categoryDescriptor.getPackageName();
                if (!categoryPackageName.equals(partialPackage)) continue;
                if (categoryDescriptor.isRoot()) continue block0;
                categories.add(categoryDescriptor.getDisplayName());
                continue block0;
            }
            if (part.isEmpty()) continue;
            String capitalized = Character.toUpperCase(part.charAt(0)) + part.substring(1);
            categories.add(capitalized);
        }
        return categories;
    }

    public static void main(String[] args) throws IOException {
        Path rewriteJavaBuild = null;
        for (File f : Objects.requireNonNull(new File("rewrite-java/build/libs").listFiles())) {
            if (!f.getName().endsWith(".jar") || f.getName().endsWith("-javadoc.jar") || f.getName().endsWith("-sources.jar")) continue;
            rewriteJavaBuild = f.toPath().toAbsolutePath();
            break;
        }
        RecipeMarketplace marketplace = new MavenRecipeMarketplaceGenerator(new ResolvedGroupArtifactVersion(null, "org.openrewrite", "rewrite-java", "8.64.0-SNAPSHOT", null), Objects.requireNonNull(rewriteJavaBuild), Collections.emptyList()).generate();
        String csv = new RecipeMarketplaceWriter().toCsv(marketplace);
        Files.write(Paths.get("recipes.csv", new String[0]), csv.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        System.out.println(csv);
    }

    @Generated
    public MavenRecipeMarketplaceGenerator(ResolvedGroupArtifactVersion gav, Path recipeJar, List<Path> classpath) {
        this.gav = gav;
        this.recipeJar = recipeJar;
        this.classpath = classpath;
    }
}

