/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.marketplace;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.file.Path;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeBundleLoader;
import org.openrewrite.maven.marketplace.MavenRecipeBundle;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.maven.utilities.MavenArtifactDownloader;

public class MavenRecipeBundleLoader
implements RecipeBundleLoader,
URLStreamHandlerFactory {
    private final ExecutionContext ctx;
    private final MavenArtifactDownloader downloader;

    public MavenRecipeBundleLoader(ExecutionContext ctx, MavenArtifactDownloader downloader) {
        this.ctx = ctx;
        this.downloader = downloader;
        URL.setURLStreamHandlerFactory(this);
    }

    public String getEcosystem() {
        return "maven";
    }

    public RecipeBundle createBundle(String packageName, String version, @Nullable String team) {
        ResolvedGroupArtifactVersion gav = MavenRecipeBundleLoader.parseGav(packageName + ":" + version);
        return new MavenRecipeBundle(gav, this.ctx, this.downloader, team);
    }

    @Override
    public @Nullable URLStreamHandler createURLStreamHandler(String protocol) {
        return "maven-rewrite-yaml".equals(protocol) ? new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                String[] gavAndPath = u.getPath().split("!/", 2);
                ResolvedGroupArtifactVersion gav = MavenRecipeBundleLoader.parseGav(gavAndPath[0]);
                MavenRecipeBundle bundle = new MavenRecipeBundle(gav, MavenRecipeBundleLoader.this.ctx, MavenRecipeBundleLoader.this.downloader, null);
                MavenResolutionResult mrr = bundle.resolve();
                ResolvedDependency recipeDependency = mrr.getDependencies().get((Object)Scope.Compile).get(0);
                Path recipeJar = Objects.requireNonNull(MavenRecipeBundleLoader.this.downloader.downloadArtifact(recipeDependency));
                return new URL("jar:file:" + recipeJar.toAbsolutePath() + "!/" + gavAndPath[1]).openConnection();
            }
        } : null;
    }

    private static ResolvedGroupArtifactVersion parseGav(String gav) {
        String snapshotVersion;
        String datedSnapshotVersion;
        String[] parts = gav.split(":");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Maven package name must be in format 'groupId:artifactId:version', but found " + gav);
        }
        String version = parts[2];
        if (version.matches(".*-\\d{8}\\.\\d{6}-\\d+")) {
            datedSnapshotVersion = version;
            int dashIndex = version.indexOf(45);
            snapshotVersion = version.substring(0, dashIndex) + "-SNAPSHOT";
        } else {
            snapshotVersion = version;
            datedSnapshotVersion = null;
        }
        return new ResolvedGroupArtifactVersion(null, parts[0], parts[1], snapshotVersion, datedSnapshotVersion);
    }
}

