/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.marketplace;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeBundleLoader;
import org.openrewrite.marketplace.RecipeListing;
import org.openrewrite.marketplace.RecipeMarketplace;
import org.openrewrite.marketplace.RecipeMarketplacePrinter;
import org.openrewrite.marketplace.RecipeMarketplaceReader;
import org.openrewrite.marketplace.YamlRecipeBundleLoader;
import org.openrewrite.maven.MavenParser;
import org.openrewrite.maven.cache.LocalMavenArtifactCache;
import org.openrewrite.maven.marketplace.MavenRecipeBundleLoader;
import org.openrewrite.maven.marketplace.ResolvedMavenRecipeBundle;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.maven.utilities.MavenArtifactDownloader;

public class MavenRecipeBundle
implements RecipeBundle {
    private static final Map<ResolvedGroupArtifactVersion, Lock> DEPENDENCY_LOCKS = new ConcurrentHashMap<ResolvedGroupArtifactVersion, Lock>();
    private final ResolvedGroupArtifactVersion gav;
    private final ExecutionContext ctx;
    private final @Nullable MavenArtifactDownloader downloader;
    private final @Nullable String team;
    private transient @Nullable ResolvedMavenRecipeBundle resolvedBundle;
    private transient @Nullable List<Path> classpath;

    public String getPackageEcosystem() {
        return "maven";
    }

    public String getPackageName() {
        return this.gav.getGroupId() + ":" + this.gav.getArtifactId();
    }

    public String getVersion() {
        return this.gav.getDatedSnapshotVersion() == null ? this.gav.getVersion() : this.gav.getDatedSnapshotVersion();
    }

    public RecipeDescriptor describe(RecipeListing listing) {
        return this.resolvedBundle().describe(listing);
    }

    public Recipe prepare(RecipeListing listing, Map<String, Object> options) {
        return this.resolvedBundle().prepare(listing, options);
    }

    private ResolvedMavenRecipeBundle resolvedBundle() {
        if (this.resolvedBundle == null) {
            Path recipeJar = this.classpath().stream().filter(a -> a.toAbsolutePath().toString().contains(this.gav.getGroupId().replaceAll("\\.", File.separator)) && a.toAbsolutePath().toString().contains(File.separator + this.gav.getArtifactId() + File.separator)).findFirst().orElseThrow(() -> new IllegalStateException("Failed to install recipe. No download error occurred."));
            this.resolvedBundle = new ResolvedMavenRecipeBundle(this.gav, recipeJar, this.classpath(), this.team);
        }
        return this.resolvedBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Path> classpath() {
        if (this.classpath == null) {
            if (this.downloader == null) {
                throw new IllegalStateException("No downloader configured");
            }
            this.classpath = new ArrayList<Path>();
            for (ResolvedDependency resolvedDependency : this.resolve().getDependencies().get((Object)Scope.Runtime)) {
                Lock lock = DEPENDENCY_LOCKS.computeIfAbsent(resolvedDependency.getGav(), g -> new ReentrantLock());
                lock.lock();
                try {
                    Path path = this.downloader.downloadArtifact(resolvedDependency);
                    if (path == null) {
                        throw new IllegalStateException("Unable to download dependency " + resolvedDependency.getGav());
                    }
                    this.classpath.add(path);
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return this.classpath;
    }

    MavenResolutionResult resolve() {
        return MavenParser.builder().build().parse(this.ctx, "<project>    <groupId>io.moderne</groupId>    <artifactId>recipe-downloader</artifactId>    <version>1</version>    <dependencies>        <dependency>            <groupId>" + this.gav.getGroupId() + "</groupId>            <artifactId>" + this.gav.getArtifactId() + "</artifactId>            <version>" + this.gav.getVersion() + "</version>        </dependency>    </dependencies></project>").findFirst().flatMap(sf -> sf.getMarkers().findFirst(MavenResolutionResult.class)).filter(mrr -> !mrr.getDependencies().isEmpty()).orElseThrow(() -> new IllegalStateException("Unable to download recipe"));
    }

    public static void main(String[] args) {
        RecipeMarketplaceReader reader = new RecipeMarketplaceReader(new RecipeBundleLoader[]{new MavenRecipeBundleLoader((ExecutionContext)new InMemoryExecutionContext(), new MavenArtifactDownloader(new LocalMavenArtifactCache(Paths.get(".rewrite", new String[0])), null, Throwable::printStackTrace)), new YamlRecipeBundleLoader(new Properties())});
        RecipeMarketplace recipeMarketplace = reader.fromCsv(Paths.get("recipes.csv", new String[0]));
        System.out.println(new RecipeMarketplacePrinter(opt -> opt.nameStyle(RecipeMarketplacePrinter.NameStyle.DISPLAY_NAME)).print(recipeMarketplace));
    }

    @Generated
    public MavenRecipeBundle(ResolvedGroupArtifactVersion gav, ExecutionContext ctx, @Nullable MavenArtifactDownloader downloader, @Nullable String team) {
        this.gav = gav;
        this.ctx = ctx;
        this.downloader = downloader;
        this.team = team;
    }

    @Generated
    public @Nullable String getTeam() {
        return this.team;
    }
}

