/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.security;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public class UseHttpsForRepositories
extends Recipe {
    private static final XPathMatcher REPOSITORY_URL_MATCHER = new XPathMatcher("/project/repositories/repository/url");
    private static final XPathMatcher PLUGIN_REPOSITORY_URL_MATCHER = new XPathMatcher("/project/pluginRepositories/pluginRepository/url");
    private static final XPathMatcher DISTRIBUTION_MANAGEMENT_REPOSITORY_URL_MATCHER = new XPathMatcher("/project/distributionManagement/repository/url");
    private static final XPathMatcher DISTRIBUTION_MANAGEMENT_SNAPSHOT_REPOSITORY_URL_MATCHER = new XPathMatcher("/project/distributionManagement/snapshotRepository/url");

    public String getDisplayName() {
        return "Use HTTPS for repositories";
    }

    public String getDescription() {
        return "Use HTTPS for repository urls.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("security", "CWE-829"));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.isRepositoryUrlTag()) {
                    if (UseHttpsForRepositories.isInsecureTag(tag)) {
                        String newValue = UseHttpsForRepositories.replaceInsecure((String)tag.getValue().get());
                        this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor(tag, newValue));
                    } else if (tag.getValue().map(v -> v.startsWith("$")).orElse(false).booleanValue()) {
                        String repositoryUrlProperty = (String)tag.getValue().get();
                        this.doAfterVisit((TreeVisitor)new UpdateMavenPropertyToHttpsVisitor(repositoryUrlProperty.substring(2, repositoryUrlProperty.length() - 1)));
                    }
                }
                return super.visitTag(tag, ctx);
            }

            private boolean isRepositoryUrlTag() {
                return REPOSITORY_URL_MATCHER.matches(this.getCursor()) || PLUGIN_REPOSITORY_URL_MATCHER.matches(this.getCursor()) || DISTRIBUTION_MANAGEMENT_REPOSITORY_URL_MATCHER.matches(this.getCursor()) || DISTRIBUTION_MANAGEMENT_SNAPSHOT_REPOSITORY_URL_MATCHER.matches(this.getCursor());
            }
        };
    }

    private static boolean isInsecureTag(Xml.Tag tag) {
        return tag.getValue().map(UseHttpsForRepositories::isInsecure).orElse(false);
    }

    private static boolean isInsecure(String value) {
        return value.startsWith("http://") || value.startsWith("ftp://");
    }

    private static String replaceInsecure(String value) {
        return value.replaceAll("^http://(.*)", "https://$1").replaceAll("^ftp://(.*)", "ftps://$1");
    }

    static class UpdateMavenPropertyToHttpsVisitor
    extends MavenIsoVisitor<ExecutionContext> {
        final String propertyName;

        @Override
        public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (this.isPropertyTag() && this.propertyName.equals(tag.getName()) && UseHttpsForRepositories.isInsecureTag(tag)) {
                String newValue = UseHttpsForRepositories.replaceInsecure((String)tag.getValue().get());
                this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor(tag, newValue));
            }
            return super.visitTag(tag, ctx);
        }

        public UpdateMavenPropertyToHttpsVisitor(String propertyName) {
            this.propertyName = propertyName;
        }
    }
}

