/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.MapTagChildrenVisitor;
import org.openrewrite.xml.SemanticallyEqual;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class AddPluginDependency
extends Recipe {
    private static final XPathMatcher PLUGINS_MATCHER = new XPathMatcher("/project/build/plugins");
    @Option(displayName="Plugin group", description="Group ID of the plugin to which the dependency will be added. A group ID is the first part of a dependency coordinate `org.openrewrite.maven:rewrite-maven-plugin:VERSION`.", example="org.openrewrite.maven")
    private final String pluginGroupId;
    @Option(displayName="Plugin artifact", description="Artifact ID of the plugin to which the dependency will be added.The second part of a dependency coordinate `org.openrewrite.maven:rewrite-maven-plugin:VERSION`.", example="rewrite-maven-plugin")
    private final String pluginArtifactId;
    @Option(displayName="Group", description="The group ID of the dependency to add.", example="org.openrewrite.recipe")
    private final String groupId;
    @Option(displayName="Artifact", description="The artifact ID of the dependency to add.", example="org.openrewrite.recipe")
    private final String artifactId;
    @Option(displayName="Version", description="The version of the dependency to add.", example="org.openrewrite.recipe")
    private final @Nullable String version;

    public String getDisplayName() {
        return "Add Maven plugin dependencies";
    }

    public String getDescription() {
        return "Adds the specified dependencies to a Maven plugin. Will not add the plugin if it does not already exist in the pom.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag dependencies;
                Xml.Tag plugins = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (!PLUGINS_MATCHER.matches(this.getCursor())) {
                    return plugins;
                }
                Optional<Xml.Tag> maybePlugin = plugins.getChildren().stream().filter(plugin -> "plugin".equals(plugin.getName()) && AddPluginDependency.this.pluginGroupId.equals(plugin.getChildValue("groupId").orElse(null)) && AddPluginDependency.this.pluginArtifactId.equals(plugin.getChildValue("artifactId").orElse(null))).findAny();
                if (!maybePlugin.isPresent()) {
                    return plugins;
                }
                Xml.Tag plugin2 = maybePlugin.get();
                Optional maybeDependencies = plugin2.getChild("dependencies");
                boolean formatAllDependencies = false;
                if (maybeDependencies.isPresent()) {
                    dependencies = (Xml.Tag)maybeDependencies.get();
                } else {
                    formatAllDependencies = true;
                    dependencies = Xml.Tag.build((String)"<dependencies />").withPrefix("\n");
                    plugins = AddToTagVisitor.addToTag((Xml.Tag)plugins, (Xml.Tag)plugin2, (Xml.Tag)dependencies, (Cursor)this.getCursor().getParentOrThrow());
                }
                Xml.Tag newDependencyTag = Xml.Tag.build((String)("<dependency>\n<groupId>" + AddPluginDependency.this.groupId + "</groupId>\n<artifactId>" + AddPluginDependency.this.artifactId + "</artifactId>" + (AddPluginDependency.this.version == null ? "\n" : "\n<version>" + AddPluginDependency.this.version + "</version>\n") + "</dependency>")).withPrefix("\n");
                Optional<Xml.Tag> maybeExistingDependency = dependencies.getChildren().stream().filter(it -> AddPluginDependency.this.groupId.equals(it.getChildValue("groupId").orElse(null)) && AddPluginDependency.this.artifactId.equals(it.getChildValue("artifactId").orElse(null))).findAny();
                if (maybeExistingDependency.isPresent() && SemanticallyEqual.areEqual((Xml)newDependencyTag, (Xml)((Xml)maybeExistingDependency.get()))) {
                    return plugins;
                }
                plugins = maybeExistingDependency.isPresent() ? MapTagChildrenVisitor.mapTagChildren((Xml.Tag)plugins, (Xml.Tag)dependencies, it -> {
                    if (it == maybeExistingDependency.get()) {
                        return newDependencyTag;
                    }
                    return it;
                }) : AddToTagVisitor.addToTag((Xml.Tag)plugins, (Xml.Tag)dependencies, (Xml.Tag)newDependencyTag, (Cursor)this.getCursor().getParentOrThrow());
                plugins = formatAllDependencies ? (Xml.Tag)this.autoFormat((Xml)plugins, (Xml)dependencies, ctx, this.getCursor().getParentOrThrow()) : (Xml.Tag)this.autoFormat((Xml)plugins, (Xml)newDependencyTag, ctx, this.getCursor().getParentOrThrow());
                return plugins;
            }
        };
    }

    @Generated
    public AddPluginDependency(String pluginGroupId, String pluginArtifactId, String groupId, String artifactId, @Nullable String version) {
        this.pluginGroupId = pluginGroupId;
        this.pluginArtifactId = pluginArtifactId;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    @Generated
    public String getPluginGroupId() {
        return this.pluginGroupId;
    }

    @Generated
    public String getPluginArtifactId() {
        return this.pluginArtifactId;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddPluginDependency(pluginGroupId=" + this.getPluginGroupId() + ", pluginArtifactId=" + this.getPluginArtifactId() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddPluginDependency)) {
            return false;
        }
        AddPluginDependency other = (AddPluginDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$pluginGroupId = this.getPluginGroupId();
        String other$pluginGroupId = other.getPluginGroupId();
        if (this$pluginGroupId == null ? other$pluginGroupId != null : !this$pluginGroupId.equals(other$pluginGroupId)) {
            return false;
        }
        String this$pluginArtifactId = this.getPluginArtifactId();
        String other$pluginArtifactId = other.getPluginArtifactId();
        if (this$pluginArtifactId == null ? other$pluginArtifactId != null : !this$pluginArtifactId.equals(other$pluginArtifactId)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddPluginDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pluginGroupId = this.getPluginGroupId();
        result = result * 59 + ($pluginGroupId == null ? 43 : $pluginGroupId.hashCode());
        String $pluginArtifactId = this.getPluginArtifactId();
        result = result * 59 + ($pluginArtifactId == null ? 43 : $pluginArtifactId.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

