/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Optional;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ChangePluginGroupIdAndArtifactId
extends Recipe {
    private final MavenMetadataFailures metadataFailures = new MavenMetadataFailures(this);
    @Option(displayName="Old group ID", description="The old group ID to replace. The group ID is the first part of a plugin coordinate 'com.google.guava:guava:VERSION'. Supports glob expressions.", example="org.openrewrite.recipe")
    private final String oldGroupId;
    @Option(displayName="Old artifact ID", description="The old artifactId to replace. The artifact ID is the second part of a plugin coordinate 'com.google.guava:guava:VERSION'. Supports glob expressions.", example="my-deprecated-maven-plugin")
    private final String oldArtifactId;
    @Option(displayName="New group ID", description="The new group ID to use. Defaults to the existing group ID.", example="corp.internal.openrewrite.recipe", required=false)
    @Nullable
    private final String newGroupId;
    @Option(displayName="New artifact ID", description="The new artifact ID to use. Defaults to the existing artifact ID.", example="my-new-maven-plugin", required=false)
    @Nullable
    private final String newArtifact;

    public String getDisplayName() {
        return "Change Maven plugin group and artifact ID";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.newGroupId, this.newArtifact);
    }

    public String getDescription() {
        return "Change the groupId and/or the artifactId of a specified Maven plugin.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (this.isPluginTag(ChangePluginGroupIdAndArtifactId.this.oldGroupId, ChangePluginGroupIdAndArtifactId.this.oldArtifactId)) {
                    if (ChangePluginGroupIdAndArtifactId.this.newGroupId != null) {
                        t = this.changeChildTagValue(t, "groupId", ChangePluginGroupIdAndArtifactId.this.newGroupId, ctx);
                    }
                    if (ChangePluginGroupIdAndArtifactId.this.newArtifact != null) {
                        t = this.changeChildTagValue(t, "artifactId", ChangePluginGroupIdAndArtifactId.this.newArtifact, ctx);
                    }
                    if (t != tag) {
                        this.maybeUpdateModel();
                    }
                }
                return t;
            }

            private Xml.Tag changeChildTagValue(Xml.Tag tag, String childTagName, String newValue, ExecutionContext ctx) {
                Optional childTag = tag.getChild(childTagName);
                if (childTag.isPresent() && !newValue.equals(((Xml.Tag)childTag.get()).getValue().orElse(null))) {
                    tag = (Xml.Tag)new ChangeTagValueVisitor((Xml.Tag)childTag.get(), newValue).visitNonNull((Tree)tag, (Object)ctx);
                }
                return tag;
            }
        };
    }

    @Generated
    public ChangePluginGroupIdAndArtifactId(String oldGroupId, String oldArtifactId, @Nullable String newGroupId, @Nullable String newArtifact) {
        this.oldGroupId = oldGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newGroupId = newGroupId;
        this.newArtifact = newArtifact;
    }

    @Generated
    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Generated
    public String getOldGroupId() {
        return this.oldGroupId;
    }

    @Generated
    public String getOldArtifactId() {
        return this.oldArtifactId;
    }

    @Nullable
    @Generated
    public String getNewGroupId() {
        return this.newGroupId;
    }

    @Nullable
    @Generated
    public String getNewArtifact() {
        return this.newArtifact;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangePluginGroupIdAndArtifactId(metadataFailures=" + (Object)((Object)this.getMetadataFailures()) + ", oldGroupId=" + this.getOldGroupId() + ", oldArtifactId=" + this.getOldArtifactId() + ", newGroupId=" + this.getNewGroupId() + ", newArtifact=" + this.getNewArtifact() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePluginGroupIdAndArtifactId)) {
            return false;
        }
        ChangePluginGroupIdAndArtifactId other = (ChangePluginGroupIdAndArtifactId)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldGroupId = this.getOldGroupId();
        String other$oldGroupId = other.getOldGroupId();
        if (this$oldGroupId == null ? other$oldGroupId != null : !this$oldGroupId.equals(other$oldGroupId)) {
            return false;
        }
        String this$oldArtifactId = this.getOldArtifactId();
        String other$oldArtifactId = other.getOldArtifactId();
        if (this$oldArtifactId == null ? other$oldArtifactId != null : !this$oldArtifactId.equals(other$oldArtifactId)) {
            return false;
        }
        String this$newGroupId = this.getNewGroupId();
        String other$newGroupId = other.getNewGroupId();
        if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
            return false;
        }
        String this$newArtifact = this.getNewArtifact();
        String other$newArtifact = other.getNewArtifact();
        return !(this$newArtifact == null ? other$newArtifact != null : !this$newArtifact.equals(other$newArtifact));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangePluginGroupIdAndArtifactId;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldGroupId = this.getOldGroupId();
        result = result * 59 + ($oldGroupId == null ? 43 : $oldGroupId.hashCode());
        String $oldArtifactId = this.getOldArtifactId();
        result = result * 59 + ($oldArtifactId == null ? 43 : $oldArtifactId.hashCode());
        String $newGroupId = this.getNewGroupId();
        result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
        String $newArtifact = this.getNewArtifact();
        result = result * 59 + ($newArtifact == null ? 43 : $newArtifact.hashCode());
        return result;
    }
}

