/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Optional;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class AddProfile
extends Recipe {
    private static final XPathMatcher PROJECT_MATCHER = new XPathMatcher("/project");
    @Option(displayName="id", description="The profile id.", example="default")
    private final String id;
    @Option(displayName="Activation", description="activation details of a maven profile, provided as raw XML.", example="<activation><foo>foo</foo></activation>", required=false)
    @Nullable
    private final String activation;
    @Option(displayName="Properties", description="properties of a maven profile, provided as raw XML.", example="<properties><foo>foo</foo><bar>bar</bar></properties>", required=false)
    @Nullable
    private final String properties;
    @Option(displayName="build", description="build details of a maven profile, provided as raw XML.", example="<build><foo>foo</foo></build>", required=false)
    @Nullable
    private final String build;

    public String getDisplayName() {
        return "Add Maven profile";
    }

    public String getDescription() {
        return "Add a maven profile to a `pom.xml` file.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AddProfileVisitor();
    }

    @Generated
    public AddProfile(String id, @Nullable String activation, @Nullable String properties, @Nullable String build) {
        this.id = id;
        this.activation = activation;
        this.properties = properties;
        this.build = build;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Nullable
    @Generated
    public String getActivation() {
        return this.activation;
    }

    @Nullable
    @Generated
    public String getProperties() {
        return this.properties;
    }

    @Nullable
    @Generated
    public String getBuild() {
        return this.build;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddProfile(id=" + this.getId() + ", activation=" + this.getActivation() + ", properties=" + this.getProperties() + ", build=" + this.getBuild() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddProfile)) {
            return false;
        }
        AddProfile other = (AddProfile)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$activation = this.getActivation();
        String other$activation = other.getActivation();
        if (this$activation == null ? other$activation != null : !this$activation.equals(other$activation)) {
            return false;
        }
        String this$properties = this.getProperties();
        String other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
            return false;
        }
        String this$build = this.getBuild();
        String other$build = other.getBuild();
        return !(this$build == null ? other$build != null : !this$build.equals(other$build));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddProfile;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $activation = this.getActivation();
        result = result * 59 + ($activation == null ? 43 : $activation.hashCode());
        String $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        String $build = this.getBuild();
        result = result * 59 + ($build == null ? 43 : $build.hashCode());
        return result;
    }

    private class AddProfileVisitor
    extends MavenIsoVisitor<ExecutionContext> {
        private AddProfileVisitor() {
        }

        @Override
        public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            Xml.Tag t = super.visitTag(tag, ctx);
            if (PROJECT_MATCHER.matches(this.getCursor())) {
                Xml.Tag profiles;
                Optional maybeProfiles = t.getChild("profiles");
                if (maybeProfiles.isPresent()) {
                    profiles = (Xml.Tag)maybeProfiles.get();
                } else {
                    t = (Xml.Tag)new AddToTagVisitor(t, Xml.Tag.build((String)"<profiles/>")).visitNonNull((Tree)t, (Object)ctx, this.getCursor().getParentOrThrow());
                    profiles = (Xml.Tag)t.getChild("profiles").get();
                }
                Optional<Xml.Tag> maybeProfile = profiles.getChildren().stream().filter(profile -> ((String)profile.getChildValue("id").get()).equals(AddProfile.this.id)).findAny();
                if (maybeProfile.isPresent()) {
                    Xml.Tag profile2 = maybeProfile.get();
                    t = (Xml.Tag)new RemoveContentVisitor((Content)profile2, false).visitNonNull((Tree)t, (Object)ctx, this.getCursor().getParentOrThrow());
                }
                Xml.Tag profileTag = Xml.Tag.build((String)("<profile>\n<id>" + AddProfile.this.id + "</id>\n" + (AddProfile.this.activation != null ? AddProfile.this.activation.trim() + "\n" : "") + (AddProfile.this.properties != null ? AddProfile.this.properties.trim() + "\n" : "") + (AddProfile.this.build != null ? AddProfile.this.build.trim() + "\n" : "") + "</profile>"));
                t = (Xml.Tag)new AddToTagVisitor(profiles, profileTag).visitNonNull((Tree)t, (Object)ctx, this.getCursor().getParentOrThrow());
            }
            return t;
        }
    }
}

