/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.internal.InsertDependencyComparator;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public class AddManagedDependencyVisitor
extends MavenIsoVisitor<ExecutionContext> {
    private static final XPathMatcher MANAGED_DEPENDENCIES_MATCHER = new XPathMatcher("/project/dependencyManagement/dependencies");
    private final String groupId;
    private final String artifactId;
    private final String version;
    @Nullable
    private final String scope;
    @Nullable
    private final String type;
    @Nullable
    private final String classifier;

    @Override
    public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
        Xml.Document doc = super.visitDocument(document, ctx);
        if (this.documentHasManagedDependency(doc, ctx)) {
            return document;
        }
        Xml.Tag root = document.getRoot();
        List rootContent = root.getContent() != null ? root.getContent() : Collections.emptyList();
        Xml.Tag dependencyManagementTag = root.getChild("dependencyManagement").orElse(null);
        if (dependencyManagementTag == null) {
            doc = (Xml.Document)new AddToTagVisitor(root, Xml.Tag.build((String)"<dependencyManagement>\n<dependencies/>\n</dependencyManagement>"), (Comparator)new MavenTagInsertionComparator(rootContent)).visitNonNull((Tree)doc, (Object)ctx);
        } else if (!dependencyManagementTag.getChild("dependencies").isPresent()) {
            doc = (Xml.Document)new AddToTagVisitor(dependencyManagementTag, Xml.Tag.build((String)"\n<dependencies/>\n"), (Comparator)new MavenTagInsertionComparator(rootContent)).visitNonNull((Tree)doc, (Object)ctx);
        }
        doc = (Xml.Document)new InsertDependencyInOrder(this.groupId, this.artifactId, this.version, this.type, this.scope, this.classifier).visitNonNull((Tree)doc, ctx);
        return doc;
    }

    private boolean documentHasManagedDependency(Xml.Document doc, ExecutionContext ctx) {
        final AtomicBoolean managedDepExists = new AtomicBoolean(false);
        new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext executionContext) {
                Xml.Tag tg = super.visitTag(tag, executionContext);
                if (this.isManagedDependencyTag(AddManagedDependencyVisitor.this.groupId, AddManagedDependencyVisitor.this.artifactId)) {
                    managedDepExists.set(true);
                }
                return tg;
            }
        }.visitNonNull((Tree)doc, ctx);
        return managedDepExists.get();
    }

    @Generated
    public AddManagedDependencyVisitor(String groupId, String artifactId, String version, @Nullable String scope, @Nullable String type, @Nullable String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.scope = scope;
        this.type = type;
        this.classifier = classifier;
    }

    private static class InsertDependencyInOrder
    extends MavenIsoVisitor<ExecutionContext> {
        private final String groupId;
        private final String artifactId;
        private final String version;
        @Nullable
        private final String type;
        @Nullable
        private final String scope;
        @Nullable
        private final String classifier;

        @Override
        public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (MANAGED_DEPENDENCIES_MATCHER.matches(this.getCursor())) {
                for (Xml.Tag dependency : tag.getChildren()) {
                    if (!dependency.getName().equals("dependency") || !this.groupId.equals(dependency.getChildValue("groupId").orElse(null)) || !this.artifactId.equals(dependency.getChildValue("artifactId").orElse(null))) continue;
                    return tag;
                }
                Xml.Tag dependencyTag = Xml.Tag.build((String)("\n<dependency>\n<groupId>" + this.groupId + "</groupId>\n<artifactId>" + this.artifactId + "</artifactId>\n<version>" + this.version + "</version>\n" + (this.classifier == null ? "" : "<classifier>" + this.classifier + "</classifier>\n") + (this.type == null || this.type.equals("jar") ? "" : "<type>" + this.type + "</type>\n") + (this.scope == null || "compile".equals(this.scope) ? "" : "<scope>" + this.scope + "</scope>\n") + "</dependency>"));
                this.doAfterVisit((TreeVisitor)new AddToTagVisitor(tag, dependencyTag, (Comparator)new InsertDependencyComparator(tag.getContent() == null ? Collections.emptyList() : tag.getContent(), dependencyTag)));
            }
            return super.visitTag(tag, ctx);
        }

        @Generated
        public InsertDependencyInOrder(String groupId, String artifactId, String version, @Nullable String type, @Nullable String scope, @Nullable String classifier) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.type = type;
            this.scope = scope;
            this.classifier = classifier;
        }
    }
}

