/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.List;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.internal.MavenXmlMapper;
import org.openrewrite.maven.tree.Dependency;

public final class Plugin {
    private final String groupId;
    private final String artifactId;
    @Nullable
    private final String version;
    @Nullable
    private final String extensions;
    @Nullable
    private final String inherited;
    @Nullable
    private final JsonNode configuration;
    private final List<Dependency> dependencies;
    private final List<Execution> executions;

    @Nullable
    public String getConfigurationStringValue(String path) {
        if (this.configuration == null) {
            return null;
        }
        JsonNode current = this.configuration;
        if (!path.isEmpty()) {
            String[] elements;
            for (String element : elements = path.split("\\.")) {
                current = current.findPath(element);
            }
        }
        if (current.isMissingNode() || !current.isValueNode()) {
            return null;
        }
        return (String)MavenXmlMapper.readMapper().convertValue((Object)current, String.class);
    }

    @Nullable
    public <T> T getConfiguration(String path, Class<T> configClass) {
        if (this.configuration == null) {
            return null;
        }
        JsonNode current = this.configuration;
        if (!path.isEmpty()) {
            String[] elements;
            for (String element : elements = path.split("\\.")) {
                current = current.findPath(element);
            }
        }
        if (current.isMissingNode()) {
            return null;
        }
        try {
            return (T)MavenXmlMapper.readMapper().readValue(MavenXmlMapper.writeMapper().writeValueAsString((Object)current), configClass);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Error while converting the configuration class [" + configClass.getCanonicalName() + "]. " + e.getMessage());
        }
    }

    public <T> List<T> getConfigurationList(String path, Class<T> elementClass) {
        if (this.configuration == null) {
            return Collections.emptyList();
        }
        JsonNode current = this.configuration;
        if (!path.isEmpty()) {
            String[] elements;
            for (String element : elements = path.split("\\.")) {
                current = current.findPath(element);
            }
        }
        if (current.isMissingNode()) {
            return Collections.emptyList();
        }
        if (current.isObject() && current.size() == 1) {
            current = (JsonNode)current.iterator().next();
        }
        if (current.isValueNode()) {
            return Collections.singletonList(MavenXmlMapper.readMapper().convertValue((Object)current, new TypeReference<T>(){}));
        }
        if (!current.isArray()) {
            return Collections.emptyList();
        }
        return (List)MavenXmlMapper.readMapper().convertValue((Object)current, new TypeReference<List<T>>(){});
    }

    public Plugin(String groupId, String artifactId, @Nullable String version, @Nullable String extensions, @Nullable String inherited, @Nullable JsonNode configuration, List<Dependency> dependencies, List<Execution> executions) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.extensions = extensions;
        this.inherited = inherited;
        this.configuration = configuration;
        this.dependencies = dependencies;
        this.executions = executions;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getExtensions() {
        return this.extensions;
    }

    @Nullable
    public String getInherited() {
        return this.inherited;
    }

    @Nullable
    public JsonNode getConfiguration() {
        return this.configuration;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public List<Execution> getExecutions() {
        return this.executions;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Plugin)) {
            return false;
        }
        Plugin other = (Plugin)o;
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$extensions = this.getExtensions();
        String other$extensions = other.getExtensions();
        if (this$extensions == null ? other$extensions != null : !this$extensions.equals(other$extensions)) {
            return false;
        }
        String this$inherited = this.getInherited();
        String other$inherited = other.getInherited();
        if (this$inherited == null ? other$inherited != null : !this$inherited.equals(other$inherited)) {
            return false;
        }
        JsonNode this$configuration = this.getConfiguration();
        JsonNode other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        List<Dependency> this$dependencies = this.getDependencies();
        List<Dependency> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        List<Execution> this$executions = this.getExecutions();
        List<Execution> other$executions = other.getExecutions();
        return !(this$executions == null ? other$executions != null : !((Object)this$executions).equals(other$executions));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : $extensions.hashCode());
        String $inherited = this.getInherited();
        result = result * 59 + ($inherited == null ? 43 : $inherited.hashCode());
        JsonNode $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        List<Dependency> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        List<Execution> $executions = this.getExecutions();
        result = result * 59 + ($executions == null ? 43 : ((Object)$executions).hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "Plugin(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", extensions=" + this.getExtensions() + ", inherited=" + this.getInherited() + ", configuration=" + this.getConfiguration() + ", dependencies=" + this.getDependencies() + ", executions=" + this.getExecutions() + ")";
    }

    public static final class Execution {
        private final String id;
        private final List<String> goals;
        private final String phase;
        @Nullable
        private final String inherited;
        @Nullable
        private final JsonNode configuration;

        public Execution(String id, List<String> goals, String phase, @Nullable String inherited, @Nullable JsonNode configuration) {
            this.id = id;
            this.goals = goals;
            this.phase = phase;
            this.inherited = inherited;
            this.configuration = configuration;
        }

        public String getId() {
            return this.id;
        }

        public List<String> getGoals() {
            return this.goals;
        }

        public String getPhase() {
            return this.phase;
        }

        @Nullable
        public String getInherited() {
            return this.inherited;
        }

        @Nullable
        public JsonNode getConfiguration() {
            return this.configuration;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Execution)) {
                return false;
            }
            Execution other = (Execution)o;
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            List<String> this$goals = this.getGoals();
            List<String> other$goals = other.getGoals();
            if (this$goals == null ? other$goals != null : !((Object)this$goals).equals(other$goals)) {
                return false;
            }
            String this$phase = this.getPhase();
            String other$phase = other.getPhase();
            if (this$phase == null ? other$phase != null : !this$phase.equals(other$phase)) {
                return false;
            }
            String this$inherited = this.getInherited();
            String other$inherited = other.getInherited();
            if (this$inherited == null ? other$inherited != null : !this$inherited.equals(other$inherited)) {
                return false;
            }
            JsonNode this$configuration = this.getConfiguration();
            JsonNode other$configuration = other.getConfiguration();
            return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            List<String> $goals = this.getGoals();
            result = result * 59 + ($goals == null ? 43 : ((Object)$goals).hashCode());
            String $phase = this.getPhase();
            result = result * 59 + ($phase == null ? 43 : $phase.hashCode());
            String $inherited = this.getInherited();
            result = result * 59 + ($inherited == null ? 43 : $inherited.hashCode());
            JsonNode $configuration = this.getConfiguration();
            result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "Plugin.Execution(id=" + this.getId() + ", goals=" + this.getGoals() + ", phase=" + this.getPhase() + ", inherited=" + this.getInherited() + ", configuration=" + this.getConfiguration() + ")";
        }
    }
}

