/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.RemoveRedundantDependencyVersions;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.Parent;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.maven.utilities.RetainVersions;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ChangeParentPom
extends Recipe {
    private final MavenMetadataFailures metadataFailures = new MavenMetadataFailures(this);
    @Option(displayName="Old GroupId", description="The groupId of the maven parent pom to be changed away from.", example="org.springframework.boot")
    private final String oldGroupId;
    @Option(displayName="New GroupId", description="The groupId of the new maven parent pom to be adopted. If this argument is omitted it defaults to the value of `oldGroupId`.", example="org.springframework.boot", required=false)
    @Nullable
    private final String newGroupId;
    @Option(displayName="Old ArtifactId", description="The artifactId of the maven parent pom to be changed away from.", example="spring-boot-starter-parent")
    private final String oldArtifactId;
    @Option(displayName="New ArtifactId", description="The artifactId of the new maven parent pom to be adopted. If this argument is omitted it defaults to the value of `oldArtifactId`.", example="spring-boot-starter-parent", required=false)
    @Nullable
    private final String newArtifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number.", example="29.X")
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;
    @Option(displayName="Allow version downgrades", description="If the new parent has the same group/artifact, this flag can be used to only upgrade the version if the target version is newer than the current.", required=false)
    @Nullable
    private final Boolean allowVersionDowngrades;
    @Option(displayName="Retain versions", description="Accepts a list of GAVs. For each GAV, if it is a project direct dependency, and it is removed from dependency management in the new parent pom, then it will be retained with an explicit version. The version can be omitted from the GAV to use the old value from dependency management", example="com.jcraft:jsch", required=false)
    @Nullable
    private final List<String> retainVersions;

    public String getDisplayName() {
        return "Change Maven Parent Pom";
    }

    public String getDescription() {
        return "Change the parent pom of a Maven pom.xml. Identifies the parent pom to be changed by its groupId and artifactId.";
    }

    public Validated validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        if (this.retainVersions != null) {
            for (int i = 0; i < this.retainVersions.size(); ++i) {
                String retainVersion = this.retainVersions.get(i);
                validated = validated.and(Validated.test((String)String.format("retainVersions[%d]", i), (String)"did not look like a two-or-three-part GAV", (Object)retainVersion, maybeGav -> {
                    int gavParts = maybeGav.split(":").length;
                    return gavParts == 2 || gavParts == 3;
                }));
            }
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final VersionComparator versionComparator = (VersionComparator)Semver.validate((String)this.newVersion, (String)this.versionPattern).getValue();
        assert (versionComparator != null);
        return Preconditions.check((TreeVisitor)new MavenVisitor<ExecutionContext>(){

            public Xml visitDocument(Xml.Document document, ExecutionContext executionContext) {
                Parent parent = this.getResolutionResult().getPom().getRequested().getParent();
                if (parent != null && StringUtils.matchesGlob((String)parent.getArtifactId(), (String)ChangeParentPom.this.oldArtifactId) && StringUtils.matchesGlob((String)parent.getGroupId(), (String)ChangeParentPom.this.oldGroupId)) {
                    return (Xml)SearchResult.found((Tree)document);
                }
                return document;
            }
        }, (TreeVisitor)new MavenIsoVisitor<ExecutionContext>(){
            @Nullable
            private Collection<String> availableVersions;

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                ResolvedPom resolvedPom;
                Xml.Tag t = super.visitTag(tag, ctx);
                if (this.isParentTag() && StringUtils.matchesGlob((String)(resolvedPom = this.getResolutionResult().getPom()).getValue(tag.getChildValue("groupId").orElse(null)), (String)ChangeParentPom.this.oldGroupId) && StringUtils.matchesGlob((String)resolvedPom.getValue(tag.getChildValue("artifactId").orElse(null)), (String)ChangeParentPom.this.oldArtifactId)) {
                    String oldVersion = resolvedPom.getValue(tag.getChildValue("version").orElse(null));
                    assert (oldVersion != null);
                    String targetGroupId = ChangeParentPom.this.newGroupId == null ? tag.getChildValue("groupId").orElse(ChangeParentPom.this.oldGroupId) : ChangeParentPom.this.newGroupId;
                    String targetArtifactId = ChangeParentPom.this.newArtifactId == null ? tag.getChildValue("artifactId").orElse(ChangeParentPom.this.oldArtifactId) : ChangeParentPom.this.newArtifactId;
                    try {
                        Optional<String> targetVersion = this.findNewerDependencyVersion(targetGroupId, targetArtifactId, oldVersion, ctx);
                        if (targetVersion.isPresent()) {
                            ArrayList<ChangeTagValueVisitor> changeParentTagVisitors = new ArrayList<ChangeTagValueVisitor>();
                            if (!ChangeParentPom.this.oldGroupId.equals(targetGroupId)) {
                                changeParentTagVisitors.add(new ChangeTagValueVisitor((Xml.Tag)t.getChild("groupId").get(), targetGroupId));
                            }
                            if (!ChangeParentPom.this.oldArtifactId.equals(targetArtifactId)) {
                                changeParentTagVisitors.add(new ChangeTagValueVisitor((Xml.Tag)t.getChild("artifactId").get(), targetArtifactId));
                            }
                            if (!oldVersion.equals(targetVersion.get())) {
                                changeParentTagVisitors.add(new ChangeTagValueVisitor((Xml.Tag)t.getChild("version").get(), targetVersion.get()));
                            }
                            if (changeParentTagVisitors.size() > 0) {
                                this.retainVersions();
                                this.doAfterVisit(new RemoveRedundantDependencyVersions(null, null, true, ChangeParentPom.this.retainVersions).getVisitor());
                                for (XmlVisitor xmlVisitor : changeParentTagVisitors) {
                                    this.doAfterVisit((TreeVisitor)xmlVisitor);
                                }
                                this.maybeUpdateModel();
                                this.doAfterVisit(new RemoveRedundantDependencyVersions(null, null, true, null).getVisitor());
                            }
                        }
                    }
                    catch (MavenDownloadingException e) {
                        return e.warn(tag);
                    }
                }
                return t;
            }

            private void retainVersions() {
                for (Recipe retainVersionRecipe : RetainVersions.plan(this, ChangeParentPom.this.retainVersions == null ? Collections.emptyList() : ChangeParentPom.this.retainVersions)) {
                    this.doAfterVisit(retainVersionRecipe.getVisitor());
                }
            }

            private Optional<String> findNewerDependencyVersion(String groupId, String artifactId, String currentVersion, ExecutionContext ctx) throws MavenDownloadingException {
                String finalCurrentVersion;
                String string = finalCurrentVersion = !Semver.isVersion((String)currentVersion) ? "0.0.0" : currentVersion;
                if (this.availableVersions == null) {
                    MavenMetadata mavenMetadata = ChangeParentPom.this.metadataFailures.insertRows(ctx, () -> this.downloadMetadata(groupId, artifactId, ctx));
                    this.availableVersions = mavenMetadata.getVersioning().getVersions().stream().filter(v -> versionComparator.isValid(finalCurrentVersion, v)).filter(v -> Boolean.TRUE.equals(ChangeParentPom.this.allowVersionDowngrades) || versionComparator.compare(finalCurrentVersion, finalCurrentVersion, v) < 0).collect(Collectors.toList());
                }
                return Boolean.TRUE.equals(ChangeParentPom.this.allowVersionDowngrades) ? this.availableVersions.stream().max((v1, v2) -> versionComparator.compare(finalCurrentVersion, v1, v2)) : versionComparator.upgrade(finalCurrentVersion, this.availableVersions);
            }
        });
    }

    public ChangeParentPom(String oldGroupId, @Nullable String newGroupId, String oldArtifactId, @Nullable String newArtifactId, String newVersion, @Nullable String versionPattern, @Nullable Boolean allowVersionDowngrades, @Nullable List<String> retainVersions) {
        this.oldGroupId = oldGroupId;
        this.newGroupId = newGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newArtifactId = newArtifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
        this.allowVersionDowngrades = allowVersionDowngrades;
        this.retainVersions = retainVersions;
    }

    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    public String getOldGroupId() {
        return this.oldGroupId;
    }

    @Nullable
    public String getNewGroupId() {
        return this.newGroupId;
    }

    public String getOldArtifactId() {
        return this.oldArtifactId;
    }

    @Nullable
    public String getNewArtifactId() {
        return this.newArtifactId;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @Nullable
    public Boolean getAllowVersionDowngrades() {
        return this.allowVersionDowngrades;
    }

    @Nullable
    public List<String> getRetainVersions() {
        return this.retainVersions;
    }

    @NonNull
    public String toString() {
        return "ChangeParentPom(metadataFailures=" + (Object)((Object)this.getMetadataFailures()) + ", oldGroupId=" + this.getOldGroupId() + ", newGroupId=" + this.getNewGroupId() + ", oldArtifactId=" + this.getOldArtifactId() + ", newArtifactId=" + this.getNewArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ", allowVersionDowngrades=" + this.getAllowVersionDowngrades() + ", retainVersions=" + this.getRetainVersions() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeParentPom)) {
            return false;
        }
        ChangeParentPom other = (ChangeParentPom)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$allowVersionDowngrades = this.getAllowVersionDowngrades();
        Boolean other$allowVersionDowngrades = other.getAllowVersionDowngrades();
        if (this$allowVersionDowngrades == null ? other$allowVersionDowngrades != null : !((Object)this$allowVersionDowngrades).equals(other$allowVersionDowngrades)) {
            return false;
        }
        String this$oldGroupId = this.getOldGroupId();
        String other$oldGroupId = other.getOldGroupId();
        if (this$oldGroupId == null ? other$oldGroupId != null : !this$oldGroupId.equals(other$oldGroupId)) {
            return false;
        }
        String this$newGroupId = this.getNewGroupId();
        String other$newGroupId = other.getNewGroupId();
        if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
            return false;
        }
        String this$oldArtifactId = this.getOldArtifactId();
        String other$oldArtifactId = other.getOldArtifactId();
        if (this$oldArtifactId == null ? other$oldArtifactId != null : !this$oldArtifactId.equals(other$oldArtifactId)) {
            return false;
        }
        String this$newArtifactId = this.getNewArtifactId();
        String other$newArtifactId = other.getNewArtifactId();
        if (this$newArtifactId == null ? other$newArtifactId != null : !this$newArtifactId.equals(other$newArtifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        List<String> this$retainVersions = this.getRetainVersions();
        List<String> other$retainVersions = other.getRetainVersions();
        return !(this$retainVersions == null ? other$retainVersions != null : !((Object)this$retainVersions).equals(other$retainVersions));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeParentPom;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $allowVersionDowngrades = this.getAllowVersionDowngrades();
        result = result * 59 + ($allowVersionDowngrades == null ? 43 : ((Object)$allowVersionDowngrades).hashCode());
        String $oldGroupId = this.getOldGroupId();
        result = result * 59 + ($oldGroupId == null ? 43 : $oldGroupId.hashCode());
        String $newGroupId = this.getNewGroupId();
        result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
        String $oldArtifactId = this.getOldArtifactId();
        result = result * 59 + ($oldArtifactId == null ? 43 : $oldArtifactId.hashCode());
        String $newArtifactId = this.getNewArtifactId();
        result = result * 59 + ($newArtifactId == null ? 43 : $newArtifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        List<String> $retainVersions = this.getRetainVersions();
        result = result * 59 + ($retainVersions == null ? 43 : ((Object)$retainVersions).hashCode());
        return result;
    }
}

