/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class ChangeDependencyGroupIdAndArtifactId
extends Recipe {
    private final MavenMetadataFailures metadataFailures = new MavenMetadataFailures(this);
    @Option(displayName="Old groupId", description="The old groupId to replace. The groupId is the first part of a dependency coordinate `com.google.guava:guava:VERSION`. Supports glob expressions.", example="org.openrewrite.recipe")
    private final String oldGroupId;
    @Option(displayName="Old artifactId", description="The old artifactId to replace. The artifactId is the second part of a dependency coordinate `com.google.guava:guava:VERSION`. Supports glob expressions.", example="rewrite-testing-frameworks")
    private final String oldArtifactId;
    @Option(displayName="New groupId", description="The new groupId to use. Defaults to the existing group id.", example="corp.internal.openrewrite.recipe", required=false)
    @Nullable
    private final String newGroupId;
    @Option(displayName="New artifactId", description="The new artifactId to use. Defaults to the existing artifact id.", example="rewrite-testing-frameworks", required=false)
    @Nullable
    private final String newArtifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number.", example="29.X", required=false)
    @Nullable
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;
    @Option(displayName="Override managed version", description="If the new dependency has a managed version, this flag can be used to explicitly set the version on the dependency. The default for this flag is `false`.", required=false)
    @Nullable
    private final Boolean overrideManagedVersion;

    public ChangeDependencyGroupIdAndArtifactId(String oldGroupId, String oldArtifactId, @Nullable String newGroupId, @Nullable String newArtifactId, @Nullable String newVersion, @Nullable String versionPattern) {
        this.oldGroupId = oldGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newGroupId = newGroupId;
        this.newArtifactId = newArtifactId;
        this.newVersion = newVersion;
        this.overrideManagedVersion = false;
        this.versionPattern = versionPattern;
    }

    @JsonCreator
    public ChangeDependencyGroupIdAndArtifactId(String oldGroupId, String oldArtifactId, @Nullable String newGroupId, @Nullable String newArtifactId, @Nullable String newVersion, @Nullable String versionPattern, @Nullable Boolean overrideManagedVersion) {
        this.oldGroupId = oldGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newGroupId = newGroupId;
        this.newArtifactId = newArtifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
        this.overrideManagedVersion = overrideManagedVersion;
    }

    public Validated validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    public String getDisplayName() {
        return "Change Maven dependency groupId, artifactId and/or the version";
    }

    public String getDescription() {
        return "Change the groupId, artifactId and/or the version of a specified Maven dependency.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){
            @Nullable
            final VersionComparator versionComparator;
            @Nullable
            private Collection<String> availableVersions;
            {
                this.versionComparator = ChangeDependencyGroupIdAndArtifactId.this.newVersion != null ? (VersionComparator)Semver.validate((String)ChangeDependencyGroupIdAndArtifactId.this.newVersion, (String)ChangeDependencyGroupIdAndArtifactId.this.versionPattern).getValue() : null;
            }

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (this.isDependencyTag(ChangeDependencyGroupIdAndArtifactId.this.oldGroupId, ChangeDependencyGroupIdAndArtifactId.this.oldArtifactId)) {
                    String groupId = ChangeDependencyGroupIdAndArtifactId.this.newGroupId;
                    if (groupId != null) {
                        t = this.changeChildTagValue(t, "groupId", groupId, ctx);
                    } else {
                        groupId = (String)t.getChildValue("groupId").orElseThrow(NoSuchElementException::new);
                    }
                    String artifactId = ChangeDependencyGroupIdAndArtifactId.this.newArtifactId;
                    if (artifactId != null) {
                        t = this.changeChildTagValue(t, "artifactId", artifactId, ctx);
                    } else {
                        artifactId = (String)t.getChildValue("artifactId").orElseThrow(NoSuchElementException::new);
                    }
                    if (ChangeDependencyGroupIdAndArtifactId.this.newVersion != null) {
                        try {
                            String resolvedNewVersion = this.resolveSemverVersion(ctx, groupId, artifactId);
                            Optional scopeTag = t.getChild("scope");
                            Scope scope = scopeTag.map(xml -> Scope.fromName(xml.getValue().orElse("compile"))).orElse(Scope.Compile);
                            Optional versionTag = t.getChild("version");
                            if (!(versionTag.isPresent() || !Boolean.TRUE.equals(ChangeDependencyGroupIdAndArtifactId.this.overrideManagedVersion) && this.isDependencyManaged(scope, groupId, artifactId))) {
                                Xml.Tag newVersionTag = Xml.Tag.build((String)("<version>" + resolvedNewVersion + "</version>"));
                                t = (Xml.Tag)new AddToTagVisitor(t, newVersionTag, (Comparator)new MavenTagInsertionComparator(t.getChildren())).visitNonNull((Tree)t, (Object)ctx, this.getCursor().getParent());
                            } else if (versionTag.isPresent()) {
                                t = this.isDependencyManaged(scope, groupId, artifactId) && !Boolean.TRUE.equals(ChangeDependencyGroupIdAndArtifactId.this.overrideManagedVersion) ? (Xml.Tag)new RemoveContentVisitor((Content)versionTag.get(), false).visit((Tree)t, (Object)ctx) : this.changeChildTagValue(t, "version", resolvedNewVersion, ctx);
                            }
                        }
                        catch (MavenDownloadingException e) {
                            return (Xml)e.warn(tag);
                        }
                    }
                    if (t != tag) {
                        this.maybeUpdateModel();
                    }
                }
                return t;
            }

            private Xml.Tag changeChildTagValue(Xml.Tag tag, String childTagName, String newValue, ExecutionContext ctx) {
                Optional childTag = tag.getChild(childTagName);
                if (childTag.isPresent() && !newValue.equals(((Xml.Tag)childTag.get()).getValue().orElse(null))) {
                    tag = (Xml.Tag)new ChangeTagValueVisitor((Xml.Tag)childTag.get(), newValue).visitNonNull((Tree)tag, (Object)ctx);
                }
                return tag;
            }

            private boolean isDependencyManaged(Scope scope, String groupId, String artifactId) {
                MavenResolutionResult result = this.getResolutionResult();
                for (ResolvedManagedDependency managedDependency : result.getPom().getDependencyManagement()) {
                    if (!groupId.equals(managedDependency.getGroupId()) || !artifactId.equals(managedDependency.getArtifactId())) continue;
                    return scope.isInClasspathOf(managedDependency.getScope());
                }
                return false;
            }

            private String resolveSemverVersion(ExecutionContext ctx, String groupId, String artifactId) throws MavenDownloadingException {
                if (this.versionComparator == null) {
                    return ChangeDependencyGroupIdAndArtifactId.this.newVersion;
                }
                if (this.availableVersions == null) {
                    this.availableVersions = new ArrayList<String>();
                    MavenMetadata mavenMetadata = ChangeDependencyGroupIdAndArtifactId.this.metadataFailures.insertRows(ctx, () -> this.downloadMetadata(groupId, artifactId, ctx));
                    for (String v : mavenMetadata.getVersioning().getVersions()) {
                        if (!this.versionComparator.isValid(ChangeDependencyGroupIdAndArtifactId.this.newVersion, v)) continue;
                        this.availableVersions.add(v);
                    }
                }
                return this.availableVersions.isEmpty() ? ChangeDependencyGroupIdAndArtifactId.this.newVersion : Collections.max(this.availableVersions, this.versionComparator);
            }
        };
    }

    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    public String getOldGroupId() {
        return this.oldGroupId;
    }

    public String getOldArtifactId() {
        return this.oldArtifactId;
    }

    @Nullable
    public String getNewGroupId() {
        return this.newGroupId;
    }

    @Nullable
    public String getNewArtifactId() {
        return this.newArtifactId;
    }

    @Nullable
    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @Nullable
    public Boolean getOverrideManagedVersion() {
        return this.overrideManagedVersion;
    }

    @NonNull
    public String toString() {
        return "ChangeDependencyGroupIdAndArtifactId(metadataFailures=" + (Object)((Object)this.getMetadataFailures()) + ", oldGroupId=" + this.getOldGroupId() + ", oldArtifactId=" + this.getOldArtifactId() + ", newGroupId=" + this.getNewGroupId() + ", newArtifactId=" + this.getNewArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ", overrideManagedVersion=" + this.getOverrideManagedVersion() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeDependencyGroupIdAndArtifactId)) {
            return false;
        }
        ChangeDependencyGroupIdAndArtifactId other = (ChangeDependencyGroupIdAndArtifactId)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$overrideManagedVersion = this.getOverrideManagedVersion();
        Boolean other$overrideManagedVersion = other.getOverrideManagedVersion();
        if (this$overrideManagedVersion == null ? other$overrideManagedVersion != null : !((Object)this$overrideManagedVersion).equals(other$overrideManagedVersion)) {
            return false;
        }
        String this$oldGroupId = this.getOldGroupId();
        String other$oldGroupId = other.getOldGroupId();
        if (this$oldGroupId == null ? other$oldGroupId != null : !this$oldGroupId.equals(other$oldGroupId)) {
            return false;
        }
        String this$oldArtifactId = this.getOldArtifactId();
        String other$oldArtifactId = other.getOldArtifactId();
        if (this$oldArtifactId == null ? other$oldArtifactId != null : !this$oldArtifactId.equals(other$oldArtifactId)) {
            return false;
        }
        String this$newGroupId = this.getNewGroupId();
        String other$newGroupId = other.getNewGroupId();
        if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
            return false;
        }
        String this$newArtifactId = this.getNewArtifactId();
        String other$newArtifactId = other.getNewArtifactId();
        if (this$newArtifactId == null ? other$newArtifactId != null : !this$newArtifactId.equals(other$newArtifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeDependencyGroupIdAndArtifactId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $overrideManagedVersion = this.getOverrideManagedVersion();
        result = result * 59 + ($overrideManagedVersion == null ? 43 : ((Object)$overrideManagedVersion).hashCode());
        String $oldGroupId = this.getOldGroupId();
        result = result * 59 + ($oldGroupId == null ? 43 : $oldGroupId.hashCode());
        String $oldArtifactId = this.getOldArtifactId();
        result = result * 59 + ($oldArtifactId == null ? 43 : $oldArtifactId.hashCode());
        String $newGroupId = this.getNewGroupId();
        result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
        String $newArtifactId = this.getNewArtifactId();
        result = result * 59 + ($newArtifactId == null ? 43 : $newArtifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

