/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.List;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ExcludeDependency
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="guava")
    private final String artifactId;
    @Option(displayName="Scope", description="Match dependencies with the specified scope. If you specify `compile`, this will NOT match dependencies in `runtime`. The purpose of this is to be able to exclude dependencies that should be in a higher scope, e.g. a compile dependency that should be a test dependency.", valid={"compile", "test", "runtime", "provided"}, example="compile", required=false)
    @Nullable
    private final String scope;

    public Validated validate() {
        return super.validate().and(Validated.test((String)"scope", (String)"scope is a valid Maven scope", (Object)this.scope, s -> {
            try {
                if (s != null) {
                    Scope.fromName(s);
                }
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }));
    }

    public String getDisplayName() {
        return "Exclude Maven dependency";
    }

    public String getDescription() {
        return "Exclude specified dependency from any dependency that transitively includes it.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ExcludeDependencyVisitor();
    }

    public ExcludeDependency(String groupId, String artifactId, @Nullable String scope) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.scope = scope;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    @NonNull
    public String toString() {
        return "ExcludeDependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", scope=" + this.getScope() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcludeDependency)) {
            return false;
        }
        ExcludeDependency other = (ExcludeDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ExcludeDependency;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        return result;
    }

    private class ExcludeDependencyVisitor
    extends MavenVisitor<ExecutionContext> {
        @Nullable
        private final Scope scope;

        private ExcludeDependencyVisitor() {
            this.scope = ExcludeDependency.this.scope == null ? null : Scope.fromName(ExcludeDependency.this.scope);
        }

        public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
            ResolvedDependency dependency;
            if (!(!this.isDependencyTag() || (dependency = this.findDependency(tag, this.scope)) == null || StringUtils.matchesGlob((String)dependency.getGroupId(), (String)ExcludeDependency.this.groupId) && StringUtils.matchesGlob((String)dependency.getArtifactId(), (String)ExcludeDependency.this.artifactId) || dependency.findDependency(ExcludeDependency.this.groupId, ExcludeDependency.this.artifactId) == null)) {
                Optional maybeExclusions = tag.getChild("exclusions");
                if (maybeExclusions.isPresent()) {
                    Xml.Tag exclusions = (Xml.Tag)maybeExclusions.get();
                    List individualExclusions = exclusions.getChildren("exclusion");
                    if (individualExclusions.stream().noneMatch(exclusion -> ExcludeDependency.this.groupId.equals(exclusion.getChildValue("groupId").orElse(null)) && ExcludeDependency.this.artifactId.equals(exclusion.getChildValue("artifactId").orElse(null)))) {
                        this.doAfterVisit((TreeVisitor)new AddToTagVisitor(exclusions, Xml.Tag.build((String)("<exclusion>\n<groupId>" + ExcludeDependency.this.groupId + "</groupId>\n<artifactId>" + ExcludeDependency.this.artifactId + "</artifactId>\n</exclusion>"))));
                    }
                } else {
                    this.doAfterVisit((TreeVisitor)new AddToTagVisitor(tag, Xml.Tag.build((String)("<exclusions>\n<exclusion>\n<groupId>" + ExcludeDependency.this.groupId + "</groupId>\n<artifactId>" + ExcludeDependency.this.artifactId + "</artifactId>\n</exclusion>\n</exclusions>"))));
                }
                this.maybeUpdateModel();
            }
            return super.visitTag(tag, (Object)ctx);
        }
    }
}

