/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markup;
import org.openrewrite.maven.ChangePropertyValue;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.RemoveRedundantDependencyVersions;
import org.openrewrite.maven.internal.MavenDownloadingException;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.semver.LatestPatch;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class UpgradeDependencyVersion
extends Recipe {
    private static final Set<String> implicitlyDefinedVersionProperties = new HashSet<String>(Arrays.asList("${version}", "${project.version}", "${pom.version}", "${project.parent.version}"));
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number.", example="29.X")
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;
    @Option(displayName="Override managed version", description="This flag can be set to explicitly override a managed dependency's version. The default for this flag is `false`.", example="false", required=false)
    @Nullable
    private final Boolean overrideManagedVersion;

    public Validated validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    public String getDisplayName() {
        return "Upgrade Maven dependency version";
    }

    public String getDescription() {
        return "Upgrade the version of a dependency by specifying a group or group and artifact using Node Semver advanced range selectors, allowing more precise control over version updates to patch or minor releases.";
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        HashSet<GroupArtifact> projectArtifacts = new HashSet<GroupArtifact>();
        for (SourceFile s2 : before) {
            Optional mavenModel;
            if (!(s2 instanceof Xml.Document) || !(mavenModel = s2.getMarkers().findFirst(MavenResolutionResult.class)).isPresent()) continue;
            ResolvedPom pom = ((MavenResolutionResult)mavenModel.get()).getPom();
            projectArtifacts.add(new GroupArtifact(pom.getGroupId(), pom.getArtifactId()));
        }
        return ListUtils.map(before, s -> (SourceFile)new UpgradeDependencyVersionVisitor(projectArtifacts).visit((Tree)s, ctx));
    }

    public UpgradeDependencyVersion(String groupId, String artifactId, String newVersion, @Nullable String versionPattern, @Nullable Boolean overrideManagedVersion) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
        this.overrideManagedVersion = overrideManagedVersion;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @Nullable
    public Boolean getOverrideManagedVersion() {
        return this.overrideManagedVersion;
    }

    @NonNull
    public String toString() {
        return "UpgradeDependencyVersion(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ", overrideManagedVersion=" + this.getOverrideManagedVersion() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeDependencyVersion)) {
            return false;
        }
        UpgradeDependencyVersion other = (UpgradeDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$overrideManagedVersion = this.getOverrideManagedVersion();
        Boolean other$overrideManagedVersion = other.getOverrideManagedVersion();
        if (this$overrideManagedVersion == null ? other$overrideManagedVersion != null : !((Object)this$overrideManagedVersion).equals(other$overrideManagedVersion)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeDependencyVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $overrideManagedVersion = this.getOverrideManagedVersion();
        result = result * 59 + ($overrideManagedVersion == null ? 43 : ((Object)$overrideManagedVersion).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }

    private class UpgradeDependencyVersionVisitor
    extends MavenIsoVisitor<ExecutionContext> {
        private final VersionComparator versionComparator;
        private final Set<GroupArtifact> projectArtifacts;

        private UpgradeDependencyVersionVisitor(Set<GroupArtifact> projectArtifacts) {
            this.versionComparator = (VersionComparator)Semver.validate((String)UpgradeDependencyVersion.this.newVersion, (String)UpgradeDependencyVersion.this.versionPattern).getValue();
            assert (this.versionComparator != null);
            this.projectArtifacts = projectArtifacts;
        }

        @Override
        public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
            Xml.Document d = super.visitDocument(document, ctx);
            if (d != document) {
                this.maybeUpdateModel();
                this.doAfterVisit(new RemoveRedundantDependencyVersions(null, null, true));
            }
            return d;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            Xml.Tag t = super.visitTag(tag, ctx);
            try {
                ResolvedGroupArtifactVersion bom;
                ResolvedManagedDependency dm;
                block10: {
                    if (this.isDependencyTag(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId)) {
                        String requestedVersion;
                        ResolvedDependency d = this.findDependency(t);
                        if (d == null) return t;
                        if (d.getRepository() == null) return t;
                        String newerVersion = this.findNewerVersion(d.getGroupId(), d.getArtifactId(), d.getVersion(), ctx);
                        if (newerVersion == null) return t;
                        Optional version = t.getChild("version");
                        if (version.isPresent()) {
                            String requestedVersion2 = d.getRequested().getVersion();
                            if (requestedVersion2 == null) return (Xml.Tag)new ChangeTagValueVisitor((Xml.Tag)version.get(), newerVersion).visitNonNull((Tree)t, (Object)0, this.getCursor());
                            if (!requestedVersion2.startsWith("${")) return (Xml.Tag)new ChangeTagValueVisitor((Xml.Tag)version.get(), newerVersion).visitNonNull((Tree)t, (Object)0, this.getCursor());
                            if (implicitlyDefinedVersionProperties.contains(requestedVersion2)) return (Xml.Tag)new ChangeTagValueVisitor((Xml.Tag)version.get(), newerVersion).visitNonNull((Tree)t, (Object)0, this.getCursor());
                            this.doAfterVisit(new ChangePropertyValue(requestedVersion2.substring(2, requestedVersion2.length() - 1), newerVersion, UpgradeDependencyVersion.this.overrideManagedVersion, false));
                            return t;
                        }
                        if (!Boolean.TRUE.equals(UpgradeDependencyVersion.this.overrideManagedVersion)) return t;
                        ResolvedManagedDependency dm2 = this.findManagedDependency(t);
                        if (dm2 != null && (requestedVersion = dm2.getRequested().getVersion()) != null && requestedVersion.startsWith("${") && !implicitlyDefinedVersionProperties.contains(requestedVersion)) {
                            this.doAfterVisit(new ChangePropertyValue(requestedVersion.substring(2, requestedVersion.length() - 1), newerVersion, UpgradeDependencyVersion.this.overrideManagedVersion, false));
                            return t;
                        }
                        Xml.Tag versionTag = Xml.Tag.build((String)("<version>" + newerVersion + "</version>"));
                        return (Xml.Tag)new AddToTagVisitor(t, versionTag, (Comparator)new MavenTagInsertionComparator(t.getChildren())).visitNonNull((Tree)t, (Object)ctx, this.getCursor().getParent());
                    }
                    if (!this.isManagedDependencyTag(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId)) return t;
                    ResolvedManagedDependency matchedManagedDependency = this.findManagedDependency(t);
                    if (matchedManagedDependency != null) {
                        if (this.projectArtifacts.contains(new GroupArtifact(matchedManagedDependency.getGroupId(), matchedManagedDependency.getArtifactId()))) return t;
                        if (!StringUtils.matchesGlob((String)matchedManagedDependency.getGroupId(), (String)UpgradeDependencyVersion.this.groupId)) return t;
                        if (!StringUtils.matchesGlob((String)matchedManagedDependency.getArtifactId(), (String)UpgradeDependencyVersion.this.artifactId)) return t;
                        if (matchedManagedDependency.getVersion() == null) return t;
                        String requestedVersion = matchedManagedDependency.getRequested().getVersion();
                        String newerVersion = this.findNewerVersion(matchedManagedDependency.getGroupId(), matchedManagedDependency.getArtifactId(), matchedManagedDependency.getVersion(), ctx);
                        if (newerVersion == null) return t;
                        if (requestedVersion != null && requestedVersion.startsWith("${")) {
                            this.doAfterVisit(new ChangePropertyValue(requestedVersion.substring(2, requestedVersion.length() - 1), newerVersion, UpgradeDependencyVersion.this.overrideManagedVersion, false));
                            return t;
                        }
                        Xml.Tag childVersionTag = t.getChild("version").orElse(null);
                        if (childVersionTag == null) return t;
                        return (Xml.Tag)new ChangeTagValueVisitor(childVersionTag, newerVersion).visitNonNull((Tree)t, (Object)0, this.getCursor());
                    }
                    Iterator<ResolvedManagedDependency> iterator = this.getResolutionResult().getPom().getDependencyManagement().iterator();
                    while (iterator.hasNext()) {
                        String tagArtifactId;
                        String tagGroup;
                        dm = iterator.next();
                        if (dm.getBomGav() == null || this.projectArtifacts.contains(new GroupArtifact(tagGroup = this.getResolutionResult().getPom().getValue(tag.getChildValue("groupId").orElse(this.getResolutionResult().getPom().getGroupId())), tagArtifactId = this.getResolutionResult().getPom().getValue(tag.getChildValue("artifactId").orElse(""))))) continue;
                        bom = dm.getBomGav();
                        if (tagGroup == null || tagArtifactId == null || !tagGroup.equals(bom.getGroupId()) || !tagArtifactId.equals(bom.getArtifactId())) {
                            continue;
                        }
                        break block10;
                    }
                    return t;
                }
                String requestedVersion = dm.getRequestedBom().getVersion();
                String newerVersion = this.findNewerVersion(bom.getGroupId(), bom.getArtifactId(), bom.getVersion(), ctx);
                if (newerVersion == null) return t;
                if (requestedVersion != null && requestedVersion.startsWith("${")) {
                    this.doAfterVisit(new ChangePropertyValue(requestedVersion.substring(2, requestedVersion.length() - 1), newerVersion, UpgradeDependencyVersion.this.overrideManagedVersion, false));
                    return t;
                }
                Xml.Tag childVersionTag = t.getChild("version").orElse(null);
                if (childVersionTag == null) return t;
                return (Xml.Tag)new ChangeTagValueVisitor(childVersionTag, newerVersion).visitNonNull((Tree)t, (Object)0, this.getCursor());
            }
            catch (MavenDownloadingException exception) {
                return (Xml.Tag)Markup.warn((Tree)t, (String)"Unable to download Maven metadata", (Throwable)exception);
            }
        }

        @Nullable
        private String findNewerVersion(String groupId, String artifactId, String version, ExecutionContext ctx) {
            if (this.versionComparator instanceof LatestPatch && !this.versionComparator.isValid(version, version)) {
                return null;
            }
            try {
                MavenMetadata mavenMetadata = this.downloadMetadata(groupId, artifactId, ctx);
                ArrayList<String> versions = new ArrayList<String>();
                for (String v : mavenMetadata.getVersioning().getVersions()) {
                    if (!this.versionComparator.isValid(version, v)) continue;
                    versions.add(v);
                }
                return this.versionComparator.upgrade(version, versions).orElse(null);
            }
            catch (IllegalStateException e) {
                ctx.getOnError().accept(e);
                return null;
            }
        }
    }
}

