/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openrewrite.DelegatingExecutionContext;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.cache.InMemoryMavenPomCache;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.MavenParsingException;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenRepositoryCredentials;
import org.openrewrite.maven.tree.MavenRepositoryMirror;
import org.openrewrite.maven.tree.ResolutionEventListener;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;

public class MavenExecutionContextView
extends DelegatingExecutionContext {
    private static final MavenPomCache DEFAULT_POM_CACHE = new InMemoryMavenPomCache();
    private static final String MAVEN_MIRRORS = "org.openrewrite.maven.mirrors";
    private static final String MAVEN_CREDENTIALS = "org.openrewrite.maven.auth";
    private static final String MAVEN_LOCAL_REPOSITORY = "org.openrewrite.maven.localRepo";
    private static final String MAVEN_REPOSITORIES = "org.openrewrite.maven.repos";
    private static final String MAVEN_PINNED_SNAPSHOT_VERSIONS = "org.openrewrite.maven.pinnedSnapshotVersions";
    private static final String MAVEN_POM_CACHE = "org.openrewrite.maven.pomCache";
    private static final String MAVEN_RESOLUTION_LISTENER = "org.openrewrite.maven.resolutionListener";

    public MavenExecutionContextView(ExecutionContext delegate) {
        super(delegate);
    }

    public static MavenExecutionContextView view(ExecutionContext ctx) {
        if (ctx instanceof MavenExecutionContextView) {
            return (MavenExecutionContextView)ctx;
        }
        return new MavenExecutionContextView(ctx);
    }

    public MavenExecutionContextView setResolutionListener(ResolutionEventListener listener) {
        this.putMessage(MAVEN_RESOLUTION_LISTENER, listener);
        return this;
    }

    public ResolutionEventListener getResolutionListener() {
        return (ResolutionEventListener)this.getMessage(MAVEN_RESOLUTION_LISTENER, ResolutionEventListener.NOOP);
    }

    public MavenExecutionContextView setMirrors(Collection<MavenRepositoryMirror> mirrors) {
        this.putMessage(MAVEN_MIRRORS, mirrors);
        return this;
    }

    public Collection<MavenRepositoryMirror> getMirrors() {
        return (Collection)this.getMessage(MAVEN_MIRRORS, Collections.emptyList());
    }

    public MavenExecutionContextView setCredentials(Collection<MavenRepositoryCredentials> credentials) {
        this.putMessage(MAVEN_CREDENTIALS, credentials);
        return this;
    }

    public Collection<MavenRepositoryCredentials> getCredentials() {
        return (Collection)this.getMessage(MAVEN_CREDENTIALS, Collections.emptyList());
    }

    public MavenExecutionContextView setPomCache(MavenPomCache pomCache) {
        this.putMessage(MAVEN_POM_CACHE, pomCache);
        return this;
    }

    public MavenPomCache getPomCache() {
        return (MavenPomCache)this.getMessage(MAVEN_POM_CACHE, DEFAULT_POM_CACHE);
    }

    public MavenExecutionContextView setLocalRepository(MavenRepository localRepository) {
        this.putMessage(MAVEN_LOCAL_REPOSITORY, localRepository);
        return this;
    }

    public MavenRepository getLocalRepository() {
        return (MavenRepository)this.getMessage(MAVEN_LOCAL_REPOSITORY, MavenRepository.MAVEN_LOCAL_DEFAULT);
    }

    public MavenExecutionContextView setRepositories(List<MavenRepository> repositories) {
        this.putMessage(MAVEN_REPOSITORIES, repositories);
        return this;
    }

    public List<MavenRepository> getRepositories() {
        return (List)this.getMessage(MAVEN_REPOSITORIES, Collections.emptyList());
    }

    public MavenExecutionContextView setPinnedSnapshotVersions(Collection<ResolvedGroupArtifactVersion> pinnedSnapshotVersions) {
        this.putMessage(MAVEN_PINNED_SNAPSHOT_VERSIONS, pinnedSnapshotVersions);
        return this;
    }

    public Collection<ResolvedGroupArtifactVersion> getPinnedSnapshotVersions() {
        return (Collection)this.getMessage(MAVEN_PINNED_SNAPSHOT_VERSIONS, Collections.emptyList());
    }

    public MavenExecutionContextView setMavenSettings(@Nullable MavenSettings settings, String ... activeProfiles) {
        if (settings == null) {
            return this;
        }
        if (settings.getServers() != null) {
            this.setCredentials(settings.getServers().getServers().stream().map(server -> new MavenRepositoryCredentials(server.getId(), server.getUsername(), server.getPassword())).collect(Collectors.toList()));
        }
        if (settings.getMirrors() != null) {
            this.setMirrors(settings.getMirrors().getMirrors().stream().map(mirror -> new MavenRepositoryMirror(mirror.getId(), mirror.getUrl(), mirror.getMirrorOf(), mirror.getReleases(), mirror.getSnapshots())).collect(Collectors.toList()));
        }
        this.setLocalRepository(settings.getMavenLocal());
        this.setRepositories(settings.getActiveRepositories(Arrays.asList(activeProfiles)).stream().map(repo -> {
            try {
                return new MavenRepository(repo.getId(), repo.getUrl(), repo.getReleases() == null || repo.getReleases().isEnabled(), repo.getSnapshots() != null && repo.getSnapshots().isEnabled(), null, null);
            }
            catch (Exception exception) {
                this.getOnError().accept(new MavenParsingException("Unable to parse URL %s for Maven settings repository id %s", exception, repo.getUrl(), repo.getId()));
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()));
        return this;
    }
}

