/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.List;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.tree.Xml;

public final class RemoveExclusion
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="guava")
    private final String artifactId;
    @Option(displayName="Group", description="The first part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="com.google.guava")
    private final String exclusionGroupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="guava")
    private final String exclusionArtifactId;

    public String getDisplayName() {
        return "Remove exclusion";
    }

    public String getDescription() {
        return "Remove a single exclusion from on a particular dependency.";
    }

    public MavenVisitor<ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext executionContext) {
                Optional maybeExclusions;
                if ((this.isDependencyTag(RemoveExclusion.this.groupId, RemoveExclusion.this.artifactId) || this.isManagedDependencyTag(RemoveExclusion.this.groupId, RemoveExclusion.this.artifactId)) && (maybeExclusions = tag.getChild("exclusions")).isPresent()) {
                    return tag.withContent(ListUtils.map((List)tag.getChildren(), child -> {
                        if ("exclusions".equals(child.getName())) {
                            Xml.Tag e = child;
                            if (e.getContent() != null && ((e = e.withContent(ListUtils.map((List)e.getChildren(), exclusion -> {
                                if ("exclusion".equals(exclusion.getName()) && exclusion.getChildValue("groupId").map(g -> g.equals(RemoveExclusion.this.exclusionGroupId)).orElse(false).booleanValue() && exclusion.getChildValue("artifactId").map(g -> g.equals(RemoveExclusion.this.exclusionArtifactId)).orElse(false).booleanValue()) {
                                    return null;
                                }
                                return exclusion;
                            }))).getContent() == null || e.getContent().isEmpty())) {
                                return null;
                            }
                            return e;
                        }
                        return child;
                    }));
                }
                return super.visitTag(tag, (Object)executionContext);
            }
        };
    }

    public RemoveExclusion(String groupId, String artifactId, String exclusionGroupId, String exclusionArtifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.exclusionGroupId = exclusionGroupId;
        this.exclusionArtifactId = exclusionArtifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getExclusionGroupId() {
        return this.exclusionGroupId;
    }

    public String getExclusionArtifactId() {
        return this.exclusionArtifactId;
    }

    @NonNull
    public String toString() {
        return "RemoveExclusion(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", exclusionGroupId=" + this.getExclusionGroupId() + ", exclusionArtifactId=" + this.getExclusionArtifactId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveExclusion)) {
            return false;
        }
        RemoveExclusion other = (RemoveExclusion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$exclusionGroupId = this.getExclusionGroupId();
        String other$exclusionGroupId = other.getExclusionGroupId();
        if (this$exclusionGroupId == null ? other$exclusionGroupId != null : !this$exclusionGroupId.equals(other$exclusionGroupId)) {
            return false;
        }
        String this$exclusionArtifactId = this.getExclusionArtifactId();
        String other$exclusionArtifactId = other.getExclusionArtifactId();
        return !(this$exclusionArtifactId == null ? other$exclusionArtifactId != null : !this$exclusionArtifactId.equals(other$exclusionArtifactId));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveExclusion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $exclusionGroupId = this.getExclusionGroupId();
        result = result * 59 + ($exclusionGroupId == null ? 43 : $exclusionGroupId.hashCode());
        String $exclusionArtifactId = this.getExclusionArtifactId();
        result = result * 59 + ($exclusionArtifactId == null ? 43 : $exclusionArtifactId.hashCode());
        return result;
    }
}

