/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.ipc.http.HttpUrlConnectionSender;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ManagedDependency;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.Parent;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.xml.tree.Xml;

public class UpdateMavenModel<P>
extends MavenVisitor<P> {
    public Xml visitDocument(Xml.Document document, P p) {
        Xml.Document d = document;
        if (!(p instanceof ExecutionContext)) {
            throw new IllegalArgumentException("UpdateMavenModel must be provided an ExecutionContext");
        }
        ExecutionContext ctx = (ExecutionContext)p;
        d = d.withMarkers(d.getMarkers().computeByType((Marker)this.getResolutionResult(), (resolutionResult, ignored) -> {
            Pom requested = resolutionResult.getPom().getRequested();
            Optional parent = document.getRoot().getChild("parent");
            if (parent.isPresent()) {
                Parent updatedParent = new Parent(new GroupArtifactVersion(((Xml.Tag)parent.get()).getChildValue("groupId").orElse(null), (String)((Xml.Tag)parent.get()).getChildValue("artifactId").orElseThrow(() -> new IllegalStateException("GAV must have artifactId")), ((Xml.Tag)parent.get()).getChildValue("version").orElse(null)), ((Xml.Tag)parent.get()).getChildValue("relativePath").orElse(null));
                requested = requested.withParent(updatedParent);
            } else if (requested.getParent() != null) {
                requested = requested.withParent(null);
            }
            Optional dependencies = document.getRoot().getChild("dependencies");
            if (dependencies.isPresent()) {
                List eachDependency = ((Xml.Tag)dependencies.get()).getChildren("dependency");
                ArrayList<Dependency> requestedDependencies = new ArrayList<Dependency>(eachDependency.size());
                for (Xml.Tag dependency : eachDependency) {
                    requestedDependencies.add(new Dependency(new GroupArtifactVersion(dependency.getChildValue("groupId").orElse(null), (String)dependency.getChildValue("artifactId").orElseThrow(() -> new IllegalStateException("Dependency must have artifactId")), dependency.getChildValue("version").orElse(null)), dependency.getChildValue("classifier").orElse(null), dependency.getChildValue("type").orElse(null), dependency.getChildValue("scope").orElse("compile"), this.mapExclusions(dependency), dependency.getChildValue("optional").map(Boolean::parseBoolean).orElse(false)));
                }
                requested = requested.withDependencies(requestedDependencies);
            } else if (!requested.getDependencies().isEmpty()) {
                requested = requested.withDependencies(Collections.emptyList());
            }
            Optional dependencyManagement = document.getRoot().getChild("dependencyManagement");
            if (dependencyManagement.isPresent()) {
                dependencies = ((Xml.Tag)dependencyManagement.get()).getChild("dependencies");
                if (dependencies.isPresent()) {
                    List eachDependency = ((Xml.Tag)dependencies.get()).getChildren("dependency");
                    ArrayList<ManagedDependency> requestedManagedDependencies = new ArrayList<ManagedDependency>(eachDependency.size());
                    for (Xml.Tag dependency : eachDependency) {
                        String scope = dependency.getChildValue("scope").orElse("compile");
                        GroupArtifactVersion gav = new GroupArtifactVersion(dependency.getChildValue("groupId").orElse(null), (String)dependency.getChildValue("artifactId").orElseThrow(() -> new IllegalStateException("Dependency must have artifactId")), dependency.getChildValue("version").orElse(null));
                        if ("import".equals(scope)) {
                            requestedManagedDependencies.add(new ManagedDependency.Imported(gav));
                            continue;
                        }
                        requestedManagedDependencies.add(new ManagedDependency.Defined(gav, scope, dependency.getChildValue("type").orElse(null), dependency.getChildValue("classifier").orElse(null), this.mapExclusions(dependency)));
                    }
                    requested = requested.withDependencyManagement(requestedManagedDependencies);
                }
            } else if (!requested.getDependencyManagement().isEmpty()) {
                requested = requested.withDependencyManagement(Collections.emptyList());
            }
            return this.updateResult(ctx, resolutionResult.withPom(resolutionResult.getPom().withRequested(requested)), resolutionResult.getProjectPoms());
        }));
        return d;
    }

    @Nullable
    private List<GroupArtifact> mapExclusions(Xml.Tag tag) {
        return tag.getChild("exclusions").map(exclusions -> {
            List eachExclusion = exclusions.getChildren("exclusion");
            ArrayList<GroupArtifact> requestedExclusions = new ArrayList<GroupArtifact>(eachExclusion.size());
            for (Xml.Tag exclusion : eachExclusion) {
                requestedExclusions.add(new GroupArtifact(exclusion.getChildValue("groupId").orElse(null), exclusion.getChildValue("artifactId").orElse(null)));
            }
            return requestedExclusions;
        }).orElse(null);
    }

    private MavenResolutionResult updateResult(ExecutionContext ctx, MavenResolutionResult resolutionResult, Map<Path, Pom> projectPoms) {
        MavenPomDownloader downloader = new MavenPomDownloader(projectPoms, (HttpSender)new HttpUrlConnectionSender(), ctx);
        ResolvedPom resolved = resolutionResult.getPom().resolve(ctx, downloader);
        return resolutionResult.withPom(resolved).withModules(ListUtils.map(resolutionResult.getModules(), module -> this.updateResult(ctx, (MavenResolutionResult)module, projectPoms))).resolveDependencies(downloader, ctx);
    }
}

